/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.pointer;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetIndexPointerNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetMemberPointerNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignReadNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignWriteNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAddressEqualsNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointerImpl;
import com.oracle.truffle.llvm.spi.ReferenceLibrary;

@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class, receiverType=LLVMPointerImpl.class), @ExportLibrary(value=ReferenceLibrary.class, receiverType=LLVMPointerImpl.class)})
abstract class CommonPointerLibraries {
    CommonPointerLibraries() {
    }

    @ExportMessage
    static boolean hasMembers(LLVMPointerImpl receiver) {
        return receiver.getExportType() instanceof LLVMInteropType.Struct;
    }

    @ExportMessage
    static Object getMembers(LLVMPointerImpl receiver, boolean includeInternal, @Cached.Shared(value="isObject") @Cached ConditionProfile isObject) throws UnsupportedMessageException {
        if (isObject.profile(receiver.getExportType() instanceof LLVMInteropType.Struct)) {
            LLVMInteropType.Struct struct = (LLVMInteropType.Struct)receiver.getExportType();
            return new Keys(struct);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean isMemberReadable(LLVMPointerImpl receiver, String ident, @Cached.Shared(value="isObject") @Cached ConditionProfile isObject) {
        if (isObject.profile(receiver.getExportType() instanceof LLVMInteropType.Struct)) {
            LLVMInteropType.Struct struct = (LLVMInteropType.Struct)receiver.getExportType();
            LLVMInteropType.StructMember member = struct.findMember(ident);
            return member != null;
        }
        return false;
    }

    @ExportMessage
    static Object readMember(LLVMPointerImpl receiver, String ident, @Cached.Shared(value="getMember") @Cached LLVMForeignGetMemberPointerNode getElementPointer, @Cached.Exclusive @Cached LLVMForeignReadNode read) throws UnsupportedMessageException, UnknownIdentifierException {
        LLVMPointer ptr = getElementPointer.execute(receiver.getExportType(), receiver, ident);
        return read.execute(ptr, ptr.getExportType());
    }

    @ExportMessage
    static boolean isMemberModifiable(LLVMPointerImpl receiver, String ident, @Cached.Shared(value="isObject") @Cached ConditionProfile isObject) {
        if (isObject.profile(receiver.getExportType() instanceof LLVMInteropType.Struct)) {
            LLVMInteropType.Struct struct = (LLVMInteropType.Struct)receiver.getExportType();
            LLVMInteropType.StructMember member = struct.findMember(ident);
            if (member == null) {
                return false;
            }
            return member.getType() instanceof LLVMInteropType.Value;
        }
        return false;
    }

    @ExportMessage
    static boolean isMemberInsertable(LLVMPointerImpl receiver, String ident) {
        return false;
    }

    @ExportMessage
    static void writeMember(LLVMPointerImpl receiver, String ident, Object value, @Cached.Shared(value="getMember") @Cached LLVMForeignGetMemberPointerNode getElementPointer, @Cached.Exclusive @Cached LLVMForeignWriteNode write) throws UnsupportedMessageException, UnknownIdentifierException {
        LLVMPointer ptr = getElementPointer.execute(receiver.getExportType(), receiver, ident);
        write.execute(ptr, ptr.getExportType(), value);
    }

    @ExportMessage
    static boolean hasArrayElements(LLVMPointerImpl receiver) {
        return receiver.getExportType() instanceof LLVMInteropType.Array;
    }

    @ExportMessage
    static long getArraySize(LLVMPointerImpl receiver, @Cached.Shared(value="isArray") @Cached ConditionProfile isArray) throws UnsupportedMessageException {
        if (isArray.profile(receiver.getExportType() instanceof LLVMInteropType.Array)) {
            return ((LLVMInteropType.Array)receiver.getExportType()).getLength();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean isArrayElementReadable(LLVMPointerImpl receiver, long idx, @Cached.Shared(value="isArray") @Cached ConditionProfile isArray) {
        if (isArray.profile(receiver.getExportType() instanceof LLVMInteropType.Array)) {
            long length = ((LLVMInteropType.Array)receiver.getExportType()).getLength();
            return Long.compareUnsigned(idx, length) < 0;
        }
        return false;
    }

    @ExportMessage
    static Object readArrayElement(LLVMPointerImpl receiver, long idx, @Cached.Shared(value="getIndex") @Cached LLVMForeignGetIndexPointerNode getElementPointer, @Cached.Exclusive @Cached LLVMForeignReadNode read) throws UnsupportedMessageException, InvalidArrayIndexException {
        LLVMPointer ptr = getElementPointer.execute(receiver.getExportType(), receiver, idx);
        return read.execute(ptr, ptr.getExportType());
    }

    @ExportMessage
    static boolean isArrayElementModifiable(LLVMPointerImpl receiver, long idx, @Cached.Shared(value="isArray") @Cached ConditionProfile isArray) {
        if (isArray.profile(receiver.getExportType() instanceof LLVMInteropType.Array)) {
            LLVMInteropType.Array arrayType = (LLVMInteropType.Array)receiver.getExportType();
            if (arrayType.getElementType() instanceof LLVMInteropType.Value) {
                long length = arrayType.getLength();
                return Long.compareUnsigned(idx, length) < 0;
            }
            return false;
        }
        return false;
    }

    @ExportMessage
    static boolean isArrayElementInsertable(LLVMPointerImpl receiver, long idx) {
        return false;
    }

    @ExportMessage
    static void writeArrayElement(LLVMPointerImpl receiver, long idx, Object value, @Cached.Shared(value="getIndex") @Cached LLVMForeignGetIndexPointerNode getElementPointer, @Cached.Exclusive @Cached LLVMForeignWriteNode write) throws UnsupportedMessageException, InvalidArrayIndexException {
        LLVMPointer ptr = getElementPointer.execute(receiver.getExportType(), receiver, idx);
        write.execute(ptr, ptr.getExportType(), value);
    }

    @ExportMessage
    static boolean hasLanguage(LLVMPointerImpl receiver) {
        return true;
    }

    @ExportMessage
    static Class<? extends TruffleLanguage<?>> getLanguage(LLVMPointerImpl receiver) {
        return LLVMLanguage.class;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    static String toDisplayString(LLVMPointerImpl receiver, boolean allowSideEffects) {
        return receiver.toString();
    }

    @ExportMessage
    static Object getMetaObject(LLVMPointerImpl receiver) throws UnsupportedMessageException {
        LLVMInteropType type = receiver.getExportType();
        if (type != null) {
            return type;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean hasMetaObject(LLVMPointerImpl receiver) {
        return receiver.getExportType() != null;
    }

    @ExportMessage
    static int identityHashCode(LLVMPointerImpl receiver) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError();
    }

    @ExportMessage
    static class IsIdenticalOrUndefined {
        IsIdenticalOrUndefined() {
        }

        @Specialization
        static TriState doPointer(LLVMPointerImpl receiver, LLVMPointerImpl other, @Cached LLVMAddressEqualsNode equals) {
            return TriState.valueOf((boolean)equals.executeWithTarget(receiver, other));
        }

        @Fallback
        static TriState doOther(LLVMPointerImpl receiver, Object other) {
            return TriState.UNDEFINED;
        }
    }

    @ExportMessage
    static class IsSame {
        IsSame() {
        }

        @Specialization
        static boolean doNative(LLVMPointerImpl receiver, LLVMPointerImpl other, @Cached LLVMAddressEqualsNode equals) {
            return equals.executeWithTarget(receiver, other);
        }

        @Fallback
        static boolean doOther(LLVMPointerImpl receiver, Object other) {
            return false;
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class Keys
    implements TruffleObject {
        private final LLVMInteropType.Struct type;

        private Keys(LLVMInteropType.Struct type) {
            this.type = type;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.type.getMemberCount();
        }

        @ExportMessage
        boolean isArrayElementReadable(long idx) {
            return Long.compareUnsigned(idx, this.getArraySize()) < 0;
        }

        @ExportMessage
        Object readArrayElement(long idx, @Cached BranchProfile exception) throws InvalidArrayIndexException {
            try {
                return this.type.getMember((int)idx).getName();
            }
            catch (IndexOutOfBoundsException ex) {
                exception.enter();
                throw InvalidArrayIndexException.create((long)idx);
            }
        }
    }
}

