/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.others;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.LLVMAlias;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMWriteSymbolNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMWriteSymbolNode.class)
public final class LLVMWriteSymbolNodeGen
extends LLVMWriteSymbolNode {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;

    private LLVMWriteSymbolNodeGen() {
    }

    @Override
    public void execute(LLVMPointer arg0Value, LLVMSymbol arg1Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0 && arg1Value instanceof LLVMGlobal) {
                LLVMGlobal arg1Value_ = (LLVMGlobal)arg1Value;
                TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                LLVMContext write0_context__ = (LLVMContext)lLVMLanguageContextReference__.get();
                this.doWrite(arg0Value, arg1Value_, write0_context__);
                return;
            }
            if ((state & 2) != 0 && arg1Value instanceof LLVMFunction) {
                LLVMFunction arg1Value_ = (LLVMFunction)arg1Value;
                TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__1 = this.lLVMLanguageContextReference_;
                LLVMContext write1_context__ = (LLVMContext)lLVMLanguageContextReference__1.get();
                this.doWrite(arg0Value, arg1Value_, write1_context__);
                return;
            }
            if ((state & 4) != 0 && arg1Value instanceof LLVMAlias) {
                LLVMAlias arg1Value_ = (LLVMAlias)arg1Value;
                TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__2 = this.lLVMLanguageContextReference_;
                LLVMContext write2_context__ = (LLVMContext)lLVMLanguageContextReference__2.get();
                this.doWrite(arg0Value, arg1Value_, write2_context__);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(arg0Value, arg1Value);
    }

    private void executeAndSpecialize(LLVMPointer arg0Value, LLVMSymbol arg1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            LLVMContext write0_context__ = null;
            if (arg1Value instanceof LLVMGlobal) {
                LLVMGlobal arg1Value_ = (LLVMGlobal)arg1Value;
                TruffleLanguage.ContextReference lLVMLanguageContextReference__3 = this.lLVMLanguageContextReference_;
                if (lLVMLanguageContextReference__3 == null) {
                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__3 = super.lookupContextReference(LLVMLanguage.class);
                }
                write0_context__ = (LLVMContext)lLVMLanguageContextReference__3.get();
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                this.doWrite(arg0Value, arg1Value_, write0_context__);
                return;
            }
            LLVMContext write1_context__ = null;
            if (arg1Value instanceof LLVMFunction) {
                LLVMFunction arg1Value_ = (LLVMFunction)arg1Value;
                TruffleLanguage.ContextReference lLVMLanguageContextReference__4 = this.lLVMLanguageContextReference_;
                if (lLVMLanguageContextReference__4 == null) {
                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__4 = super.lookupContextReference(LLVMLanguage.class);
                }
                write1_context__ = (LLVMContext)lLVMLanguageContextReference__4.get();
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                this.doWrite(arg0Value, arg1Value_, write1_context__);
                return;
            }
            LLVMContext write2_context__ = null;
            if (arg1Value instanceof LLVMAlias) {
                LLVMAlias arg1Value_ = (LLVMAlias)arg1Value;
                TruffleLanguage.ContextReference lLVMLanguageContextReference__5 = this.lLVMLanguageContextReference_;
                if (lLVMLanguageContextReference__5 == null) {
                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__5 = super.lookupContextReference(LLVMLanguage.class);
                }
                write2_context__ = (LLVMContext)lLVMLanguageContextReference__5.get();
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                this.doWrite(arg0Value, arg1Value_, write2_context__);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMWriteSymbolNode create() {
        return new LLVMWriteSymbolNodeGen();
    }
}

