/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.others;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.utilities.AssumedValue;
import com.oracle.truffle.llvm.runtime.LLVMAlias;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.except.LLVMIllegalSymbolIndexException;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMWriteSymbolNode
extends LLVMNode {
    public abstract void execute(LLVMPointer var1, LLVMSymbol var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization
    void doWrite(LLVMPointer pointer, LLVMGlobal global, @CachedContext(value=LLVMLanguage.class) LLVMContext context) {
        AssumedValue<LLVMPointer>[] symbols;
        AssumedValue<LLVMPointer>[] assumedValueArray = symbols = context.findSymbolTable(global.getBitcodeID(false));
        synchronized (symbols) {
            CompilerAsserts.partialEvaluationConstant((Object)global);
            try {
                int index = global.getSymbolIndex(false);
                symbols[index] = LLVMWriteSymbolNode.newAssumedValue("LLVMGlobal", global.getName(), pointer);
            }
            catch (LLVMIllegalSymbolIndexException e) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMLinkerException(this, "Writing global symbol into symbol table is inconsistent.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization
    void doWrite(LLVMPointer pointer, LLVMFunction function, @CachedContext(value=LLVMLanguage.class) LLVMContext context) {
        AssumedValue<LLVMPointer>[] symbols;
        AssumedValue<LLVMPointer>[] assumedValueArray = symbols = context.findSymbolTable(function.getBitcodeID(false));
        synchronized (symbols) {
            CompilerAsserts.partialEvaluationConstant((Object)function);
            try {
                int index = function.getSymbolIndex(false);
                symbols[index] = LLVMWriteSymbolNode.newAssumedValue("LLVMFunction", function.getName(), pointer);
            }
            catch (LLVMIllegalSymbolIndexException e) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMLinkerException(this, "Writing function symbol into symbol table is inconsistent.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization
    void doWrite(LLVMPointer pointer, LLVMAlias alias, @CachedContext(value=LLVMLanguage.class) LLVMContext context) {
        AssumedValue<LLVMPointer>[] symbols;
        LLVMSymbol target = alias.getTarget();
        while (target.isAlias()) {
            target = ((LLVMAlias)target).getTarget();
        }
        AssumedValue<LLVMPointer>[] assumedValueArray = symbols = context.findSymbolTable(target.getBitcodeID(false));
        synchronized (symbols) {
            CompilerAsserts.partialEvaluationConstant((Object)target);
            try {
                int index = target.getSymbolIndex(false);
                if (symbols[index] == null) {
                    symbols[index] = LLVMWriteSymbolNode.newAssumedValue(target.getKind(), target.getName(), pointer);
                }
            }
            catch (LLVMIllegalSymbolIndexException e) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMLinkerException(this, "Writing alias symbol into symbol table is inconsistent.");
            }
            return;
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static AssumedValue<LLVMPointer> newAssumedValue(String prefix, String name, LLVMPointer pointer) {
        return new AssumedValue(prefix + "." + name, (Object)pointer);
    }
}

