/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.others;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMVectorSelectNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;

@GeneratedBy(value=LLVMVectorSelectNode.class)
public final class LLVMVectorSelectNodeFactory {

    @GeneratedBy(value=LLVMVectorSelectNode.LLVMDoubleVectorSelectNode.class)
    public static final class LLVMDoubleVectorSelectNodeGen
    extends LLVMVectorSelectNode.LLVMDoubleVectorSelectNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode conditionNode_;
        @Node.Child
        private LLVMExpressionNode trueNode_;
        @Node.Child
        private LLVMExpressionNode elseNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMDoubleVectorSelectNodeGen(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.conditionNode_ = conditionNode;
            this.trueNode_ = trueNode;
            this.elseNode_ = elseNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object conditionNodeValue_ = this.conditionNode_.executeGeneric(frameValue);
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (state != 0 && conditionNodeValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector conditionNodeValue__ = (LLVMI1Vector)conditionNodeValue_;
                if (trueNodeValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector trueNodeValue__ = (LLVMDoubleVector)trueNodeValue_;
                    if (elseNodeValue_ instanceof LLVMDoubleVector) {
                        LLVMDoubleVector elseNodeValue__ = (LLVMDoubleVector)elseNodeValue_;
                        return this.doOp(conditionNodeValue__, trueNodeValue__, elseNodeValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private LLVMDoubleVector executeAndSpecialize(Object conditionNodeValue, Object trueNodeValue, Object elseNodeValue) {
            int state = this.state_;
            if (conditionNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector conditionNodeValue_ = (LLVMI1Vector)conditionNodeValue;
                if (trueNodeValue instanceof LLVMDoubleVector) {
                    LLVMDoubleVector trueNodeValue_ = (LLVMDoubleVector)trueNodeValue;
                    if (elseNodeValue instanceof LLVMDoubleVector) {
                        LLVMDoubleVector elseNodeValue_ = (LLVMDoubleVector)elseNodeValue;
                        this.state_ = state |= 1;
                        return this.doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.conditionNode_, this.trueNode_, this.elseNode_}, new Object[]{conditionNodeValue, trueNodeValue, elseNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMVectorSelectNode.LLVMDoubleVectorSelectNode create(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            return new LLVMDoubleVectorSelectNodeGen(conditionNode, trueNode, elseNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMVectorSelectNode.LLVMFloatVectorSelectNode.class)
    public static final class LLVMFloatVectorSelectNodeGen
    extends LLVMVectorSelectNode.LLVMFloatVectorSelectNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode conditionNode_;
        @Node.Child
        private LLVMExpressionNode trueNode_;
        @Node.Child
        private LLVMExpressionNode elseNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMFloatVectorSelectNodeGen(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.conditionNode_ = conditionNode;
            this.trueNode_ = trueNode;
            this.elseNode_ = elseNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object conditionNodeValue_ = this.conditionNode_.executeGeneric(frameValue);
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (state != 0 && conditionNodeValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector conditionNodeValue__ = (LLVMI1Vector)conditionNodeValue_;
                if (trueNodeValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector trueNodeValue__ = (LLVMFloatVector)trueNodeValue_;
                    if (elseNodeValue_ instanceof LLVMFloatVector) {
                        LLVMFloatVector elseNodeValue__ = (LLVMFloatVector)elseNodeValue_;
                        return this.doOp(conditionNodeValue__, trueNodeValue__, elseNodeValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private LLVMFloatVector executeAndSpecialize(Object conditionNodeValue, Object trueNodeValue, Object elseNodeValue) {
            int state = this.state_;
            if (conditionNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector conditionNodeValue_ = (LLVMI1Vector)conditionNodeValue;
                if (trueNodeValue instanceof LLVMFloatVector) {
                    LLVMFloatVector trueNodeValue_ = (LLVMFloatVector)trueNodeValue;
                    if (elseNodeValue instanceof LLVMFloatVector) {
                        LLVMFloatVector elseNodeValue_ = (LLVMFloatVector)elseNodeValue;
                        this.state_ = state |= 1;
                        return this.doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.conditionNode_, this.trueNode_, this.elseNode_}, new Object[]{conditionNodeValue, trueNodeValue, elseNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMVectorSelectNode.LLVMFloatVectorSelectNode create(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            return new LLVMFloatVectorSelectNodeGen(conditionNode, trueNode, elseNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMVectorSelectNode.LLVMI64VectorSelectNode.class)
    public static final class LLVMI64VectorSelectNodeGen
    extends LLVMVectorSelectNode.LLVMI64VectorSelectNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode conditionNode_;
        @Node.Child
        private LLVMExpressionNode trueNode_;
        @Node.Child
        private LLVMExpressionNode elseNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI64VectorSelectNodeGen(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.conditionNode_ = conditionNode;
            this.trueNode_ = trueNode;
            this.elseNode_ = elseNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object conditionNodeValue_ = this.conditionNode_.executeGeneric(frameValue);
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (state != 0 && conditionNodeValue_ instanceof LLVMI1Vector) {
                LLVMVector trueNodeValue__;
                LLVMI1Vector conditionNodeValue__ = (LLVMI1Vector)conditionNodeValue_;
                if ((state & 3) != 0 && trueNodeValue_ instanceof LLVMI64Vector) {
                    trueNodeValue__ = (LLVMI64Vector)trueNodeValue_;
                    if ((state & 1) != 0 && elseNodeValue_ instanceof LLVMI64Vector) {
                        LLVMI64Vector elseNodeValue__ = (LLVMI64Vector)elseNodeValue_;
                        return this.doOp(conditionNodeValue__, (LLVMI64Vector)trueNodeValue__, elseNodeValue__);
                    }
                    if ((state & 2) != 0 && elseNodeValue_ instanceof LLVMPointerVector) {
                        LLVMPointerVector elseNodeValue__ = (LLVMPointerVector)elseNodeValue_;
                        return this.doOp(conditionNodeValue__, (LLVMI64Vector)trueNodeValue__, elseNodeValue__);
                    }
                }
                if ((state & 0xC) != 0 && trueNodeValue_ instanceof LLVMPointerVector) {
                    trueNodeValue__ = (LLVMPointerVector)trueNodeValue_;
                    if ((state & 4) != 0 && elseNodeValue_ instanceof LLVMI64Vector) {
                        LLVMI64Vector elseNodeValue__ = (LLVMI64Vector)elseNodeValue_;
                        return this.doOp(conditionNodeValue__, (LLVMPointerVector)trueNodeValue__, elseNodeValue__);
                    }
                    if ((state & 8) != 0 && elseNodeValue_ instanceof LLVMPointerVector) {
                        LLVMPointerVector elseNodeValue__ = (LLVMPointerVector)elseNodeValue_;
                        return this.doOp(conditionNodeValue__, (LLVMPointerVector)trueNodeValue__, elseNodeValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private LLVMVector executeAndSpecialize(Object conditionNodeValue, Object trueNodeValue, Object elseNodeValue) {
            int state = this.state_;
            if (conditionNodeValue instanceof LLVMI1Vector) {
                LLVMVector trueNodeValue_;
                LLVMI1Vector conditionNodeValue_ = (LLVMI1Vector)conditionNodeValue;
                if (trueNodeValue instanceof LLVMI64Vector) {
                    trueNodeValue_ = (LLVMI64Vector)trueNodeValue;
                    if (elseNodeValue instanceof LLVMI64Vector) {
                        LLVMI64Vector elseNodeValue_ = (LLVMI64Vector)elseNodeValue;
                        this.state_ = state |= 1;
                        return this.doOp(conditionNodeValue_, (LLVMI64Vector)trueNodeValue_, elseNodeValue_);
                    }
                    if (elseNodeValue instanceof LLVMPointerVector) {
                        LLVMPointerVector elseNodeValue_ = (LLVMPointerVector)elseNodeValue;
                        this.state_ = state |= 2;
                        return this.doOp(conditionNodeValue_, (LLVMI64Vector)trueNodeValue_, elseNodeValue_);
                    }
                }
                if (trueNodeValue instanceof LLVMPointerVector) {
                    trueNodeValue_ = (LLVMPointerVector)trueNodeValue;
                    if (elseNodeValue instanceof LLVMI64Vector) {
                        LLVMI64Vector elseNodeValue_ = (LLVMI64Vector)elseNodeValue;
                        this.state_ = state |= 4;
                        return this.doOp(conditionNodeValue_, (LLVMPointerVector)trueNodeValue_, elseNodeValue_);
                    }
                    if (elseNodeValue instanceof LLVMPointerVector) {
                        LLVMPointerVector elseNodeValue_ = (LLVMPointerVector)elseNodeValue;
                        this.state_ = state |= 8;
                        return this.doOp(conditionNodeValue_, (LLVMPointerVector)trueNodeValue_, elseNodeValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.conditionNode_, this.trueNode_, this.elseNode_}, new Object[]{conditionNodeValue, trueNodeValue, elseNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMVectorSelectNode.LLVMI64VectorSelectNode create(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            return new LLVMI64VectorSelectNodeGen(conditionNode, trueNode, elseNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMVectorSelectNode.LLVMI32VectorSelectNode.class)
    public static final class LLVMI32VectorSelectNodeGen
    extends LLVMVectorSelectNode.LLVMI32VectorSelectNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode conditionNode_;
        @Node.Child
        private LLVMExpressionNode trueNode_;
        @Node.Child
        private LLVMExpressionNode elseNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI32VectorSelectNodeGen(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.conditionNode_ = conditionNode;
            this.trueNode_ = trueNode;
            this.elseNode_ = elseNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object conditionNodeValue_ = this.conditionNode_.executeGeneric(frameValue);
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (state != 0 && conditionNodeValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector conditionNodeValue__ = (LLVMI1Vector)conditionNodeValue_;
                if (trueNodeValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector trueNodeValue__ = (LLVMI32Vector)trueNodeValue_;
                    if (elseNodeValue_ instanceof LLVMI32Vector) {
                        LLVMI32Vector elseNodeValue__ = (LLVMI32Vector)elseNodeValue_;
                        return this.doOp(conditionNodeValue__, trueNodeValue__, elseNodeValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private LLVMI32Vector executeAndSpecialize(Object conditionNodeValue, Object trueNodeValue, Object elseNodeValue) {
            int state = this.state_;
            if (conditionNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector conditionNodeValue_ = (LLVMI1Vector)conditionNodeValue;
                if (trueNodeValue instanceof LLVMI32Vector) {
                    LLVMI32Vector trueNodeValue_ = (LLVMI32Vector)trueNodeValue;
                    if (elseNodeValue instanceof LLVMI32Vector) {
                        LLVMI32Vector elseNodeValue_ = (LLVMI32Vector)elseNodeValue;
                        this.state_ = state |= 1;
                        return this.doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.conditionNode_, this.trueNode_, this.elseNode_}, new Object[]{conditionNodeValue, trueNodeValue, elseNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMVectorSelectNode.LLVMI32VectorSelectNode create(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            return new LLVMI32VectorSelectNodeGen(conditionNode, trueNode, elseNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMVectorSelectNode.LLVMI16VectorSelectNode.class)
    public static final class LLVMI16VectorSelectNodeGen
    extends LLVMVectorSelectNode.LLVMI16VectorSelectNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode conditionNode_;
        @Node.Child
        private LLVMExpressionNode trueNode_;
        @Node.Child
        private LLVMExpressionNode elseNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI16VectorSelectNodeGen(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.conditionNode_ = conditionNode;
            this.trueNode_ = trueNode;
            this.elseNode_ = elseNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object conditionNodeValue_ = this.conditionNode_.executeGeneric(frameValue);
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (state != 0 && conditionNodeValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector conditionNodeValue__ = (LLVMI1Vector)conditionNodeValue_;
                if (trueNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector trueNodeValue__ = (LLVMI16Vector)trueNodeValue_;
                    if (elseNodeValue_ instanceof LLVMI16Vector) {
                        LLVMI16Vector elseNodeValue__ = (LLVMI16Vector)elseNodeValue_;
                        return this.doOp(conditionNodeValue__, trueNodeValue__, elseNodeValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private LLVMI16Vector executeAndSpecialize(Object conditionNodeValue, Object trueNodeValue, Object elseNodeValue) {
            int state = this.state_;
            if (conditionNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector conditionNodeValue_ = (LLVMI1Vector)conditionNodeValue;
                if (trueNodeValue instanceof LLVMI16Vector) {
                    LLVMI16Vector trueNodeValue_ = (LLVMI16Vector)trueNodeValue;
                    if (elseNodeValue instanceof LLVMI16Vector) {
                        LLVMI16Vector elseNodeValue_ = (LLVMI16Vector)elseNodeValue;
                        this.state_ = state |= 1;
                        return this.doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.conditionNode_, this.trueNode_, this.elseNode_}, new Object[]{conditionNodeValue, trueNodeValue, elseNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMVectorSelectNode.LLVMI16VectorSelectNode create(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            return new LLVMI16VectorSelectNodeGen(conditionNode, trueNode, elseNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMVectorSelectNode.LLVMI8VectorSelectNode.class)
    public static final class LLVMI8VectorSelectNodeGen
    extends LLVMVectorSelectNode.LLVMI8VectorSelectNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode conditionNode_;
        @Node.Child
        private LLVMExpressionNode trueNode_;
        @Node.Child
        private LLVMExpressionNode elseNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI8VectorSelectNodeGen(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.conditionNode_ = conditionNode;
            this.trueNode_ = trueNode;
            this.elseNode_ = elseNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object conditionNodeValue_ = this.conditionNode_.executeGeneric(frameValue);
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (state != 0 && conditionNodeValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector conditionNodeValue__ = (LLVMI1Vector)conditionNodeValue_;
                if (trueNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector trueNodeValue__ = (LLVMI8Vector)trueNodeValue_;
                    if (elseNodeValue_ instanceof LLVMI8Vector) {
                        LLVMI8Vector elseNodeValue__ = (LLVMI8Vector)elseNodeValue_;
                        return this.doOp(conditionNodeValue__, trueNodeValue__, elseNodeValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private LLVMI8Vector executeAndSpecialize(Object conditionNodeValue, Object trueNodeValue, Object elseNodeValue) {
            int state = this.state_;
            if (conditionNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector conditionNodeValue_ = (LLVMI1Vector)conditionNodeValue;
                if (trueNodeValue instanceof LLVMI8Vector) {
                    LLVMI8Vector trueNodeValue_ = (LLVMI8Vector)trueNodeValue;
                    if (elseNodeValue instanceof LLVMI8Vector) {
                        LLVMI8Vector elseNodeValue_ = (LLVMI8Vector)elseNodeValue;
                        this.state_ = state |= 1;
                        return this.doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.conditionNode_, this.trueNode_, this.elseNode_}, new Object[]{conditionNodeValue, trueNodeValue, elseNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMVectorSelectNode.LLVMI8VectorSelectNode create(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            return new LLVMI8VectorSelectNodeGen(conditionNode, trueNode, elseNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMVectorSelectNode.LLVMI1VectorSelectNode.class)
    public static final class LLVMI1VectorSelectNodeGen
    extends LLVMVectorSelectNode.LLVMI1VectorSelectNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode conditionNode_;
        @Node.Child
        private LLVMExpressionNode trueNode_;
        @Node.Child
        private LLVMExpressionNode elseNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI1VectorSelectNodeGen(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.conditionNode_ = conditionNode;
            this.trueNode_ = trueNode;
            this.elseNode_ = elseNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object conditionNodeValue_ = this.conditionNode_.executeGeneric(frameValue);
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (state != 0 && conditionNodeValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector conditionNodeValue__ = (LLVMI1Vector)conditionNodeValue_;
                if (trueNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector trueNodeValue__ = (LLVMI1Vector)trueNodeValue_;
                    if (elseNodeValue_ instanceof LLVMI1Vector) {
                        LLVMI1Vector elseNodeValue__ = (LLVMI1Vector)elseNodeValue_;
                        return this.doOp(conditionNodeValue__, trueNodeValue__, elseNodeValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private LLVMI1Vector executeAndSpecialize(Object conditionNodeValue, Object trueNodeValue, Object elseNodeValue) {
            int state = this.state_;
            if (conditionNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector conditionNodeValue_ = (LLVMI1Vector)conditionNodeValue;
                if (trueNodeValue instanceof LLVMI1Vector) {
                    LLVMI1Vector trueNodeValue_ = (LLVMI1Vector)trueNodeValue;
                    if (elseNodeValue instanceof LLVMI1Vector) {
                        LLVMI1Vector elseNodeValue_ = (LLVMI1Vector)elseNodeValue;
                        this.state_ = state |= 1;
                        return this.doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.conditionNode_, this.trueNode_, this.elseNode_}, new Object[]{conditionNodeValue, trueNodeValue, elseNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMVectorSelectNode.LLVMI1VectorSelectNode create(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            return new LLVMI1VectorSelectNodeGen(conditionNode, trueNode, elseNode, vectorLength);
        }
    }
}

