/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.others;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;

public class LLVMStatementRootNode
extends RootNode {
    @Node.Child
    LLVMStatementNode statement;
    @CompilerDirectives.CompilationFinal
    private FrameSlot stackPointerSlot;

    public LLVMStatementRootNode(LLVMLanguage language, LLVMStatementNode statement, FrameDescriptor descriptor) {
        super((TruffleLanguage)language, descriptor);
        this.statement = statement;
    }

    private FrameSlot getStackPointerSlot() {
        if (this.stackPointerSlot == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.stackPointerSlot = this.getRootNode().getFrameDescriptor().findFrameSlot((Object)"<stackpointer>");
            assert (this.stackPointerSlot != null);
        }
        return this.stackPointerSlot;
    }

    public Object execute(VirtualFrame frame) {
        frame.setObject(this.getStackPointerSlot(), frame.getArguments()[0]);
        this.statement.execute(frame);
        return null;
    }
}

