/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.others;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.utilities.AssumedValue;
import com.oracle.truffle.llvm.runtime.LLVMAlias;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMCheckSymbolNode
extends LLVMNode {
    public abstract boolean execute(LLVMSymbol var1);

    @Specialization(guards={"alias.isAlias()"})
    boolean doCheckAlias(LLVMAlias alias, @CachedContext(value=LLVMLanguage.class) LLVMContext context) {
        LLVMSymbol target = alias.getTarget();
        while ((target = ((LLVMAlias)target).getTarget()).isAlias()) {
        }
        return this.doCheck(target, context);
    }

    @Specialization
    boolean doCheck(LLVMSymbol symbol, @CachedContext(value=LLVMLanguage.class) LLVMContext context) {
        int bitcodeID;
        CompilerAsserts.partialEvaluationConstant((Object)symbol);
        if (symbol.hasValidIndexAndID() && context.symbolTableExists(bitcodeID = symbol.getBitcodeID(false))) {
            int index;
            AssumedValue<LLVMPointer>[] symbols = context.findSymbolTable(bitcodeID);
            AssumedValue<LLVMPointer> pointer = symbols[index = symbol.getSymbolIndex(false)];
            if (pointer == null) {
                return false;
            }
            return pointer.get() != null;
        }
        CompilerDirectives.transferToInterpreter();
        throw new LLVMLinkerException(this, String.format("External %s %s cannot be found.", symbol.getKind(), symbol.getName()));
    }
}

