/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.others;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMAccessSymbolNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMAccessSymbolNode.class)
public final class LLVMAccessSymbolNodeGen
extends LLVMAccessSymbolNode {
    private LLVMSourceLocation sourceLocation;
    private boolean statement;
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;

    private LLVMAccessSymbolNodeGen(LLVMSymbol descriptor) {
        super(descriptor);
    }

    @Override
    public LLVMSourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    protected boolean isStatement() {
        return this.statement;
    }

    @Override
    protected void setStatement(boolean statement) {
        this.statement = statement;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 1) != 0) {
            TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
            LLVMContext aliasAccess_context__ = (LLVMContext)lLVMLanguageContextReference__.get();
            assert (this.descriptor.isAlias());
            return this.doAliasAccess(aliasAccess_context__);
        }
        if ((state & 2) != 0) {
            TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__1 = this.lLVMLanguageContextReference_;
            LLVMContext fallback0_context__ = (LLVMContext)lLVMLanguageContextReference__1.get();
            return this.doFallback(fallback0_context__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize();
    }

    @Override
    public LLVMPointer execute() {
        int state = this.state_;
        if ((state & 1) != 0) {
            TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__2 = this.lLVMLanguageContextReference_;
            LLVMContext aliasAccess_context__ = (LLVMContext)lLVMLanguageContextReference__2.get();
            assert (this.descriptor.isAlias());
            return this.doAliasAccess(aliasAccess_context__);
        }
        if ((state & 2) != 0) {
            TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__3 = this.lLVMLanguageContextReference_;
            LLVMContext fallback0_context__ = (LLVMContext)lLVMLanguageContextReference__3.get();
            return this.doFallback(fallback0_context__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LLVMPointer executeAndSpecialize() {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            LLVMContext aliasAccess_context__ = null;
            if (this.descriptor.isAlias()) {
                TruffleLanguage.ContextReference lLVMLanguageContextReference__4 = this.lLVMLanguageContextReference_;
                if (lLVMLanguageContextReference__4 == null) {
                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__4 = super.lookupContextReference(LLVMLanguage.class);
                }
                aliasAccess_context__ = (LLVMContext)lLVMLanguageContextReference__4.get();
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                LLVMPointer lLVMPointer = this.doAliasAccess(aliasAccess_context__);
                return lLVMPointer;
            }
            LLVMContext fallback0_context__ = null;
            TruffleLanguage.ContextReference lLVMLanguageContextReference__5 = this.lLVMLanguageContextReference_;
            if (lLVMLanguageContextReference__5 == null) {
                this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__5 = super.lookupContextReference(LLVMLanguage.class);
            }
            fallback0_context__ = (LLVMContext)lLVMLanguageContextReference__5.get();
            this.state_ = state |= 2;
            lock.unlock();
            hasLock = false;
            LLVMPointer lLVMPointer = this.doFallback(fallback0_context__);
            return lLVMPointer;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMAccessSymbolNode create(LLVMSymbol descriptor) {
        return new LLVMAccessSymbolNodeGen(descriptor);
    }
}

