/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.others;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.utilities.AssumedValue;
import com.oracle.truffle.llvm.runtime.LLVMAlias;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMAccessSymbolNode
extends LLVMExpressionNode {
    protected final LLVMSymbol descriptor;

    public LLVMAccessSymbolNode(LLVMSymbol descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public String toString() {
        return this.getShortString("descriptor");
    }

    public LLVMSymbol getDescriptor() {
        return this.descriptor;
    }

    public abstract LLVMPointer execute();

    @Specialization(guards={"descriptor.isAlias()"})
    LLVMPointer doAliasAccess(@CachedContext(value=LLVMLanguage.class) LLVMContext context) {
        CompilerAsserts.partialEvaluationConstant((Object)this.descriptor);
        LLVMSymbol target = ((LLVMAlias)this.descriptor).getTarget();
        while (target.isAlias()) {
            target = ((LLVMAlias)target).getTarget();
        }
        AssumedValue<LLVMPointer>[] symbols = context.findSymbolTable(target.getBitcodeID(false));
        int index = target.getSymbolIndex(false);
        return (LLVMPointer)symbols[index].get();
    }

    @Specialization
    LLVMPointer doFallback(@CachedContext(value=LLVMLanguage.class) LLVMContext context) {
        int index;
        AssumedValue<LLVMPointer>[] symbols;
        AssumedValue<LLVMPointer> symbol;
        int bitcodeID;
        CompilerAsserts.partialEvaluationConstant((Object)this.descriptor);
        if (this.descriptor.hasValidIndexAndID() && context.symbolTableExists(bitcodeID = this.descriptor.getBitcodeID(false)) && (symbol = (symbols = context.findSymbolTable(bitcodeID))[index = this.descriptor.getSymbolIndex(false)]) != null) {
            return (LLVMPointer)symbol.get();
        }
        CompilerDirectives.transferToInterpreter();
        throw new LLVMLinkerException(this, String.format("External %s %s cannot be found.", this.descriptor.getKind(), this.descriptor.getName()));
    }
}

