/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMUnaryNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;

@NodeChild(value="operandNode")
public abstract class LLVMVectorUnaryNode
extends LLVMExpressionNode {
    private final int vectorLength;
    @Node.Child
    private LLVMUnaryNode unaryNode;

    public LLVMVectorUnaryNode(int vectorLength, LLVMUnaryNode unaryNode) {
        this.vectorLength = vectorLength;
        this.unaryNode = unaryNode;
    }

    @ExplodeLoop
    @Specialization
    protected LLVMI1Vector doI1(LLVMI1Vector operand) {
        assert (operand.getLength() == this.vectorLength);
        boolean[] result = new boolean[this.vectorLength];
        for (int i = 0; i < this.vectorLength; ++i) {
            result[i] = LLVMTypesGen.asBoolean(this.unaryNode.executeWithTarget(operand.getValue(i)));
        }
        return LLVMI1Vector.create(result);
    }

    @ExplodeLoop
    @Specialization
    protected LLVMI8Vector doI8(LLVMI8Vector operand) {
        assert (operand.getLength() == this.vectorLength);
        byte[] result = new byte[this.vectorLength];
        for (int i = 0; i < this.vectorLength; ++i) {
            result[i] = LLVMTypesGen.asByte(this.unaryNode.executeWithTarget(operand.getValue(i)));
        }
        return LLVMI8Vector.create(result);
    }

    @ExplodeLoop
    @Specialization
    protected LLVMI16Vector doI16(LLVMI16Vector operand) {
        assert (operand.getLength() == this.vectorLength);
        short[] result = new short[this.vectorLength];
        for (int i = 0; i < this.vectorLength; ++i) {
            result[i] = LLVMTypesGen.asShort(this.unaryNode.executeWithTarget(operand.getValue(i)));
        }
        return LLVMI16Vector.create(result);
    }

    @ExplodeLoop
    @Specialization
    protected LLVMI32Vector doI32(LLVMI32Vector operand) {
        assert (operand.getLength() == this.vectorLength);
        int[] result = new int[this.vectorLength];
        for (int i = 0; i < this.vectorLength; ++i) {
            result[i] = LLVMTypesGen.asInteger(this.unaryNode.executeWithTarget(operand.getValue(i)));
        }
        return LLVMI32Vector.create(result);
    }

    @ExplodeLoop
    @Specialization
    protected LLVMI64Vector doI64(LLVMI64Vector operand) {
        assert (operand.getLength() == this.vectorLength);
        long[] result = new long[this.vectorLength];
        for (int i = 0; i < this.vectorLength; ++i) {
            result[i] = LLVMTypesGen.asLong(this.unaryNode.executeWithTarget(operand.getValue(i)));
        }
        return LLVMI64Vector.create(result);
    }

    @ExplodeLoop
    @Specialization
    protected LLVMFloatVector doFloat(LLVMFloatVector operand) {
        assert (operand.getLength() == this.vectorLength);
        float[] result = new float[this.vectorLength];
        for (int i = 0; i < this.vectorLength; ++i) {
            result[i] = LLVMTypesGen.asFloat(this.unaryNode.executeWithTarget(Float.valueOf(operand.getValue(i))));
        }
        return LLVMFloatVector.create(result);
    }

    @ExplodeLoop
    @Specialization
    protected LLVMDoubleVector doDouble(LLVMDoubleVector operand) {
        assert (operand.getLength() == this.vectorLength);
        double[] result = new double[this.vectorLength];
        for (int i = 0; i < this.vectorLength; ++i) {
            result[i] = LLVMTypesGen.asDouble(this.unaryNode.executeWithTarget(operand.getValue(i)));
        }
        return LLVMDoubleVector.create(result);
    }
}

