/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAbstractCompareNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
public abstract class LLVMVectorCompareNode
extends LLVMExpressionNode {
    private final int vectorLength;
    @Node.Child
    private LLVMAbstractCompareNode compare;

    public LLVMVectorCompareNode(int vectorLength, LLVMAbstractCompareNode compare) {
        this.vectorLength = vectorLength;
        this.compare = compare;
    }

    private boolean checkLength(LLVMVector val1, LLVMVector val2) {
        return val1.getLength() == this.vectorLength && val2.getLength() == this.vectorLength;
    }

    @ExplodeLoop
    @Specialization
    protected LLVMI1Vector doI1(LLVMI1Vector val1, LLVMI1Vector val2) {
        assert (this.checkLength(val1, val2));
        boolean[] result = new boolean[this.vectorLength];
        for (int i = 0; i < this.vectorLength; ++i) {
            result[i] = this.compare.executeWithTarget(val1.getValue(i), val2.getValue(i));
        }
        return LLVMI1Vector.create(result);
    }

    @ExplodeLoop
    @Specialization
    protected LLVMI1Vector doI8(LLVMI8Vector val1, LLVMI8Vector val2) {
        assert (this.checkLength(val1, val2));
        boolean[] result = new boolean[this.vectorLength];
        for (int i = 0; i < this.vectorLength; ++i) {
            result[i] = this.compare.executeWithTarget(val1.getValue(i), val2.getValue(i));
        }
        return LLVMI1Vector.create(result);
    }

    @ExplodeLoop
    @Specialization
    protected LLVMI1Vector doI16(LLVMI16Vector val1, LLVMI16Vector val2) {
        assert (this.checkLength(val1, val2));
        boolean[] result = new boolean[this.vectorLength];
        for (int i = 0; i < this.vectorLength; ++i) {
            result[i] = this.compare.executeWithTarget(val1.getValue(i), val2.getValue(i));
        }
        return LLVMI1Vector.create(result);
    }

    @ExplodeLoop
    @Specialization
    protected LLVMI1Vector doI32(LLVMI32Vector val1, LLVMI32Vector val2) {
        assert (this.checkLength(val1, val2));
        boolean[] result = new boolean[this.vectorLength];
        for (int i = 0; i < this.vectorLength; ++i) {
            result[i] = this.compare.executeWithTarget(val1.getValue(i), val2.getValue(i));
        }
        return LLVMI1Vector.create(result);
    }

    @ExplodeLoop
    @Specialization
    protected LLVMI1Vector doI64(LLVMI64Vector val1, LLVMI64Vector val2) {
        assert (this.checkLength(val1, val2));
        boolean[] result = new boolean[this.vectorLength];
        for (int i = 0; i < this.vectorLength; ++i) {
            result[i] = this.compare.executeWithTarget(val1.getValue(i), val2.getValue(i));
        }
        return LLVMI1Vector.create(result);
    }

    @ExplodeLoop
    @Specialization
    protected LLVMI1Vector doI64AndPointer(LLVMPointerVector val1, LLVMI64Vector val2) {
        assert (this.checkLength(val1, val2));
        boolean[] result = new boolean[this.vectorLength];
        for (int i = 0; i < this.vectorLength; ++i) {
            result[i] = this.compare.executeWithTarget(val1.getValue(i), val2.getValue(i));
        }
        return LLVMI1Vector.create(result);
    }

    @ExplodeLoop
    @Specialization
    protected LLVMI1Vector doI64AndPointer(LLVMI64Vector val1, LLVMPointerVector val2) {
        assert (this.checkLength(val1, val2));
        boolean[] result = new boolean[this.vectorLength];
        for (int i = 0; i < this.vectorLength; ++i) {
            result[i] = this.compare.executeWithTarget(val1.getValue(i), val2.getValue(i));
        }
        return LLVMI1Vector.create(result);
    }

    @ExplodeLoop
    @Specialization
    protected LLVMI1Vector doPointer(LLVMPointerVector val1, LLVMPointerVector val2) {
        assert (this.checkLength(val1, val2));
        boolean[] result = new boolean[this.vectorLength];
        for (int i = 0; i < this.vectorLength; ++i) {
            result[i] = this.compare.executeWithTarget(val1.getValue(i), val2.getValue(i));
        }
        return LLVMI1Vector.create(result);
    }

    @ExplodeLoop
    @Specialization
    protected LLVMI1Vector doDouble(LLVMDoubleVector val1, LLVMDoubleVector val2) {
        assert (this.checkLength(val1, val2));
        boolean[] result = new boolean[this.vectorLength];
        for (int i = 0; i < this.vectorLength; ++i) {
            result[i] = this.compare.executeWithTarget(val1.getValue(i), val2.getValue(i));
        }
        return LLVMI1Vector.create(result);
    }

    @ExplodeLoop
    @Specialization
    protected LLVMI1Vector doFloat(LLVMFloatVector val1, LLVMFloatVector val2) {
        assert (this.checkLength(val1, val2));
        boolean[] result = new boolean[this.vectorLength];
        for (int i = 0; i < this.vectorLength; ++i) {
            result[i] = this.compare.executeWithTarget(Float.valueOf(val1.getValue(i)), Float.valueOf(val2.getValue(i)));
        }
        return LLVMI1Vector.create(result);
    }
}

