/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.UnaryOperation;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMUnaryNode;

@GeneratedBy(value=LLVMUnaryNode.class)
public final class LLVMUnaryNodeFactory {

    @GeneratedBy(value=LLVMUnaryNode.LLVMFP80UnaryNode.class)
    public static final class LLVMFP80UnaryNodeGen
    extends LLVMUnaryNode.LLVMFP80UnaryNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode operandNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMFP80UnaryNodeGen(UnaryOperation op, LLVMExpressionNode operandNode) {
            super(op);
            this.operandNode_ = operandNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeWithTarget(Object operandNodeValue) {
            int state = this.state_;
            if (state != 0 && operandNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat operandNodeValue_ = (LLVM80BitFloat)operandNodeValue;
                return this.do80BitFloat(operandNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(operandNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object operandNodeValue_ = this.operandNode_.executeGeneric(frameValue);
            if (state != 0 && operandNodeValue_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat operandNodeValue__ = (LLVM80BitFloat)operandNodeValue_;
                return this.do80BitFloat(operandNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(operandNodeValue_);
        }

        private LLVM80BitFloat executeAndSpecialize(Object operandNodeValue) {
            int state = this.state_;
            if (operandNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat operandNodeValue_ = (LLVM80BitFloat)operandNodeValue;
                this.state_ = state |= 1;
                return this.do80BitFloat(operandNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.operandNode_}, new Object[]{operandNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMUnaryNode.LLVMFP80UnaryNode create(UnaryOperation op, LLVMExpressionNode operandNode) {
            return new LLVMFP80UnaryNodeGen(op, operandNode);
        }
    }

    @GeneratedBy(value=LLVMUnaryNode.LLVMDoubleUnaryNode.class)
    public static final class LLVMDoubleUnaryNodeGen
    extends LLVMUnaryNode.LLVMDoubleUnaryNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode operandNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMDoubleUnaryNodeGen(UnaryOperation op, LLVMExpressionNode operandNode) {
            super(op);
            this.operandNode_ = operandNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeWithTarget(Object operandNodeValue) {
            int state = this.state_;
            if (state != 0 && operandNodeValue instanceof Double) {
                double operandNodeValue_ = (Double)operandNodeValue;
                return this.doDouble(operandNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(operandNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            double operandNodeValue_;
            int state = this.state_;
            try {
                operandNodeValue_ = this.operandNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doDouble(operandNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(operandNodeValue_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) {
            double operandNodeValue_;
            int state = this.state_;
            try {
                operandNodeValue_ = this.operandNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doDouble(operandNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(operandNodeValue_);
        }

        private double executeAndSpecialize(Object operandNodeValue) {
            int state = this.state_;
            if (operandNodeValue instanceof Double) {
                double operandNodeValue_ = (Double)operandNodeValue;
                this.state_ = state |= 1;
                return this.doDouble(operandNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.operandNode_}, new Object[]{operandNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMUnaryNode.LLVMDoubleUnaryNode create(UnaryOperation op, LLVMExpressionNode operandNode) {
            return new LLVMDoubleUnaryNodeGen(op, operandNode);
        }
    }

    @GeneratedBy(value=LLVMUnaryNode.LLVMFloatUnaryNode.class)
    public static final class LLVMFloatUnaryNodeGen
    extends LLVMUnaryNode.LLVMFloatUnaryNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode operandNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMFloatUnaryNodeGen(UnaryOperation op, LLVMExpressionNode operandNode) {
            super(op);
            this.operandNode_ = operandNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeWithTarget(Object operandNodeValue) {
            int state = this.state_;
            if (state != 0 && operandNodeValue instanceof Float) {
                float operandNodeValue_ = ((Float)operandNodeValue).floatValue();
                return Float.valueOf(this.doFloat(operandNodeValue_));
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return Float.valueOf(this.executeAndSpecialize(operandNodeValue));
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            float operandNodeValue_;
            int state = this.state_;
            try {
                operandNodeValue_ = this.operandNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return Float.valueOf(this.executeAndSpecialize(ex.getResult()));
            }
            if (state != 0) {
                return Float.valueOf(this.doFloat(operandNodeValue_));
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return Float.valueOf(this.executeAndSpecialize(Float.valueOf(operandNodeValue_)));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) {
            float operandNodeValue_;
            int state = this.state_;
            try {
                operandNodeValue_ = this.operandNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doFloat(operandNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(Float.valueOf(operandNodeValue_));
        }

        private float executeAndSpecialize(Object operandNodeValue) {
            int state = this.state_;
            if (operandNodeValue instanceof Float) {
                float operandNodeValue_ = ((Float)operandNodeValue).floatValue();
                this.state_ = state |= 1;
                return this.doFloat(operandNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.operandNode_}, new Object[]{operandNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMUnaryNode.LLVMFloatUnaryNode create(UnaryOperation op, LLVMExpressionNode operandNode) {
            return new LLVMFloatUnaryNodeGen(op, operandNode);
        }
    }
}

