/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMPointerStoreNode.class)
public final class LLVMPointerStoreNodeGen
extends LLVMPointerStoreNode {
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<LLVMManagedWriteLibrary> L_L_V_M_MANAGED_WRITE_LIBRARY_ = LibraryFactory.resolve(LLVMManagedWriteLibrary.class);
    private LLVMSourceLocation sourceLocation;
    private boolean statement;
    @Node.Child
    private LLVMExpressionNode address_;
    @Node.Child
    private LLVMExpressionNode value_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;
    @Node.Child
    private LLVMToNativeNode address0_toNative_;
    @Node.Child
    private LLVMToNativeNode address1_toNative_;
    @Node.Child
    private OpDerefHandleData opDerefHandle_cache;
    @Node.Child
    private DerefAddressData derefAddress_cache;
    @Node.Child
    private TruffleObject0Data truffleObject0_cache;
    @Node.Child
    private LLVMToPointerNode truffleObject1_toPointer_;

    private LLVMPointerStoreNodeGen(LLVMExpressionNode address, LLVMExpressionNode value) {
        this.address_ = address;
        this.value_ = value;
    }

    @Override
    public LLVMSourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    protected boolean isStatement() {
        return this.statement;
    }

    @Override
    protected void setStatement(boolean statement) {
        this.statement = statement;
    }

    @Override
    @ExplodeLoop
    public void executeWithTarget(Object addressValue, Object valueValue) {
        int state = this.state_;
        if (state != 0) {
            LLVMNativePointer addressValue_;
            if ((state & 1) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__ = this.lLVMLanguageReference_;
                LLVMLanguage address0_language__ = (LLVMLanguage)lLVMLanguageReference__.get();
                if (!LLVMNode.isAutoDerefHandle(address0_language__, addressValue_)) {
                    this.doAddress(addressValue_, valueValue, this.address0_toNative_, address0_language__);
                    return;
                }
            }
            if ((state & 2) != 0 && addressValue instanceof Long) {
                long addressValue_2 = (Long)addressValue;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__1 = this.lLVMLanguageReference_;
                LLVMLanguage address1_language__ = (LLVMLanguage)lLVMLanguageReference__1.get();
                if (!LLVMNode.isAutoDerefHandle(address1_language__, addressValue_2)) {
                    this.doAddress(addressValue_2, valueValue, this.address1_toNative_, address1_language__);
                    return;
                }
            }
            if ((state & 4) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__2;
                LLVMLanguage language__;
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                OpDerefHandleData s3_ = this.opDerefHandle_cache;
                if (s3_ != null && LLVMNode.isAutoDerefHandle(language__ = (LLVMLanguage)(lLVMLanguageReference__2 = this.lLVMLanguageReference_).get(), addressValue_)) {
                    this.doOpDerefHandle(addressValue_, valueValue, s3_.toPointer_, language__, s3_.getReceiver_, s3_.nativeWrite_);
                    return;
                }
            }
            if ((state & 8) != 0 && addressValue instanceof Long) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__3;
                LLVMLanguage language__1;
                long addressValue_3 = (Long)addressValue;
                DerefAddressData s4_ = this.derefAddress_cache;
                if (s4_ != null && LLVMNode.isAutoDerefHandle(language__1 = (LLVMLanguage)(lLVMLanguageReference__3 = this.lLVMLanguageReference_).get(), addressValue_3)) {
                    this.doDerefAddress(addressValue_3, valueValue, s4_.toPointer_, language__1, s4_.getReceiver_, s4_.nativeWrite_);
                    return;
                }
            }
            if ((state & 0x30) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_4 = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 0x10) != 0) {
                    TruffleObject0Data s5_ = this.truffleObject0_cache;
                    while (s5_ != null) {
                        if (s5_.nativeWrite_.accepts(addressValue_4.getObject())) {
                            this.doTruffleObject(addressValue_4, valueValue, s5_.toPointer_, s5_.nativeWrite_);
                            return;
                        }
                        s5_ = s5_.next_;
                    }
                }
                if ((state & 0x20) != 0) {
                    this.truffleObject1Boundary(state, addressValue_4, valueValue);
                    return;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(addressValue, valueValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private void truffleObject1Boundary(int state, LLVMManagedPointer addressValue_, Object valueValue) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            LLVMManagedWriteLibrary truffleObject1_nativeWrite__ = (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject());
            this.doTruffleObject(addressValue_, valueValue, this.truffleObject1_toPointer_, truffleObject1_nativeWrite__);
            return;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    @Override
    public void execute(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 0x35) == 0 && state != 0) {
            this.execute_long0(frameValue, state);
            return;
        }
        this.execute_generic1(frameValue, state);
    }

    private void execute_long0(VirtualFrame frameValue, int state) {
        long addressValue_;
        try {
            addressValue_ = this.address_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object valueValue = this.value_.executeGeneric(frameValue);
            this.executeAndSpecialize(ex.getResult(), valueValue);
            return;
        }
        Object valueValue_ = this.value_.executeGeneric(frameValue);
        if ((state & 0xA) != 0) {
            TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__5;
            LLVMLanguage language__1;
            DerefAddressData s4_;
            TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__4;
            LLVMLanguage address1_language__;
            if ((state & 2) != 0 && !LLVMNode.isAutoDerefHandle(address1_language__ = (LLVMLanguage)(lLVMLanguageReference__4 = this.lLVMLanguageReference_).get(), addressValue_)) {
                this.doAddress(addressValue_, valueValue_, this.address1_toNative_, address1_language__);
                return;
            }
            if ((state & 8) != 0 && (s4_ = this.derefAddress_cache) != null && LLVMNode.isAutoDerefHandle(language__1 = (LLVMLanguage)(lLVMLanguageReference__5 = this.lLVMLanguageReference_).get(), addressValue_)) {
                this.doDerefAddress(addressValue_, valueValue_, s4_.toPointer_, language__1, s4_.getReceiver_, s4_.nativeWrite_);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(addressValue_, valueValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private void truffleObject1Boundary0(int state, LLVMManagedPointer addressValue__, Object valueValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            LLVMManagedWriteLibrary truffleObject1_nativeWrite__ = (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue__.getObject());
            this.doTruffleObject(addressValue__, valueValue_, this.truffleObject1_toPointer_, truffleObject1_nativeWrite__);
            return;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    private void execute_generic1(VirtualFrame frameValue, int state) {
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        Object valueValue_ = this.value_.executeGeneric(frameValue);
        if (state != 0) {
            LLVMNativePointer addressValue__;
            if ((state & 1) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__6 = this.lLVMLanguageReference_;
                LLVMLanguage address0_language__ = (LLVMLanguage)lLVMLanguageReference__6.get();
                if (!LLVMNode.isAutoDerefHandle(address0_language__, addressValue__)) {
                    this.doAddress(addressValue__, valueValue_, this.address0_toNative_, address0_language__);
                    return;
                }
            }
            if ((state & 2) != 0 && addressValue_ instanceof Long) {
                long addressValue__2 = (Long)addressValue_;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__7 = this.lLVMLanguageReference_;
                LLVMLanguage address1_language__ = (LLVMLanguage)lLVMLanguageReference__7.get();
                if (!LLVMNode.isAutoDerefHandle(address1_language__, addressValue__2)) {
                    this.doAddress(addressValue__2, valueValue_, this.address1_toNative_, address1_language__);
                    return;
                }
            }
            if ((state & 4) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__8;
                LLVMLanguage language__;
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                OpDerefHandleData s3_ = this.opDerefHandle_cache;
                if (s3_ != null && LLVMNode.isAutoDerefHandle(language__ = (LLVMLanguage)(lLVMLanguageReference__8 = this.lLVMLanguageReference_).get(), addressValue__)) {
                    this.doOpDerefHandle(addressValue__, valueValue_, s3_.toPointer_, language__, s3_.getReceiver_, s3_.nativeWrite_);
                    return;
                }
            }
            if ((state & 8) != 0 && addressValue_ instanceof Long) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__9;
                LLVMLanguage language__1;
                long addressValue__3 = (Long)addressValue_;
                DerefAddressData s4_ = this.derefAddress_cache;
                if (s4_ != null && LLVMNode.isAutoDerefHandle(language__1 = (LLVMLanguage)(lLVMLanguageReference__9 = this.lLVMLanguageReference_).get(), addressValue__3)) {
                    this.doDerefAddress(addressValue__3, valueValue_, s4_.toPointer_, language__1, s4_.getReceiver_, s4_.nativeWrite_);
                    return;
                }
            }
            if ((state & 0x30) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                LLVMManagedPointer addressValue__4 = LLVMTypes.asManagedPointer(addressValue_);
                if ((state & 0x10) != 0) {
                    TruffleObject0Data s5_ = this.truffleObject0_cache;
                    while (s5_ != null) {
                        if (s5_.nativeWrite_.accepts(addressValue__4.getObject())) {
                            this.doTruffleObject(addressValue__4, valueValue_, s5_.toPointer_, s5_.nativeWrite_);
                            return;
                        }
                        s5_ = s5_.next_;
                    }
                }
                if ((state & 0x20) != 0) {
                    this.truffleObject1Boundary0(state, addressValue__4, valueValue_);
                    return;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(addressValue_, valueValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAndSpecialize(Object addressValue, Object valueValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            LLVMLanguage address0_language__ = null;
            if (LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                TruffleLanguage.LanguageReference lLVMLanguageReference__10 = this.lLVMLanguageReference_;
                if (lLVMLanguageReference__10 == null) {
                    this.lLVMLanguageReference_ = lLVMLanguageReference__10 = super.lookupLanguageReference(LLVMLanguage.class);
                }
                if (!LLVMNode.isAutoDerefHandle(address0_language__ = (LLVMLanguage)lLVMLanguageReference__10.get(), addressValue_)) {
                    this.address0_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    this.doAddress(addressValue_, valueValue, this.address0_toNative_, address0_language__);
                    return;
                }
            }
            LLVMLanguage address1_language__ = null;
            if (addressValue instanceof Long) {
                long addressValue_ = (Long)addressValue;
                TruffleLanguage.LanguageReference lLVMLanguageReference__11 = this.lLVMLanguageReference_;
                if (lLVMLanguageReference__11 == null) {
                    this.lLVMLanguageReference_ = lLVMLanguageReference__11 = super.lookupLanguageReference(LLVMLanguage.class);
                }
                if (!LLVMNode.isAutoDerefHandle(address1_language__ = (LLVMLanguage)lLVMLanguageReference__11.get(), addressValue_)) {
                    this.address1_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    this.doAddress(addressValue_, valueValue, this.address1_toNative_, address1_language__);
                    return;
                }
            }
            LLVMLanguage language__ = null;
            if (LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                TruffleLanguage.LanguageReference lLVMLanguageReference__12 = this.lLVMLanguageReference_;
                if (lLVMLanguageReference__12 == null) {
                    this.lLVMLanguageReference_ = lLVMLanguageReference__12 = super.lookupLanguageReference(LLVMLanguage.class);
                }
                if (LLVMNode.isAutoDerefHandle(language__ = (LLVMLanguage)lLVMLanguageReference__12.get(), addressValue_)) {
                    OpDerefHandleData s3_ = (OpDerefHandleData)super.insert((Node)new OpDerefHandleData());
                    s3_.toPointer_ = s3_.insertAccessor(LLVMToPointerNodeGen.create());
                    s3_.getReceiver_ = s3_.insertAccessor(LLVMDerefHandleGetReceiverNodeGen.create());
                    s3_.nativeWrite_ = (LLVMManagedWriteLibrary)s3_.insertAccessor(L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3));
                    this.opDerefHandle_cache = s3_;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    this.doOpDerefHandle(addressValue_, valueValue, s3_.toPointer_, language__, s3_.getReceiver_, s3_.nativeWrite_);
                    return;
                }
            }
            LLVMLanguage language__1 = null;
            if (addressValue instanceof Long) {
                long addressValue_ = (Long)addressValue;
                TruffleLanguage.LanguageReference lLVMLanguageReference__13 = this.lLVMLanguageReference_;
                if (lLVMLanguageReference__13 == null) {
                    this.lLVMLanguageReference_ = lLVMLanguageReference__13 = super.lookupLanguageReference(LLVMLanguage.class);
                }
                if (LLVMNode.isAutoDerefHandle(language__1 = (LLVMLanguage)lLVMLanguageReference__13.get(), addressValue_)) {
                    DerefAddressData s4_ = (DerefAddressData)super.insert((Node)new DerefAddressData());
                    s4_.toPointer_ = s4_.insertAccessor(LLVMToPointerNodeGen.create());
                    s4_.getReceiver_ = s4_.insertAccessor(LLVMDerefHandleGetReceiverNodeGen.create());
                    s4_.nativeWrite_ = (LLVMManagedWriteLibrary)s4_.insertAccessor(L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3));
                    this.derefAddress_cache = s4_;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    this.doDerefAddress(addressValue_, valueValue, s4_.toPointer_, language__1, s4_.getReceiver_, s4_.nativeWrite_);
                    return;
                }
            }
            if (LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if (exclude == 0) {
                    int count5_ = 0;
                    TruffleObject0Data s5_ = this.truffleObject0_cache;
                    if ((state & 0x10) != 0) {
                        while (s5_ != null && !s5_.nativeWrite_.accepts(addressValue_.getObject())) {
                            s5_ = s5_.next_;
                            ++count5_;
                        }
                    }
                    if (s5_ == null && count5_ < 3) {
                        s5_ = (TruffleObject0Data)super.insert((Node)new TruffleObject0Data(this.truffleObject0_cache));
                        s5_.toPointer_ = s5_.insertAccessor(LLVMToPointerNodeGen.create());
                        s5_.nativeWrite_ = (LLVMManagedWriteLibrary)s5_.insertAccessor(L_L_V_M_MANAGED_WRITE_LIBRARY_.create(addressValue_.getObject()));
                        this.truffleObject0_cache = s5_;
                        this.state_ = state |= 0x10;
                    }
                    if (s5_ != null) {
                        lock.unlock();
                        hasLock = false;
                        this.doTruffleObject(addressValue_, valueValue, s5_.toPointer_, s5_.nativeWrite_);
                        return;
                    }
                }
                LLVMManagedWriteLibrary truffleObject1_nativeWrite__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    this.truffleObject1_toPointer_ = (LLVMToPointerNode)super.insert((Node)LLVMToPointerNodeGen.create());
                    truffleObject1_nativeWrite__ = (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject());
                    this.exclude_ = exclude |= 1;
                    this.truffleObject0_cache = null;
                    state &= 0xFFFFFFEF;
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    this.doTruffleObject(addressValue_, valueValue, this.truffleObject1_toPointer_, truffleObject1_nativeWrite__);
                    return;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_, this.value_}, new Object[]{addressValue, valueValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        TruffleObject0Data s5_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s5_ = this.truffleObject0_cache) == null || s5_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMPointerStoreNode create(LLVMExpressionNode address, LLVMExpressionNode value) {
        return new LLVMPointerStoreNodeGen(address, value);
    }

    public static LLVMPointerStoreNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=LLVMPointerStoreNode.class)
    private static final class Uncached
    extends LLVMPointerStoreNode {
        private final TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_ = this.lookupLanguageReference(LLVMLanguage.class);

        private Uncached() {
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected boolean isStatement() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void setStatement(boolean statementTag) {
            throw new UnsupportedOperationException();
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void executeWithTarget(Object addressValue, Object valueValue) {
            LLVMNativePointer addressValue_;
            if (LLVMTypes.isNativePointer(addressValue)) {
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if (!LLVMNode.isAutoDerefHandle((LLVMLanguage)this.lLVMLanguageReference_.get(), addressValue_)) {
                    this.doAddress(addressValue_, valueValue, LLVMToNativeNodeGen.getUncached(), (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
            }
            if (addressValue instanceof Long) {
                long addressValue_2 = (Long)addressValue;
                if (!LLVMNode.isAutoDerefHandle((LLVMLanguage)this.lLVMLanguageReference_.get(), addressValue_2)) {
                    this.doAddress(addressValue_2, valueValue, LLVMToNativeNodeGen.getUncached(), (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
            }
            if (LLVMTypes.isNativePointer(addressValue)) {
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if (LLVMNode.isAutoDerefHandle((LLVMLanguage)this.lLVMLanguageReference_.get(), addressValue_)) {
                    this.doOpDerefHandle(addressValue_, valueValue, LLVMToPointerNodeGen.getUncached(), (LLVMLanguage)this.lLVMLanguageReference_.get(), LLVMDerefHandleGetReceiverNodeGen.getUncached(), (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached());
                    return;
                }
            }
            if (addressValue instanceof Long) {
                long addressValue_3 = (Long)addressValue;
                if (LLVMNode.isAutoDerefHandle((LLVMLanguage)this.lLVMLanguageReference_.get(), addressValue_3)) {
                    this.doDerefAddress(addressValue_3, valueValue, LLVMToPointerNodeGen.getUncached(), (LLVMLanguage)this.lLVMLanguageReference_.get(), LLVMDerefHandleGetReceiverNodeGen.getUncached(), (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached());
                    return;
                }
            }
            if (LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_4 = LLVMTypes.asManagedPointer(addressValue);
                this.doTruffleObject(addressValue_4, valueValue, LLVMToPointerNodeGen.getUncached(), (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_4.getObject()));
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{addressValue, valueValue});
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            throw CompilerDirectives.shouldNotReachHere((String)"This execute method cannot be used for uncached node versions as it requires child nodes to be present. Use an execute method that takes all arguments as parameters.");
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=LLVMPointerStoreNode.class)
    private static final class TruffleObject0Data
    extends Node {
        @Node.Child
        TruffleObject0Data next_;
        @Node.Child
        LLVMToPointerNode toPointer_;
        @Node.Child
        LLVMManagedWriteLibrary nativeWrite_;

        TruffleObject0Data(TruffleObject0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=LLVMPointerStoreNode.class)
    private static final class DerefAddressData
    extends Node {
        @Node.Child
        LLVMToPointerNode toPointer_;
        @Node.Child
        LLVMDerefHandleGetReceiverNode getReceiver_;
        @Node.Child
        LLVMManagedWriteLibrary nativeWrite_;

        DerefAddressData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=LLVMPointerStoreNode.class)
    private static final class OpDerefHandleData
    extends Node {
        @Node.Child
        LLVMToPointerNode toPointer_;
        @Node.Child
        LLVMDerefHandleGetReceiverNode getReceiver_;
        @Node.Child
        LLVMManagedWriteLibrary nativeWrite_;

        OpDerefHandleData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

