/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMStoreNodeCommon;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@GenerateUncached
public abstract class LLVMI64StoreNode
extends LLVMStoreNodeCommon {
    @Specialization(guards={"!isAutoDerefHandle(language, address)"})
    protected void doOp(LLVMNativePointer address, long value, @CachedLanguage LLVMLanguage language) {
        language.getLLVMMemory().putI64((Node)this, address, value);
    }

    @Specialization(guards={"isAutoDerefHandle(language, addr)"})
    protected void doOpDerefHandleI64(LLVMNativePointer addr, long value, @CachedLanguage LLVMLanguage language, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
        this.doOpManagedI64(getReceiver.execute(addr), value, nativeWrite);
    }

    @Specialization(guards={"isAutoDerefHandle(language, addr)"}, replaces={"doOpDerefHandleI64"})
    protected void doOpDerefHandle(LLVMNativePointer addr, Object value, @CachedLanguage LLVMLanguage language, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
        this.doOpManaged(getReceiver.execute(addr), value, nativeWrite);
    }

    @Specialization(guards={"!isAutoDerefHandle(language, address)"})
    protected void doOpNative(LLVMNativePointer address, LLVMNativePointer value, @CachedLanguage LLVMLanguage language) {
        language.getLLVMMemory().putI64((Node)this, address, value.asNative());
    }

    @Specialization(replaces={"doOpNative"}, guards={"!isAutoDerefHandle(language, addr)"})
    protected void doOp(LLVMNativePointer addr, Object value, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toAddress, @CachedLanguage LLVMLanguage language) {
        language.getLLVMMemory().putI64((Node)this, addr, toAddress.executeWithTarget(value).asNative());
    }

    @Specialization(limit="3")
    protected void doOpManagedI64(LLVMManagedPointer address, long value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        nativeWrite.writeI64(address.getObject(), address.getOffset(), value);
    }

    @Specialization(limit="3", replaces={"doOpManagedI64"})
    protected void doOpManaged(LLVMManagedPointer address, Object value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        nativeWrite.writeGenericI64(address.getObject(), address.getOffset(), value);
    }
}

