/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVM80BitFloatStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMStoreNodeCommon;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public abstract class LLVM80BitFloatStoreNode
extends LLVMStoreNodeCommon {
    static LLVM80BitFloatStoreNode create() {
        return LLVM80BitFloatStoreNodeGen.create(null, null);
    }

    protected abstract void executeManaged(LLVMManagedPointer var1, LLVM80BitFloat var2);

    @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
    protected void doOp(LLVMNativePointer addr, LLVM80BitFloat value, @CachedLanguage LLVMLanguage language) {
        language.getLLVMMemory().put80BitFloat((Node)this, addr, value);
    }

    @Specialization(guards={"isAutoDerefHandle(language, addr)"})
    protected void doOpDerefHandle(LLVMNativePointer addr, LLVM80BitFloat value, @CachedLanguage LLVMLanguage language, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @Cached LLVM80BitFloatStoreNode store) {
        store.executeManaged(getReceiver.execute(addr), value);
    }

    @ExplodeLoop
    @Specialization(limit="3")
    protected void doForeign(LLVMManagedPointer address, LLVM80BitFloat value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        byte[] bytes = value.getBytes();
        assert (bytes.length == 10);
        long curOffset = address.getOffset();
        for (int i = 0; i < 10; ++i) {
            nativeWrite.writeI8(address.getObject(), curOffset, bytes[i]);
            ++curOffset;
        }
    }
}

