/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMLoadVectorNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMLoadVectorNode.class)
public final class LLVMLoadVectorNodeFactory {
    private static final LibraryFactory<LLVMManagedReadLibrary> L_L_V_M_MANAGED_READ_LIBRARY_ = LibraryFactory.resolve(LLVMManagedReadLibrary.class);

    @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.class)
    public static final class LLVMLoadDoubleVectorNodeGen
    extends LLVMLoadVectorNode.LLVMLoadDoubleVectorNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode address_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;
        @Node.Child
        private LLVMDerefHandleGetReceiverNode doubleVector_getReceiver_;
        @Node.Child
        private LLVMLoadVectorNode.LLVMLoadDoubleVectorNode doubleVector_load_;
        @Node.Child
        private Foreign0Data foreign0_cache;

        private LLVMLoadDoubleVectorNodeGen(LLVMExpressionNode address, int vectorLength) {
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        @ExplodeLoop
        public Object executeWithTarget(Object addressValue) {
            LLVMPointer addressValue_;
            int state = this.state_;
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__1;
                LLVMLanguage doubleVector_language__;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__;
                LLVMLanguage doubleVectorNative_language__;
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state & 1) != 0 && !LLVMNode.isAutoDerefHandle(doubleVectorNative_language__ = (LLVMLanguage)(lLVMLanguageReference__ = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue_)) {
                    return this.doDoubleVectorNative((LLVMNativePointer)addressValue_, doubleVectorNative_language__);
                }
                if ((state & 2) != 0 && LLVMNode.isAutoDerefHandle(doubleVector_language__ = (LLVMLanguage)(lLVMLanguageReference__1 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue_)) {
                    return this.doDoubleVector((LLVMNativePointer)addressValue_, this.doubleVector_getReceiver_, doubleVector_language__, this.doubleVector_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue_.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary(state, (LLVMManagedPointer)addressValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary(int state, LLVMManagedPointer addressValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject());
                LLVMDoubleVector lLVMDoubleVector = this.doForeign(addressValue_, foreign1_nativeRead__);
                return lLVMDoubleVector;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        @ExplodeLoop
        protected LLVMDoubleVector executeManaged(LLVMManagedPointer addressValue) {
            int state = this.state_;
            if ((state & 0xC) != 0) {
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue.getObject())) {
                            return this.doForeign(addressValue, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary0(state, addressValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private LLVMDoubleVector foreign1Boundary0(int state, LLVMManagedPointer addressValue) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue.getObject());
                LLVMDoubleVector lLVMDoubleVector = this.doForeign(addressValue, foreign1_nativeRead__);
                return lLVMDoubleVector;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        @ExplodeLoop
        public Object executeGeneric(VirtualFrame frameValue) {
            LLVMPointer addressValue__;
            int state = this.state_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__3;
                LLVMLanguage doubleVector_language__;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__2;
                LLVMLanguage doubleVectorNative_language__;
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state & 1) != 0 && !LLVMNode.isAutoDerefHandle(doubleVectorNative_language__ = (LLVMLanguage)(lLVMLanguageReference__2 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue__)) {
                    return this.doDoubleVectorNative((LLVMNativePointer)addressValue__, doubleVectorNative_language__);
                }
                if ((state & 2) != 0 && LLVMNode.isAutoDerefHandle(doubleVector_language__ = (LLVMLanguage)(lLVMLanguageReference__3 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue__)) {
                    return this.doDoubleVector((LLVMNativePointer)addressValue__, this.doubleVector_getReceiver_, doubleVector_language__, this.doubleVector_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue__.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue__, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary1(state, (LLVMManagedPointer)addressValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary1(int state, LLVMManagedPointer addressValue__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject());
                LLVMDoubleVector lLVMDoubleVector = this.doForeign(addressValue__, foreign1_nativeRead__);
                return lLVMDoubleVector;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LLVMDoubleVector executeAndSpecialize(Object addressValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                LLVMPointer addressValue_;
                if (LLVMTypes.isNativePointer(addressValue)) {
                    addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    LLVMLanguage doubleVectorNative_language__ = null;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__4 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__4 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__4 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (!LLVMNode.isAutoDerefHandle(doubleVectorNative_language__ = (LLVMLanguage)lLVMLanguageReference__4.get(), (LLVMNativePointer)addressValue_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMDoubleVector lLVMDoubleVector = this.doDoubleVectorNative((LLVMNativePointer)addressValue_, doubleVectorNative_language__);
                        return lLVMDoubleVector;
                    }
                    LLVMLanguage doubleVector_language__ = null;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__5 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__5 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__5 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (LLVMNode.isAutoDerefHandle(doubleVector_language__ = (LLVMLanguage)lLVMLanguageReference__5.get(), (LLVMNativePointer)addressValue_)) {
                        this.doubleVector_getReceiver_ = (LLVMDerefHandleGetReceiverNode)super.insert((Node)LLVMDerefHandleGetReceiverNodeGen.create());
                        this.doubleVector_load_ = (LLVMLoadVectorNode.LLVMLoadDoubleVectorNode)super.insert((Node)this.createRecursive());
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVMDoubleVector lLVMDoubleVector = this.doDoubleVector((LLVMNativePointer)addressValue_, this.doubleVector_getReceiver_, doubleVector_language__, this.doubleVector_load_);
                        return lLVMDoubleVector;
                    }
                }
                if (LLVMTypes.isManagedPointer(addressValue)) {
                    addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if (exclude == 0) {
                        int count3_ = 0;
                        Foreign0Data s3_ = this.foreign0_cache;
                        if ((state & 4) != 0) {
                            while (s3_ != null && !s3_.nativeRead_.accepts(addressValue_.getObject())) {
                                s3_ = s3_.next_;
                                ++count3_;
                            }
                        }
                        if (s3_ == null && count3_ < 3) {
                            s3_ = (Foreign0Data)super.insert((Node)new Foreign0Data(this.foreign0_cache));
                            s3_.nativeRead_ = (LLVMManagedReadLibrary)s3_.insertAccessor(L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject()));
                            this.foreign0_cache = s3_;
                            this.state_ = state |= 4;
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVMDoubleVector lLVMDoubleVector = this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                            return lLVMDoubleVector;
                        }
                    }
                    LLVMManagedReadLibrary foreign1_nativeRead__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject());
                        this.exclude_ = exclude |= 1;
                        this.foreign0_cache = null;
                        state &= 0xFFFFFFFB;
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        LLVMDoubleVector lLVMDoubleVector = this.doForeign((LLVMManagedPointer)addressValue_, foreign1_nativeRead__);
                        return lLVMDoubleVector;
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            Foreign0Data s3_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s3_ = this.foreign0_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMLoadVectorNode.LLVMLoadDoubleVectorNode create(LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadDoubleVectorNodeGen(address, vectorLength);
        }

        @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.class)
        private static final class Foreign0Data
        extends Node {
            @Node.Child
            Foreign0Data next_;
            @Node.Child
            LLVMManagedReadLibrary nativeRead_;

            Foreign0Data(Foreign0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadFloatVectorNode.class)
    public static final class LLVMLoadFloatVectorNodeGen
    extends LLVMLoadVectorNode.LLVMLoadFloatVectorNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode address_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;
        @Node.Child
        private LLVMDerefHandleGetReceiverNode floatVectorDerefHandle_getReceiver_;
        @Node.Child
        private LLVMLoadVectorNode.LLVMLoadFloatVectorNode floatVectorDerefHandle_load_;
        @Node.Child
        private Foreign0Data foreign0_cache;

        private LLVMLoadFloatVectorNodeGen(LLVMExpressionNode address, int vectorLength) {
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        @ExplodeLoop
        public Object executeWithTarget(Object addressValue) {
            LLVMPointer addressValue_;
            int state = this.state_;
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__1;
                LLVMLanguage floatVectorDerefHandle_language__;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__;
                LLVMLanguage floatVectorNative_language__;
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state & 1) != 0 && !LLVMNode.isAutoDerefHandle(floatVectorNative_language__ = (LLVMLanguage)(lLVMLanguageReference__ = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue_)) {
                    return this.doFloatVectorNative((LLVMNativePointer)addressValue_, floatVectorNative_language__);
                }
                if ((state & 2) != 0 && LLVMNode.isAutoDerefHandle(floatVectorDerefHandle_language__ = (LLVMLanguage)(lLVMLanguageReference__1 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue_)) {
                    return this.doFloatVectorDerefHandle((LLVMNativePointer)addressValue_, this.floatVectorDerefHandle_getReceiver_, floatVectorDerefHandle_language__, this.floatVectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue_.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary(state, (LLVMManagedPointer)addressValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary(int state, LLVMManagedPointer addressValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject());
                LLVMFloatVector lLVMFloatVector = this.doForeign(addressValue_, foreign1_nativeRead__);
                return lLVMFloatVector;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        @ExplodeLoop
        protected LLVMFloatVector executeManaged(LLVMManagedPointer addressValue) {
            int state = this.state_;
            if ((state & 0xC) != 0) {
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue.getObject())) {
                            return this.doForeign(addressValue, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary0(state, addressValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private LLVMFloatVector foreign1Boundary0(int state, LLVMManagedPointer addressValue) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue.getObject());
                LLVMFloatVector lLVMFloatVector = this.doForeign(addressValue, foreign1_nativeRead__);
                return lLVMFloatVector;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        @ExplodeLoop
        public Object executeGeneric(VirtualFrame frameValue) {
            LLVMPointer addressValue__;
            int state = this.state_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__3;
                LLVMLanguage floatVectorDerefHandle_language__;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__2;
                LLVMLanguage floatVectorNative_language__;
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state & 1) != 0 && !LLVMNode.isAutoDerefHandle(floatVectorNative_language__ = (LLVMLanguage)(lLVMLanguageReference__2 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue__)) {
                    return this.doFloatVectorNative((LLVMNativePointer)addressValue__, floatVectorNative_language__);
                }
                if ((state & 2) != 0 && LLVMNode.isAutoDerefHandle(floatVectorDerefHandle_language__ = (LLVMLanguage)(lLVMLanguageReference__3 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue__)) {
                    return this.doFloatVectorDerefHandle((LLVMNativePointer)addressValue__, this.floatVectorDerefHandle_getReceiver_, floatVectorDerefHandle_language__, this.floatVectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue__.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue__, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary1(state, (LLVMManagedPointer)addressValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary1(int state, LLVMManagedPointer addressValue__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject());
                LLVMFloatVector lLVMFloatVector = this.doForeign(addressValue__, foreign1_nativeRead__);
                return lLVMFloatVector;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LLVMFloatVector executeAndSpecialize(Object addressValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                LLVMPointer addressValue_;
                if (LLVMTypes.isNativePointer(addressValue)) {
                    addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    LLVMLanguage floatVectorNative_language__ = null;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__4 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__4 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__4 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (!LLVMNode.isAutoDerefHandle(floatVectorNative_language__ = (LLVMLanguage)lLVMLanguageReference__4.get(), (LLVMNativePointer)addressValue_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMFloatVector lLVMFloatVector = this.doFloatVectorNative((LLVMNativePointer)addressValue_, floatVectorNative_language__);
                        return lLVMFloatVector;
                    }
                    LLVMLanguage floatVectorDerefHandle_language__ = null;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__5 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__5 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__5 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (LLVMNode.isAutoDerefHandle(floatVectorDerefHandle_language__ = (LLVMLanguage)lLVMLanguageReference__5.get(), (LLVMNativePointer)addressValue_)) {
                        this.floatVectorDerefHandle_getReceiver_ = (LLVMDerefHandleGetReceiverNode)super.insert((Node)LLVMDerefHandleGetReceiverNodeGen.create());
                        this.floatVectorDerefHandle_load_ = (LLVMLoadVectorNode.LLVMLoadFloatVectorNode)super.insert((Node)this.createRecursive());
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVMFloatVector lLVMFloatVector = this.doFloatVectorDerefHandle((LLVMNativePointer)addressValue_, this.floatVectorDerefHandle_getReceiver_, floatVectorDerefHandle_language__, this.floatVectorDerefHandle_load_);
                        return lLVMFloatVector;
                    }
                }
                if (LLVMTypes.isManagedPointer(addressValue)) {
                    addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if (exclude == 0) {
                        int count3_ = 0;
                        Foreign0Data s3_ = this.foreign0_cache;
                        if ((state & 4) != 0) {
                            while (s3_ != null && !s3_.nativeRead_.accepts(addressValue_.getObject())) {
                                s3_ = s3_.next_;
                                ++count3_;
                            }
                        }
                        if (s3_ == null && count3_ < 3) {
                            s3_ = (Foreign0Data)super.insert((Node)new Foreign0Data(this.foreign0_cache));
                            s3_.nativeRead_ = (LLVMManagedReadLibrary)s3_.insertAccessor(L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject()));
                            this.foreign0_cache = s3_;
                            this.state_ = state |= 4;
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVMFloatVector lLVMFloatVector = this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                            return lLVMFloatVector;
                        }
                    }
                    LLVMManagedReadLibrary foreign1_nativeRead__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject());
                        this.exclude_ = exclude |= 1;
                        this.foreign0_cache = null;
                        state &= 0xFFFFFFFB;
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        LLVMFloatVector lLVMFloatVector = this.doForeign((LLVMManagedPointer)addressValue_, foreign1_nativeRead__);
                        return lLVMFloatVector;
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            Foreign0Data s3_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s3_ = this.foreign0_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMLoadVectorNode.LLVMLoadFloatVectorNode create(LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadFloatVectorNodeGen(address, vectorLength);
        }

        @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadFloatVectorNode.class)
        private static final class Foreign0Data
        extends Node {
            @Node.Child
            Foreign0Data next_;
            @Node.Child
            LLVMManagedReadLibrary nativeRead_;

            Foreign0Data(Foreign0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadPointerVectorNode.class)
    public static final class LLVMLoadPointerVectorNodeGen
    extends LLVMLoadVectorNode.LLVMLoadPointerVectorNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode address_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;
        @Node.Child
        private LLVMDerefHandleGetReceiverNode pointerVectorDerefHandle_getReceiver_;
        @Node.Child
        private LLVMLoadVectorNode.LLVMLoadPointerVectorNode pointerVectorDerefHandle_load_;
        @Node.Child
        private ForeignPointers0Data foreignPointers0_cache;

        private LLVMLoadPointerVectorNodeGen(LLVMExpressionNode address, int vectorLength) {
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        @ExplodeLoop
        public Object executeWithTarget(Object addressValue) {
            LLVMPointer addressValue_;
            int state = this.state_;
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__1;
                LLVMLanguage pointerVectorDerefHandle_language__;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__;
                LLVMLanguage pointerVectorNative_language__;
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state & 1) != 0 && !LLVMNode.isAutoDerefHandle(pointerVectorNative_language__ = (LLVMLanguage)(lLVMLanguageReference__ = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue_)) {
                    return this.doPointerVectorNative((LLVMNativePointer)addressValue_, pointerVectorNative_language__);
                }
                if ((state & 2) != 0 && LLVMNode.isAutoDerefHandle(pointerVectorDerefHandle_language__ = (LLVMLanguage)(lLVMLanguageReference__1 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue_)) {
                    return this.doPointerVectorDerefHandle((LLVMNativePointer)addressValue_, this.pointerVectorDerefHandle_getReceiver_, pointerVectorDerefHandle_language__, this.pointerVectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 4) != 0) {
                    ForeignPointers0Data s3_ = this.foreignPointers0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue_.getObject())) {
                            return this.doForeignPointers((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreignPointers1Boundary(state, (LLVMManagedPointer)addressValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreignPointers1Boundary(int state, LLVMManagedPointer addressValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreignPointers1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject());
                LLVMPointerVector lLVMPointerVector = this.doForeignPointers(addressValue_, foreignPointers1_nativeRead__);
                return lLVMPointerVector;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        @ExplodeLoop
        protected LLVMPointerVector executeManaged(LLVMManagedPointer addressValue) {
            int state = this.state_;
            if ((state & 0xC) != 0) {
                if ((state & 4) != 0) {
                    ForeignPointers0Data s3_ = this.foreignPointers0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue.getObject())) {
                            return this.doForeignPointers(addressValue, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreignPointers1Boundary0(state, addressValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private LLVMPointerVector foreignPointers1Boundary0(int state, LLVMManagedPointer addressValue) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreignPointers1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue.getObject());
                LLVMPointerVector lLVMPointerVector = this.doForeignPointers(addressValue, foreignPointers1_nativeRead__);
                return lLVMPointerVector;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        @ExplodeLoop
        public Object executeGeneric(VirtualFrame frameValue) {
            LLVMPointer addressValue__;
            int state = this.state_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__3;
                LLVMLanguage pointerVectorDerefHandle_language__;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__2;
                LLVMLanguage pointerVectorNative_language__;
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state & 1) != 0 && !LLVMNode.isAutoDerefHandle(pointerVectorNative_language__ = (LLVMLanguage)(lLVMLanguageReference__2 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue__)) {
                    return this.doPointerVectorNative((LLVMNativePointer)addressValue__, pointerVectorNative_language__);
                }
                if ((state & 2) != 0 && LLVMNode.isAutoDerefHandle(pointerVectorDerefHandle_language__ = (LLVMLanguage)(lLVMLanguageReference__3 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue__)) {
                    return this.doPointerVectorDerefHandle((LLVMNativePointer)addressValue__, this.pointerVectorDerefHandle_getReceiver_, pointerVectorDerefHandle_language__, this.pointerVectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state & 4) != 0) {
                    ForeignPointers0Data s3_ = this.foreignPointers0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue__.getObject())) {
                            return this.doForeignPointers((LLVMManagedPointer)addressValue__, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreignPointers1Boundary1(state, (LLVMManagedPointer)addressValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreignPointers1Boundary1(int state, LLVMManagedPointer addressValue__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreignPointers1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject());
                LLVMPointerVector lLVMPointerVector = this.doForeignPointers(addressValue__, foreignPointers1_nativeRead__);
                return lLVMPointerVector;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LLVMPointerVector executeAndSpecialize(Object addressValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                LLVMPointer addressValue_;
                if (LLVMTypes.isNativePointer(addressValue)) {
                    addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    LLVMLanguage pointerVectorNative_language__ = null;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__4 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__4 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__4 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (!LLVMNode.isAutoDerefHandle(pointerVectorNative_language__ = (LLVMLanguage)lLVMLanguageReference__4.get(), (LLVMNativePointer)addressValue_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMPointerVector lLVMPointerVector = this.doPointerVectorNative((LLVMNativePointer)addressValue_, pointerVectorNative_language__);
                        return lLVMPointerVector;
                    }
                    LLVMLanguage pointerVectorDerefHandle_language__ = null;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__5 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__5 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__5 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (LLVMNode.isAutoDerefHandle(pointerVectorDerefHandle_language__ = (LLVMLanguage)lLVMLanguageReference__5.get(), (LLVMNativePointer)addressValue_)) {
                        this.pointerVectorDerefHandle_getReceiver_ = (LLVMDerefHandleGetReceiverNode)super.insert((Node)LLVMDerefHandleGetReceiverNodeGen.create());
                        this.pointerVectorDerefHandle_load_ = (LLVMLoadVectorNode.LLVMLoadPointerVectorNode)super.insert((Node)LLVMLoadVectorNode.LLVMLoadPointerVectorNode.create(this.getVectorLength()));
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVMPointerVector lLVMPointerVector = this.doPointerVectorDerefHandle((LLVMNativePointer)addressValue_, this.pointerVectorDerefHandle_getReceiver_, pointerVectorDerefHandle_language__, this.pointerVectorDerefHandle_load_);
                        return lLVMPointerVector;
                    }
                }
                if (LLVMTypes.isManagedPointer(addressValue)) {
                    addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if (exclude == 0) {
                        int count3_ = 0;
                        ForeignPointers0Data s3_ = this.foreignPointers0_cache;
                        if ((state & 4) != 0) {
                            while (s3_ != null && !s3_.nativeRead_.accepts(addressValue_.getObject())) {
                                s3_ = s3_.next_;
                                ++count3_;
                            }
                        }
                        if (s3_ == null && count3_ < 3) {
                            s3_ = (ForeignPointers0Data)super.insert((Node)new ForeignPointers0Data(this.foreignPointers0_cache));
                            s3_.nativeRead_ = (LLVMManagedReadLibrary)s3_.insertAccessor(L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject()));
                            this.foreignPointers0_cache = s3_;
                            this.state_ = state |= 4;
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVMPointerVector lLVMPointerVector = this.doForeignPointers((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                            return lLVMPointerVector;
                        }
                    }
                    LLVMManagedReadLibrary foreignPointers1_nativeRead__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        foreignPointers1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject());
                        this.exclude_ = exclude |= 1;
                        this.foreignPointers0_cache = null;
                        state &= 0xFFFFFFFB;
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        LLVMPointerVector lLVMPointerVector = this.doForeignPointers((LLVMManagedPointer)addressValue_, foreignPointers1_nativeRead__);
                        return lLVMPointerVector;
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            ForeignPointers0Data s3_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s3_ = this.foreignPointers0_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMLoadVectorNode.LLVMLoadPointerVectorNode create(LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadPointerVectorNodeGen(address, vectorLength);
        }

        @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadPointerVectorNode.class)
        private static final class ForeignPointers0Data
        extends Node {
            @Node.Child
            ForeignPointers0Data next_;
            @Node.Child
            LLVMManagedReadLibrary nativeRead_;

            ForeignPointers0Data(ForeignPointers0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadI64VectorNode.class)
    public static final class LLVMLoadI64VectorNodeGen
    extends LLVMLoadVectorNode.LLVMLoadI64VectorNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode address_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;
        @Node.Child
        private LLVMDerefHandleGetReceiverNode i64VectorDerefHandle_getReceiver_;
        @Node.Child
        private LLVMLoadVectorNode.LLVMLoadI64VectorNode i64VectorDerefHandle_load_;
        @Node.Child
        private I64VectorData i64Vector_cache;
        @Node.Child
        private LLVMLoadVectorNode.LLVMLoadPointerVectorNode pointerVector_load_;

        private LLVMLoadI64VectorNodeGen(LLVMExpressionNode address, int vectorLength) {
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public int getVectorLength() {
            return this.vectorLength;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ExplodeLoop
        public Object executeWithTarget(Object addressValue) {
            LLVMPointer addressValue_;
            int state = this.state_;
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__1;
                LLVMLanguage i64VectorDerefHandle_language__;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__;
                LLVMLanguage i64VectorNative_language__;
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state & 1) != 0 && !LLVMNode.isAutoDerefHandle(i64VectorNative_language__ = (LLVMLanguage)(lLVMLanguageReference__ = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue_)) {
                    return this.doI64VectorNative((LLVMNativePointer)addressValue_, i64VectorNative_language__);
                }
                if ((state & 2) != 0 && LLVMNode.isAutoDerefHandle(i64VectorDerefHandle_language__ = (LLVMLanguage)(lLVMLanguageReference__1 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue_)) {
                    return this.doI64VectorDerefHandle((LLVMNativePointer)addressValue_, this.i64VectorDerefHandle_getReceiver_, i64VectorDerefHandle_language__, this.i64VectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 4) != 0) {
                    I64VectorData s3_ = this.i64Vector_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue_.getObject())) {
                            try {
                                return this.doI64Vector((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                            }
                            catch (UnexpectedResultException ex) {
                                Lock lock = this.getLock();
                                lock.lock();
                                try {
                                    this.exclude_ |= 1;
                                    this.state_ &= 0xFFFFFFFB;
                                    this.i64Vector_cache = null;
                                }
                                finally {
                                    lock.unlock();
                                }
                                return ex.getResult();
                            }
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.doPointerVector((LLVMManagedPointer)addressValue_, this.pointerVector_load_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ExplodeLoop
        protected Object executeManaged(LLVMManagedPointer addressValue) {
            int state = this.state_;
            if ((state & 0xC) != 0) {
                if ((state & 4) != 0) {
                    I64VectorData s3_ = this.i64Vector_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue.getObject())) {
                            try {
                                return this.doI64Vector(addressValue, s3_.nativeRead_);
                            }
                            catch (UnexpectedResultException ex) {
                                Lock lock = this.getLock();
                                lock.lock();
                                try {
                                    this.exclude_ |= 1;
                                    this.state_ &= 0xFFFFFFFB;
                                    this.i64Vector_cache = null;
                                }
                                finally {
                                    lock.unlock();
                                }
                                return ex.getResult();
                            }
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.doPointerVector(addressValue, this.pointerVector_load_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ExplodeLoop
        public Object executeGeneric(VirtualFrame frameValue) {
            LLVMPointer addressValue__;
            int state = this.state_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__3;
                LLVMLanguage i64VectorDerefHandle_language__;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__2;
                LLVMLanguage i64VectorNative_language__;
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state & 1) != 0 && !LLVMNode.isAutoDerefHandle(i64VectorNative_language__ = (LLVMLanguage)(lLVMLanguageReference__2 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue__)) {
                    return this.doI64VectorNative((LLVMNativePointer)addressValue__, i64VectorNative_language__);
                }
                if ((state & 2) != 0 && LLVMNode.isAutoDerefHandle(i64VectorDerefHandle_language__ = (LLVMLanguage)(lLVMLanguageReference__3 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue__)) {
                    return this.doI64VectorDerefHandle((LLVMNativePointer)addressValue__, this.i64VectorDerefHandle_getReceiver_, i64VectorDerefHandle_language__, this.i64VectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state & 4) != 0) {
                    I64VectorData s3_ = this.i64Vector_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue__.getObject())) {
                            try {
                                return this.doI64Vector((LLVMManagedPointer)addressValue__, s3_.nativeRead_);
                            }
                            catch (UnexpectedResultException ex) {
                                Lock lock = this.getLock();
                                lock.lock();
                                try {
                                    this.exclude_ |= 1;
                                    this.state_ &= 0xFFFFFFFB;
                                    this.i64Vector_cache = null;
                                }
                                finally {
                                    lock.unlock();
                                }
                                return ex.getResult();
                            }
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.doPointerVector((LLVMManagedPointer)addressValue__, this.pointerVector_load_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private Object executeAndSpecialize(Object addressValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                LLVMPointer addressValue_;
                if (LLVMTypes.isNativePointer(addressValue)) {
                    addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    LLVMLanguage i64VectorNative_language__ = null;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__4 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__4 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__4 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (!LLVMNode.isAutoDerefHandle(i64VectorNative_language__ = (LLVMLanguage)lLVMLanguageReference__4.get(), (LLVMNativePointer)addressValue_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMI64Vector lLVMI64Vector = this.doI64VectorNative((LLVMNativePointer)addressValue_, i64VectorNative_language__);
                        return lLVMI64Vector;
                    }
                    LLVMLanguage i64VectorDerefHandle_language__ = null;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__5 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__5 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__5 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (LLVMNode.isAutoDerefHandle(i64VectorDerefHandle_language__ = (LLVMLanguage)lLVMLanguageReference__5.get(), (LLVMNativePointer)addressValue_)) {
                        this.i64VectorDerefHandle_getReceiver_ = (LLVMDerefHandleGetReceiverNode)super.insert((Node)LLVMDerefHandleGetReceiverNodeGen.create());
                        this.i64VectorDerefHandle_load_ = (LLVMLoadVectorNode.LLVMLoadI64VectorNode)super.insert((Node)this.createRecursive());
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        Object object = this.doI64VectorDerefHandle((LLVMNativePointer)addressValue_, this.i64VectorDerefHandle_getReceiver_, i64VectorDerefHandle_language__, this.i64VectorDerefHandle_load_);
                        return object;
                    }
                }
                if (LLVMTypes.isManagedPointer(addressValue)) {
                    addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if (exclude == 0) {
                        int count3_ = 0;
                        I64VectorData s3_ = this.i64Vector_cache;
                        if ((state & 4) != 0) {
                            while (s3_ != null && !s3_.nativeRead_.accepts(addressValue_.getObject())) {
                                s3_ = s3_.next_;
                                ++count3_;
                            }
                        }
                        if (s3_ == null && count3_ < 3) {
                            s3_ = (I64VectorData)super.insert((Node)new I64VectorData(this.i64Vector_cache));
                            s3_.nativeRead_ = (LLVMManagedReadLibrary)s3_.insertAccessor(L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject()));
                            this.i64Vector_cache = s3_;
                            this.state_ = state |= 4;
                        }
                        if (s3_ != null) {
                            try {
                                lock.unlock();
                                hasLock = false;
                                LLVMI64Vector lLVMI64Vector = this.doI64Vector((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                                return lLVMI64Vector;
                            }
                            catch (UnexpectedResultException ex) {
                                lock.lock();
                                try {
                                    this.exclude_ |= 1;
                                    this.state_ &= 0xFFFFFFFB;
                                    this.i64Vector_cache = null;
                                }
                                finally {
                                    lock.unlock();
                                }
                                Object object = ex.getResult();
                                if (hasLock) {
                                    lock.unlock();
                                }
                                return object;
                            }
                        }
                    }
                    this.pointerVector_load_ = (LLVMLoadVectorNode.LLVMLoadPointerVectorNode)super.insert((Node)LLVMLoadVectorNode.LLVMLoadPointerVectorNode.create(this.getVectorLength()));
                    this.exclude_ = exclude |= 1;
                    this.i64Vector_cache = null;
                    state &= 0xFFFFFFFB;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doPointerVector((LLVMManagedPointer)addressValue_, this.pointerVector_load_);
                    return object;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            I64VectorData s3_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s3_ = this.i64Vector_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMLoadVectorNode.LLVMLoadI64VectorNode create(LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadI64VectorNodeGen(address, vectorLength);
        }

        @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadI64VectorNode.class)
        private static final class I64VectorData
        extends Node {
            @Node.Child
            I64VectorData next_;
            @Node.Child
            LLVMManagedReadLibrary nativeRead_;

            I64VectorData(I64VectorData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadI32VectorNode.class)
    public static final class LLVMLoadI32VectorNodeGen
    extends LLVMLoadVectorNode.LLVMLoadI32VectorNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode address_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;
        @Node.Child
        private LLVMDerefHandleGetReceiverNode i32VectorDerefHandle_getReceiver_;
        @Node.Child
        private LLVMLoadVectorNode.LLVMLoadI32VectorNode i32VectorDerefHandle_load_;
        @Node.Child
        private Foreign0Data foreign0_cache;

        private LLVMLoadI32VectorNodeGen(LLVMExpressionNode address, int vectorLength) {
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        @ExplodeLoop
        public Object executeWithTarget(Object addressValue) {
            LLVMPointer addressValue_;
            int state = this.state_;
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__1;
                LLVMLanguage i32VectorDerefHandle_language__;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__;
                LLVMLanguage i32VectorNative_language__;
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state & 1) != 0 && !LLVMNode.isAutoDerefHandle(i32VectorNative_language__ = (LLVMLanguage)(lLVMLanguageReference__ = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue_)) {
                    return this.doI32VectorNative((LLVMNativePointer)addressValue_, i32VectorNative_language__);
                }
                if ((state & 2) != 0 && LLVMNode.isAutoDerefHandle(i32VectorDerefHandle_language__ = (LLVMLanguage)(lLVMLanguageReference__1 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue_)) {
                    return this.doI32VectorDerefHandle((LLVMNativePointer)addressValue_, this.i32VectorDerefHandle_getReceiver_, i32VectorDerefHandle_language__, this.i32VectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue_.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary(state, (LLVMManagedPointer)addressValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary(int state, LLVMManagedPointer addressValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject());
                LLVMI32Vector lLVMI32Vector = this.doForeign(addressValue_, foreign1_nativeRead__);
                return lLVMI32Vector;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        @ExplodeLoop
        protected LLVMI32Vector executeManaged(LLVMManagedPointer addressValue) {
            int state = this.state_;
            if ((state & 0xC) != 0) {
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue.getObject())) {
                            return this.doForeign(addressValue, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary0(state, addressValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private LLVMI32Vector foreign1Boundary0(int state, LLVMManagedPointer addressValue) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue.getObject());
                LLVMI32Vector lLVMI32Vector = this.doForeign(addressValue, foreign1_nativeRead__);
                return lLVMI32Vector;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        @ExplodeLoop
        public Object executeGeneric(VirtualFrame frameValue) {
            LLVMPointer addressValue__;
            int state = this.state_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__3;
                LLVMLanguage i32VectorDerefHandle_language__;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__2;
                LLVMLanguage i32VectorNative_language__;
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state & 1) != 0 && !LLVMNode.isAutoDerefHandle(i32VectorNative_language__ = (LLVMLanguage)(lLVMLanguageReference__2 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue__)) {
                    return this.doI32VectorNative((LLVMNativePointer)addressValue__, i32VectorNative_language__);
                }
                if ((state & 2) != 0 && LLVMNode.isAutoDerefHandle(i32VectorDerefHandle_language__ = (LLVMLanguage)(lLVMLanguageReference__3 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue__)) {
                    return this.doI32VectorDerefHandle((LLVMNativePointer)addressValue__, this.i32VectorDerefHandle_getReceiver_, i32VectorDerefHandle_language__, this.i32VectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue__.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue__, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary1(state, (LLVMManagedPointer)addressValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary1(int state, LLVMManagedPointer addressValue__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject());
                LLVMI32Vector lLVMI32Vector = this.doForeign(addressValue__, foreign1_nativeRead__);
                return lLVMI32Vector;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LLVMI32Vector executeAndSpecialize(Object addressValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                LLVMPointer addressValue_;
                if (LLVMTypes.isNativePointer(addressValue)) {
                    addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    LLVMLanguage i32VectorNative_language__ = null;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__4 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__4 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__4 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (!LLVMNode.isAutoDerefHandle(i32VectorNative_language__ = (LLVMLanguage)lLVMLanguageReference__4.get(), (LLVMNativePointer)addressValue_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMI32Vector lLVMI32Vector = this.doI32VectorNative((LLVMNativePointer)addressValue_, i32VectorNative_language__);
                        return lLVMI32Vector;
                    }
                    LLVMLanguage i32VectorDerefHandle_language__ = null;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__5 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__5 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__5 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (LLVMNode.isAutoDerefHandle(i32VectorDerefHandle_language__ = (LLVMLanguage)lLVMLanguageReference__5.get(), (LLVMNativePointer)addressValue_)) {
                        this.i32VectorDerefHandle_getReceiver_ = (LLVMDerefHandleGetReceiverNode)super.insert((Node)LLVMDerefHandleGetReceiverNodeGen.create());
                        this.i32VectorDerefHandle_load_ = (LLVMLoadVectorNode.LLVMLoadI32VectorNode)super.insert((Node)this.createRecursive());
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVMI32Vector lLVMI32Vector = this.doI32VectorDerefHandle((LLVMNativePointer)addressValue_, this.i32VectorDerefHandle_getReceiver_, i32VectorDerefHandle_language__, this.i32VectorDerefHandle_load_);
                        return lLVMI32Vector;
                    }
                }
                if (LLVMTypes.isManagedPointer(addressValue)) {
                    addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if (exclude == 0) {
                        int count3_ = 0;
                        Foreign0Data s3_ = this.foreign0_cache;
                        if ((state & 4) != 0) {
                            while (s3_ != null && !s3_.nativeRead_.accepts(addressValue_.getObject())) {
                                s3_ = s3_.next_;
                                ++count3_;
                            }
                        }
                        if (s3_ == null && count3_ < 3) {
                            s3_ = (Foreign0Data)super.insert((Node)new Foreign0Data(this.foreign0_cache));
                            s3_.nativeRead_ = (LLVMManagedReadLibrary)s3_.insertAccessor(L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject()));
                            this.foreign0_cache = s3_;
                            this.state_ = state |= 4;
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVMI32Vector lLVMI32Vector = this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                            return lLVMI32Vector;
                        }
                    }
                    LLVMManagedReadLibrary foreign1_nativeRead__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject());
                        this.exclude_ = exclude |= 1;
                        this.foreign0_cache = null;
                        state &= 0xFFFFFFFB;
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        LLVMI32Vector lLVMI32Vector = this.doForeign((LLVMManagedPointer)addressValue_, foreign1_nativeRead__);
                        return lLVMI32Vector;
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            Foreign0Data s3_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s3_ = this.foreign0_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMLoadVectorNode.LLVMLoadI32VectorNode create(LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadI32VectorNodeGen(address, vectorLength);
        }

        @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadI32VectorNode.class)
        private static final class Foreign0Data
        extends Node {
            @Node.Child
            Foreign0Data next_;
            @Node.Child
            LLVMManagedReadLibrary nativeRead_;

            Foreign0Data(Foreign0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadI16VectorNode.class)
    public static final class LLVMLoadI16VectorNodeGen
    extends LLVMLoadVectorNode.LLVMLoadI16VectorNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode address_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;
        @Node.Child
        private LLVMDerefHandleGetReceiverNode i16VectorDerefHandle_getReceiver_;
        @Node.Child
        private LLVMLoadVectorNode.LLVMLoadI16VectorNode i16VectorDerefHandle_load_;
        @Node.Child
        private Foreign0Data foreign0_cache;

        private LLVMLoadI16VectorNodeGen(LLVMExpressionNode address, int vectorLength) {
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        @ExplodeLoop
        public Object executeWithTarget(Object addressValue) {
            LLVMPointer addressValue_;
            int state = this.state_;
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__1;
                LLVMLanguage i16VectorDerefHandle_language__;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__;
                LLVMLanguage i16VectorNative_language__;
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state & 1) != 0 && !LLVMNode.isAutoDerefHandle(i16VectorNative_language__ = (LLVMLanguage)(lLVMLanguageReference__ = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue_)) {
                    return this.doI16VectorNative((LLVMNativePointer)addressValue_, i16VectorNative_language__);
                }
                if ((state & 2) != 0 && LLVMNode.isAutoDerefHandle(i16VectorDerefHandle_language__ = (LLVMLanguage)(lLVMLanguageReference__1 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue_)) {
                    return this.doI16VectorDerefHandle((LLVMNativePointer)addressValue_, this.i16VectorDerefHandle_getReceiver_, i16VectorDerefHandle_language__, this.i16VectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue_.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary(state, (LLVMManagedPointer)addressValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary(int state, LLVMManagedPointer addressValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject());
                LLVMI16Vector lLVMI16Vector = this.doForeign(addressValue_, foreign1_nativeRead__);
                return lLVMI16Vector;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        @ExplodeLoop
        protected LLVMI16Vector executeManaged(LLVMManagedPointer addressValue) {
            int state = this.state_;
            if ((state & 0xC) != 0) {
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue.getObject())) {
                            return this.doForeign(addressValue, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary0(state, addressValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private LLVMI16Vector foreign1Boundary0(int state, LLVMManagedPointer addressValue) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue.getObject());
                LLVMI16Vector lLVMI16Vector = this.doForeign(addressValue, foreign1_nativeRead__);
                return lLVMI16Vector;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        @ExplodeLoop
        public Object executeGeneric(VirtualFrame frameValue) {
            LLVMPointer addressValue__;
            int state = this.state_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__3;
                LLVMLanguage i16VectorDerefHandle_language__;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__2;
                LLVMLanguage i16VectorNative_language__;
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state & 1) != 0 && !LLVMNode.isAutoDerefHandle(i16VectorNative_language__ = (LLVMLanguage)(lLVMLanguageReference__2 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue__)) {
                    return this.doI16VectorNative((LLVMNativePointer)addressValue__, i16VectorNative_language__);
                }
                if ((state & 2) != 0 && LLVMNode.isAutoDerefHandle(i16VectorDerefHandle_language__ = (LLVMLanguage)(lLVMLanguageReference__3 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue__)) {
                    return this.doI16VectorDerefHandle((LLVMNativePointer)addressValue__, this.i16VectorDerefHandle_getReceiver_, i16VectorDerefHandle_language__, this.i16VectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue__.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue__, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary1(state, (LLVMManagedPointer)addressValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary1(int state, LLVMManagedPointer addressValue__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject());
                LLVMI16Vector lLVMI16Vector = this.doForeign(addressValue__, foreign1_nativeRead__);
                return lLVMI16Vector;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LLVMI16Vector executeAndSpecialize(Object addressValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                LLVMPointer addressValue_;
                if (LLVMTypes.isNativePointer(addressValue)) {
                    addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    LLVMLanguage i16VectorNative_language__ = null;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__4 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__4 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__4 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (!LLVMNode.isAutoDerefHandle(i16VectorNative_language__ = (LLVMLanguage)lLVMLanguageReference__4.get(), (LLVMNativePointer)addressValue_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMI16Vector lLVMI16Vector = this.doI16VectorNative((LLVMNativePointer)addressValue_, i16VectorNative_language__);
                        return lLVMI16Vector;
                    }
                    LLVMLanguage i16VectorDerefHandle_language__ = null;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__5 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__5 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__5 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (LLVMNode.isAutoDerefHandle(i16VectorDerefHandle_language__ = (LLVMLanguage)lLVMLanguageReference__5.get(), (LLVMNativePointer)addressValue_)) {
                        this.i16VectorDerefHandle_getReceiver_ = (LLVMDerefHandleGetReceiverNode)super.insert((Node)LLVMDerefHandleGetReceiverNodeGen.create());
                        this.i16VectorDerefHandle_load_ = (LLVMLoadVectorNode.LLVMLoadI16VectorNode)super.insert((Node)this.createRecursive());
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVMI16Vector lLVMI16Vector = this.doI16VectorDerefHandle((LLVMNativePointer)addressValue_, this.i16VectorDerefHandle_getReceiver_, i16VectorDerefHandle_language__, this.i16VectorDerefHandle_load_);
                        return lLVMI16Vector;
                    }
                }
                if (LLVMTypes.isManagedPointer(addressValue)) {
                    addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if (exclude == 0) {
                        int count3_ = 0;
                        Foreign0Data s3_ = this.foreign0_cache;
                        if ((state & 4) != 0) {
                            while (s3_ != null && !s3_.nativeRead_.accepts(addressValue_.getObject())) {
                                s3_ = s3_.next_;
                                ++count3_;
                            }
                        }
                        if (s3_ == null && count3_ < 3) {
                            s3_ = (Foreign0Data)super.insert((Node)new Foreign0Data(this.foreign0_cache));
                            s3_.nativeRead_ = (LLVMManagedReadLibrary)s3_.insertAccessor(L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject()));
                            this.foreign0_cache = s3_;
                            this.state_ = state |= 4;
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVMI16Vector lLVMI16Vector = this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                            return lLVMI16Vector;
                        }
                    }
                    LLVMManagedReadLibrary foreign1_nativeRead__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject());
                        this.exclude_ = exclude |= 1;
                        this.foreign0_cache = null;
                        state &= 0xFFFFFFFB;
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        LLVMI16Vector lLVMI16Vector = this.doForeign((LLVMManagedPointer)addressValue_, foreign1_nativeRead__);
                        return lLVMI16Vector;
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            Foreign0Data s3_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s3_ = this.foreign0_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMLoadVectorNode.LLVMLoadI16VectorNode create(LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadI16VectorNodeGen(address, vectorLength);
        }

        @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadI16VectorNode.class)
        private static final class Foreign0Data
        extends Node {
            @Node.Child
            Foreign0Data next_;
            @Node.Child
            LLVMManagedReadLibrary nativeRead_;

            Foreign0Data(Foreign0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadI8VectorNode.class)
    public static final class LLVMLoadI8VectorNodeGen
    extends LLVMLoadVectorNode.LLVMLoadI8VectorNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode address_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;
        @Node.Child
        private LLVMDerefHandleGetReceiverNode i8VectorDerefHandle_getReceiver_;
        @Node.Child
        private LLVMLoadVectorNode.LLVMLoadI8VectorNode i8VectorDerefHandle_load_;
        @Node.Child
        private Foreign0Data foreign0_cache;

        private LLVMLoadI8VectorNodeGen(LLVMExpressionNode address, int vectorLength) {
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        @ExplodeLoop
        public Object executeWithTarget(Object addressValue) {
            LLVMPointer addressValue_;
            int state = this.state_;
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__1;
                LLVMLanguage i8VectorDerefHandle_language__;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__;
                LLVMLanguage i8VectorNative_language__;
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state & 1) != 0 && !LLVMNode.isAutoDerefHandle(i8VectorNative_language__ = (LLVMLanguage)(lLVMLanguageReference__ = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue_)) {
                    return this.doI8VectorNative((LLVMNativePointer)addressValue_, i8VectorNative_language__);
                }
                if ((state & 2) != 0 && LLVMNode.isAutoDerefHandle(i8VectorDerefHandle_language__ = (LLVMLanguage)(lLVMLanguageReference__1 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue_)) {
                    return this.doI8VectorDerefHandle((LLVMNativePointer)addressValue_, this.i8VectorDerefHandle_getReceiver_, i8VectorDerefHandle_language__, this.i8VectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue_.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary(state, (LLVMManagedPointer)addressValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary(int state, LLVMManagedPointer addressValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject());
                LLVMI8Vector lLVMI8Vector = this.doForeign(addressValue_, foreign1_nativeRead__);
                return lLVMI8Vector;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        @ExplodeLoop
        protected LLVMI8Vector executeManaged(LLVMManagedPointer addressValue) {
            int state = this.state_;
            if ((state & 0xC) != 0) {
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue.getObject())) {
                            return this.doForeign(addressValue, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary0(state, addressValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private LLVMI8Vector foreign1Boundary0(int state, LLVMManagedPointer addressValue) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue.getObject());
                LLVMI8Vector lLVMI8Vector = this.doForeign(addressValue, foreign1_nativeRead__);
                return lLVMI8Vector;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        @ExplodeLoop
        public Object executeGeneric(VirtualFrame frameValue) {
            LLVMPointer addressValue__;
            int state = this.state_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__3;
                LLVMLanguage i8VectorDerefHandle_language__;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__2;
                LLVMLanguage i8VectorNative_language__;
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state & 1) != 0 && !LLVMNode.isAutoDerefHandle(i8VectorNative_language__ = (LLVMLanguage)(lLVMLanguageReference__2 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue__)) {
                    return this.doI8VectorNative((LLVMNativePointer)addressValue__, i8VectorNative_language__);
                }
                if ((state & 2) != 0 && LLVMNode.isAutoDerefHandle(i8VectorDerefHandle_language__ = (LLVMLanguage)(lLVMLanguageReference__3 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue__)) {
                    return this.doI8VectorDerefHandle((LLVMNativePointer)addressValue__, this.i8VectorDerefHandle_getReceiver_, i8VectorDerefHandle_language__, this.i8VectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue__.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue__, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary1(state, (LLVMManagedPointer)addressValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary1(int state, LLVMManagedPointer addressValue__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject());
                LLVMI8Vector lLVMI8Vector = this.doForeign(addressValue__, foreign1_nativeRead__);
                return lLVMI8Vector;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LLVMI8Vector executeAndSpecialize(Object addressValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                LLVMPointer addressValue_;
                if (LLVMTypes.isNativePointer(addressValue)) {
                    addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    LLVMLanguage i8VectorNative_language__ = null;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__4 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__4 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__4 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (!LLVMNode.isAutoDerefHandle(i8VectorNative_language__ = (LLVMLanguage)lLVMLanguageReference__4.get(), (LLVMNativePointer)addressValue_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMI8Vector lLVMI8Vector = this.doI8VectorNative((LLVMNativePointer)addressValue_, i8VectorNative_language__);
                        return lLVMI8Vector;
                    }
                    LLVMLanguage i8VectorDerefHandle_language__ = null;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__5 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__5 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__5 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (LLVMNode.isAutoDerefHandle(i8VectorDerefHandle_language__ = (LLVMLanguage)lLVMLanguageReference__5.get(), (LLVMNativePointer)addressValue_)) {
                        this.i8VectorDerefHandle_getReceiver_ = (LLVMDerefHandleGetReceiverNode)super.insert((Node)LLVMDerefHandleGetReceiverNodeGen.create());
                        this.i8VectorDerefHandle_load_ = (LLVMLoadVectorNode.LLVMLoadI8VectorNode)super.insert((Node)this.createRecursive());
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVMI8Vector lLVMI8Vector = this.doI8VectorDerefHandle((LLVMNativePointer)addressValue_, this.i8VectorDerefHandle_getReceiver_, i8VectorDerefHandle_language__, this.i8VectorDerefHandle_load_);
                        return lLVMI8Vector;
                    }
                }
                if (LLVMTypes.isManagedPointer(addressValue)) {
                    addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if (exclude == 0) {
                        int count3_ = 0;
                        Foreign0Data s3_ = this.foreign0_cache;
                        if ((state & 4) != 0) {
                            while (s3_ != null && !s3_.nativeRead_.accepts(addressValue_.getObject())) {
                                s3_ = s3_.next_;
                                ++count3_;
                            }
                        }
                        if (s3_ == null && count3_ < 3) {
                            s3_ = (Foreign0Data)super.insert((Node)new Foreign0Data(this.foreign0_cache));
                            s3_.nativeRead_ = (LLVMManagedReadLibrary)s3_.insertAccessor(L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject()));
                            this.foreign0_cache = s3_;
                            this.state_ = state |= 4;
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVMI8Vector lLVMI8Vector = this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                            return lLVMI8Vector;
                        }
                    }
                    LLVMManagedReadLibrary foreign1_nativeRead__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject());
                        this.exclude_ = exclude |= 1;
                        this.foreign0_cache = null;
                        state &= 0xFFFFFFFB;
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        LLVMI8Vector lLVMI8Vector = this.doForeign((LLVMManagedPointer)addressValue_, foreign1_nativeRead__);
                        return lLVMI8Vector;
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            Foreign0Data s3_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s3_ = this.foreign0_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMLoadVectorNode.LLVMLoadI8VectorNode create(LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadI8VectorNodeGen(address, vectorLength);
        }

        @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadI8VectorNode.class)
        private static final class Foreign0Data
        extends Node {
            @Node.Child
            Foreign0Data next_;
            @Node.Child
            LLVMManagedReadLibrary nativeRead_;

            Foreign0Data(Foreign0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadI1VectorNode.class)
    public static final class LLVMLoadI1VectorNodeGen
    extends LLVMLoadVectorNode.LLVMLoadI1VectorNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode address_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;
        @Node.Child
        private LLVMDerefHandleGetReceiverNode i1VectorDerefHandle_getReceiver_;
        @Node.Child
        private LLVMLoadVectorNode.LLVMLoadI1VectorNode i1VectorDerefHandle_load_;
        @Node.Child
        private Foreign0Data foreign0_cache;

        private LLVMLoadI1VectorNodeGen(LLVMExpressionNode address, int vectorLength) {
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        @ExplodeLoop
        public Object executeWithTarget(Object addressValue) {
            LLVMPointer addressValue_;
            int state = this.state_;
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__1;
                LLVMLanguage i1VectorDerefHandle_language__;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__;
                LLVMLanguage i1VectorNative_language__;
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state & 1) != 0 && !LLVMNode.isAutoDerefHandle(i1VectorNative_language__ = (LLVMLanguage)(lLVMLanguageReference__ = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue_)) {
                    return this.doI1VectorNative((LLVMNativePointer)addressValue_, i1VectorNative_language__);
                }
                if ((state & 2) != 0 && LLVMNode.isAutoDerefHandle(i1VectorDerefHandle_language__ = (LLVMLanguage)(lLVMLanguageReference__1 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue_)) {
                    return this.doI1VectorDerefHandle((LLVMNativePointer)addressValue_, this.i1VectorDerefHandle_getReceiver_, i1VectorDerefHandle_language__, this.i1VectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue_.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary(state, (LLVMManagedPointer)addressValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary(int state, LLVMManagedPointer addressValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject());
                LLVMI1Vector lLVMI1Vector = this.doForeign(addressValue_, foreign1_nativeRead__);
                return lLVMI1Vector;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        @ExplodeLoop
        protected LLVMI1Vector executeManaged(LLVMManagedPointer addressValue) {
            int state = this.state_;
            if ((state & 0xC) != 0) {
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue.getObject())) {
                            return this.doForeign(addressValue, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary0(state, addressValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private LLVMI1Vector foreign1Boundary0(int state, LLVMManagedPointer addressValue) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue.getObject());
                LLVMI1Vector lLVMI1Vector = this.doForeign(addressValue, foreign1_nativeRead__);
                return lLVMI1Vector;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        @ExplodeLoop
        public Object executeGeneric(VirtualFrame frameValue) {
            LLVMPointer addressValue__;
            int state = this.state_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__3;
                LLVMLanguage i1VectorDerefHandle_language__;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__2;
                LLVMLanguage i1VectorNative_language__;
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state & 1) != 0 && !LLVMNode.isAutoDerefHandle(i1VectorNative_language__ = (LLVMLanguage)(lLVMLanguageReference__2 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue__)) {
                    return this.doI1VectorNative((LLVMNativePointer)addressValue__, i1VectorNative_language__);
                }
                if ((state & 2) != 0 && LLVMNode.isAutoDerefHandle(i1VectorDerefHandle_language__ = (LLVMLanguage)(lLVMLanguageReference__3 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue__)) {
                    return this.doI1VectorDerefHandle((LLVMNativePointer)addressValue__, this.i1VectorDerefHandle_getReceiver_, i1VectorDerefHandle_language__, this.i1VectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue__.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue__, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary1(state, (LLVMManagedPointer)addressValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary1(int state, LLVMManagedPointer addressValue__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject());
                LLVMI1Vector lLVMI1Vector = this.doForeign(addressValue__, foreign1_nativeRead__);
                return lLVMI1Vector;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LLVMI1Vector executeAndSpecialize(Object addressValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                LLVMPointer addressValue_;
                if (LLVMTypes.isNativePointer(addressValue)) {
                    addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    LLVMLanguage i1VectorNative_language__ = null;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__4 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__4 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__4 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (!LLVMNode.isAutoDerefHandle(i1VectorNative_language__ = (LLVMLanguage)lLVMLanguageReference__4.get(), (LLVMNativePointer)addressValue_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMI1Vector lLVMI1Vector = this.doI1VectorNative((LLVMNativePointer)addressValue_, i1VectorNative_language__);
                        return lLVMI1Vector;
                    }
                    LLVMLanguage i1VectorDerefHandle_language__ = null;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__5 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__5 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__5 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (LLVMNode.isAutoDerefHandle(i1VectorDerefHandle_language__ = (LLVMLanguage)lLVMLanguageReference__5.get(), (LLVMNativePointer)addressValue_)) {
                        this.i1VectorDerefHandle_getReceiver_ = (LLVMDerefHandleGetReceiverNode)super.insert((Node)LLVMDerefHandleGetReceiverNodeGen.create());
                        this.i1VectorDerefHandle_load_ = (LLVMLoadVectorNode.LLVMLoadI1VectorNode)super.insert((Node)this.createRecursive());
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVMI1Vector lLVMI1Vector = this.doI1VectorDerefHandle((LLVMNativePointer)addressValue_, this.i1VectorDerefHandle_getReceiver_, i1VectorDerefHandle_language__, this.i1VectorDerefHandle_load_);
                        return lLVMI1Vector;
                    }
                }
                if (LLVMTypes.isManagedPointer(addressValue)) {
                    addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if (exclude == 0) {
                        int count3_ = 0;
                        Foreign0Data s3_ = this.foreign0_cache;
                        if ((state & 4) != 0) {
                            while (s3_ != null && !s3_.nativeRead_.accepts(addressValue_.getObject())) {
                                s3_ = s3_.next_;
                                ++count3_;
                            }
                        }
                        if (s3_ == null && count3_ < 3) {
                            s3_ = (Foreign0Data)super.insert((Node)new Foreign0Data(this.foreign0_cache));
                            s3_.nativeRead_ = (LLVMManagedReadLibrary)s3_.insertAccessor(L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject()));
                            this.foreign0_cache = s3_;
                            this.state_ = state |= 4;
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVMI1Vector lLVMI1Vector = this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                            return lLVMI1Vector;
                        }
                    }
                    LLVMManagedReadLibrary foreign1_nativeRead__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject());
                        this.exclude_ = exclude |= 1;
                        this.foreign0_cache = null;
                        state &= 0xFFFFFFFB;
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        LLVMI1Vector lLVMI1Vector = this.doForeign((LLVMManagedPointer)addressValue_, foreign1_nativeRead__);
                        return lLVMI1Vector;
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            Foreign0Data s3_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s3_ = this.foreign0_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMLoadVectorNode.LLVMLoadI1VectorNode create(LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadI1VectorNodeGen(address, vectorLength);
        }

        @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadI1VectorNode.class)
        private static final class Foreign0Data
        extends Node {
            @Node.Child
            Foreign0Data next_;
            @Node.Child
            LLVMManagedReadLibrary nativeRead_;

            Foreign0Data(Foreign0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }
}

