/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDirectLoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMDirectLoadNode.class)
public final class LLVMDirectLoadNodeFactory {
    private static final LibraryFactory<LLVMManagedReadLibrary> L_L_V_M_MANAGED_READ_LIBRARY_ = LibraryFactory.resolve(LLVMManagedReadLibrary.class);

    @GeneratedBy(value=LLVMDirectLoadNode.LLVMStructDirectLoadNode.class)
    public static final class LLVMStructDirectLoadNodeGen
    extends LLVMDirectLoadNode.LLVMStructDirectLoadNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode address_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMStructDirectLoadNodeGen(LLVMExpressionNode address) {
            this.address_ = address;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeWithTarget(Object addressValue) {
            int state = this.state_;
            if (state != 0 && LLVMTypes.isPointer(addressValue)) {
                LLVMPointer addressValue_ = LLVMTypes.asPointer(addressValue);
                return this.doPointer(addressValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if (state != 0 && LLVMTypes.isPointer(addressValue_)) {
                LLVMPointer addressValue__ = LLVMTypes.asPointer(addressValue_);
                return this.doPointer(addressValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue_);
        }

        private LLVMPointer executeAndSpecialize(Object addressValue) {
            int state = this.state_;
            if (LLVMTypes.isPointer(addressValue)) {
                LLVMPointer addressValue_ = LLVMTypes.asPointer(addressValue);
                this.state_ = state |= 1;
                return this.doPointer(addressValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMDirectLoadNode.LLVMStructDirectLoadNode create(LLVMExpressionNode address) {
            return new LLVMStructDirectLoadNodeGen(address);
        }
    }

    @GeneratedBy(value=LLVMDirectLoadNode.LLVMPointerDirectLoadNode.class)
    public static final class LLVMPointerDirectLoadNodeGen
    extends LLVMDirectLoadNode.LLVMPointerDirectLoadNode {
        private static final Uncached UNCACHED = new Uncached();
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode address_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;
        @Node.Child
        private LLVMDerefHandleGetReceiverNode derefHandle_getReceiver_;
        @Node.Child
        private LLVMManagedReadLibrary derefHandle_nativeRead_;
        @Node.Child
        private IndirectedForeign0Data indirectedForeign0_cache;

        private LLVMPointerDirectLoadNodeGen(LLVMExpressionNode address) {
            this.address_ = address;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        @ExplodeLoop
        public Object executeWithTarget(Object addressValue) {
            LLVMPointer addressValue_;
            int state = this.state_;
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__1;
                LLVMLanguage derefHandle_language__;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__;
                LLVMLanguage nativePointer_language__;
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state & 1) != 0 && !LLVMNode.isAutoDerefHandle(nativePointer_language__ = (LLVMLanguage)(lLVMLanguageReference__ = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue_)) {
                    return this.doNativePointer((LLVMNativePointer)addressValue_, nativePointer_language__);
                }
                if ((state & 2) != 0 && LLVMNode.isAutoDerefHandle(derefHandle_language__ = (LLVMLanguage)(lLVMLanguageReference__1 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue_)) {
                    return this.doDerefHandle((LLVMNativePointer)addressValue_, this.derefHandle_getReceiver_, derefHandle_language__, this.derefHandle_nativeRead_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 4) != 0) {
                    IndirectedForeign0Data s3_ = this.indirectedForeign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue_.getObject())) {
                            return this.doIndirectedForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.indirectedForeign1Boundary(state, (LLVMManagedPointer)addressValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object indirectedForeign1Boundary(int state, LLVMManagedPointer addressValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary indirectedForeign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject());
                LLVMPointer lLVMPointer = this.doIndirectedForeign(addressValue_, indirectedForeign1_nativeRead__);
                return lLVMPointer;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        @ExplodeLoop
        public Object executeGeneric(VirtualFrame frameValue) {
            LLVMPointer addressValue__;
            int state = this.state_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__3;
                LLVMLanguage derefHandle_language__;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__2;
                LLVMLanguage nativePointer_language__;
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state & 1) != 0 && !LLVMNode.isAutoDerefHandle(nativePointer_language__ = (LLVMLanguage)(lLVMLanguageReference__2 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue__)) {
                    return this.doNativePointer((LLVMNativePointer)addressValue__, nativePointer_language__);
                }
                if ((state & 2) != 0 && LLVMNode.isAutoDerefHandle(derefHandle_language__ = (LLVMLanguage)(lLVMLanguageReference__3 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue__)) {
                    return this.doDerefHandle((LLVMNativePointer)addressValue__, this.derefHandle_getReceiver_, derefHandle_language__, this.derefHandle_nativeRead_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state & 4) != 0) {
                    IndirectedForeign0Data s3_ = this.indirectedForeign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue__.getObject())) {
                            return this.doIndirectedForeign((LLVMManagedPointer)addressValue__, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.indirectedForeign1Boundary0(state, (LLVMManagedPointer)addressValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object indirectedForeign1Boundary0(int state, LLVMManagedPointer addressValue__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary indirectedForeign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject());
                LLVMPointer lLVMPointer = this.doIndirectedForeign(addressValue__, indirectedForeign1_nativeRead__);
                return lLVMPointer;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LLVMPointer executeAndSpecialize(Object addressValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                LLVMPointer addressValue_;
                if (LLVMTypes.isNativePointer(addressValue)) {
                    addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    LLVMLanguage nativePointer_language__ = null;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__4 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__4 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__4 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (!LLVMNode.isAutoDerefHandle(nativePointer_language__ = (LLVMLanguage)lLVMLanguageReference__4.get(), (LLVMNativePointer)addressValue_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMNativePointer lLVMNativePointer = this.doNativePointer((LLVMNativePointer)addressValue_, nativePointer_language__);
                        return lLVMNativePointer;
                    }
                    LLVMLanguage derefHandle_language__ = null;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__5 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__5 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__5 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (LLVMNode.isAutoDerefHandle(derefHandle_language__ = (LLVMLanguage)lLVMLanguageReference__5.get(), (LLVMNativePointer)addressValue_)) {
                        this.derefHandle_getReceiver_ = (LLVMDerefHandleGetReceiverNode)super.insert((Node)LLVMDerefHandleGetReceiverNodeGen.create());
                        this.derefHandle_nativeRead_ = (LLVMManagedReadLibrary)super.insert((Node)L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3));
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVMPointer lLVMPointer = this.doDerefHandle((LLVMNativePointer)addressValue_, this.derefHandle_getReceiver_, derefHandle_language__, this.derefHandle_nativeRead_);
                        return lLVMPointer;
                    }
                }
                if (LLVMTypes.isManagedPointer(addressValue)) {
                    addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if (exclude == 0) {
                        int count3_ = 0;
                        IndirectedForeign0Data s3_ = this.indirectedForeign0_cache;
                        if ((state & 4) != 0) {
                            while (s3_ != null && !s3_.nativeRead_.accepts(addressValue_.getObject())) {
                                s3_ = s3_.next_;
                                ++count3_;
                            }
                        }
                        if (s3_ == null && count3_ < 3) {
                            s3_ = (IndirectedForeign0Data)super.insert((Node)new IndirectedForeign0Data(this.indirectedForeign0_cache));
                            s3_.nativeRead_ = (LLVMManagedReadLibrary)s3_.insertAccessor(L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject()));
                            this.indirectedForeign0_cache = s3_;
                            this.state_ = state |= 4;
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVMPointer lLVMPointer = this.doIndirectedForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                            return lLVMPointer;
                        }
                    }
                    LLVMManagedReadLibrary indirectedForeign1_nativeRead__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        indirectedForeign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject());
                        this.exclude_ = exclude |= 1;
                        this.indirectedForeign0_cache = null;
                        state &= 0xFFFFFFFB;
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        LLVMPointer lLVMPointer = this.doIndirectedForeign((LLVMManagedPointer)addressValue_, indirectedForeign1_nativeRead__);
                        return lLVMPointer;
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            IndirectedForeign0Data s3_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s3_ = this.indirectedForeign0_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMDirectLoadNode.LLVMPointerDirectLoadNode create(LLVMExpressionNode address) {
            return new LLVMPointerDirectLoadNodeGen(address);
        }

        public static LLVMDirectLoadNode.LLVMPointerDirectLoadNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMDirectLoadNode.LLVMPointerDirectLoadNode.class)
        private static final class Uncached
        extends LLVMDirectLoadNode.LLVMPointerDirectLoadNode {
            private final TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_ = this.lookupLanguageReference(LLVMLanguage.class);

            private Uncached() {
            }

            @Override
            public LLVMSourceLocation getSourceLocation() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setSourceLocation(LLVMSourceLocation sourceLocation) {
                throw new UnsupportedOperationException();
            }

            @Override
            protected boolean isStatement() {
                throw new UnsupportedOperationException();
            }

            @Override
            protected void setStatement(boolean statementTag) {
                throw new UnsupportedOperationException();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object executeWithTarget(Object addressValue) {
                LLVMPointer addressValue_;
                if (LLVMTypes.isNativePointer(addressValue)) {
                    addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    if (!LLVMNode.isAutoDerefHandle((LLVMLanguage)this.lLVMLanguageReference_.get(), (LLVMNativePointer)addressValue_)) {
                        return this.doNativePointer((LLVMNativePointer)addressValue_, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    }
                    if (LLVMNode.isAutoDerefHandle((LLVMLanguage)this.lLVMLanguageReference_.get(), (LLVMNativePointer)addressValue_)) {
                        return this.doDerefHandle((LLVMNativePointer)addressValue_, LLVMDerefHandleGetReceiverNodeGen.getUncached(), (LLVMLanguage)this.lLVMLanguageReference_.get(), (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached());
                    }
                }
                if (LLVMTypes.isManagedPointer(addressValue)) {
                    addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    return this.doIndirectedForeign((LLVMManagedPointer)addressValue_, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{addressValue});
            }

            @Override
            public Object executeGeneric(VirtualFrame frameValue) {
                throw CompilerDirectives.shouldNotReachHere((String)"This execute method cannot be used for uncached node versions as it requires child nodes to be present. Use an execute method that takes all arguments as parameters.");
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=LLVMDirectLoadNode.LLVMPointerDirectLoadNode.class)
        private static final class IndirectedForeign0Data
        extends Node {
            @Node.Child
            IndirectedForeign0Data next_;
            @Node.Child
            LLVMManagedReadLibrary nativeRead_;

            IndirectedForeign0Data(IndirectedForeign0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMDirectLoadNode.LLVM80BitFloatDirectLoadNode.class)
    public static final class LLVM80BitFloatDirectLoadNodeGen
    extends LLVMDirectLoadNode.LLVM80BitFloatDirectLoadNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode address_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;
        @Node.Child
        private LLVMDerefHandleGetReceiverNode do80BitFloatDerefHandle_getReceiver_;
        @Node.Child
        private LLVMDirectLoadNode.LLVM80BitFloatDirectLoadNode do80BitFloatDerefHandle_load_;
        @Node.Child
        private Foreign0Data foreign0_cache;

        private LLVM80BitFloatDirectLoadNodeGen(LLVMExpressionNode address) {
            this.address_ = address;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        @ExplodeLoop
        public Object executeWithTarget(Object addressValue) {
            LLVMPointer addressValue_;
            int state = this.state_;
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__1;
                LLVMLanguage do80BitFloatDerefHandle_language__;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__;
                LLVMLanguage do80BitFloatNative_language__;
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state & 1) != 0 && !LLVMNode.isAutoDerefHandle(do80BitFloatNative_language__ = (LLVMLanguage)(lLVMLanguageReference__ = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue_)) {
                    return this.do80BitFloatNative((LLVMNativePointer)addressValue_, do80BitFloatNative_language__);
                }
                if ((state & 2) != 0 && LLVMNode.isAutoDerefHandle(do80BitFloatDerefHandle_language__ = (LLVMLanguage)(lLVMLanguageReference__1 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue_)) {
                    return this.do80BitFloatDerefHandle((LLVMNativePointer)addressValue_, this.do80BitFloatDerefHandle_getReceiver_, do80BitFloatDerefHandle_language__, this.do80BitFloatDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue_.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary(state, (LLVMManagedPointer)addressValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary(int state, LLVMManagedPointer addressValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject());
                LLVM80BitFloat lLVM80BitFloat = this.doForeign(addressValue_, foreign1_nativeRead__);
                return lLVM80BitFloat;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        @ExplodeLoop
        protected LLVM80BitFloat executeManaged(LLVMManagedPointer addressValue) {
            int state = this.state_;
            if ((state & 0xC) != 0) {
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue.getObject())) {
                            return this.doForeign(addressValue, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary0(state, addressValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private LLVM80BitFloat foreign1Boundary0(int state, LLVMManagedPointer addressValue) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue.getObject());
                LLVM80BitFloat lLVM80BitFloat = this.doForeign(addressValue, foreign1_nativeRead__);
                return lLVM80BitFloat;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        @ExplodeLoop
        public Object executeGeneric(VirtualFrame frameValue) {
            LLVMPointer addressValue__;
            int state = this.state_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__3;
                LLVMLanguage do80BitFloatDerefHandle_language__;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__2;
                LLVMLanguage do80BitFloatNative_language__;
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state & 1) != 0 && !LLVMNode.isAutoDerefHandle(do80BitFloatNative_language__ = (LLVMLanguage)(lLVMLanguageReference__2 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue__)) {
                    return this.do80BitFloatNative((LLVMNativePointer)addressValue__, do80BitFloatNative_language__);
                }
                if ((state & 2) != 0 && LLVMNode.isAutoDerefHandle(do80BitFloatDerefHandle_language__ = (LLVMLanguage)(lLVMLanguageReference__3 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue__)) {
                    return this.do80BitFloatDerefHandle((LLVMNativePointer)addressValue__, this.do80BitFloatDerefHandle_getReceiver_, do80BitFloatDerefHandle_language__, this.do80BitFloatDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue__.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue__, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary1(state, (LLVMManagedPointer)addressValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary1(int state, LLVMManagedPointer addressValue__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject());
                LLVM80BitFloat lLVM80BitFloat = this.doForeign(addressValue__, foreign1_nativeRead__);
                return lLVM80BitFloat;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LLVM80BitFloat executeAndSpecialize(Object addressValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                LLVMPointer addressValue_;
                if (LLVMTypes.isNativePointer(addressValue)) {
                    addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    LLVMLanguage do80BitFloatNative_language__ = null;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__4 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__4 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__4 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (!LLVMNode.isAutoDerefHandle(do80BitFloatNative_language__ = (LLVMLanguage)lLVMLanguageReference__4.get(), (LLVMNativePointer)addressValue_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVM80BitFloat lLVM80BitFloat = this.do80BitFloatNative((LLVMNativePointer)addressValue_, do80BitFloatNative_language__);
                        return lLVM80BitFloat;
                    }
                    LLVMLanguage do80BitFloatDerefHandle_language__ = null;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__5 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__5 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__5 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (LLVMNode.isAutoDerefHandle(do80BitFloatDerefHandle_language__ = (LLVMLanguage)lLVMLanguageReference__5.get(), (LLVMNativePointer)addressValue_)) {
                        this.do80BitFloatDerefHandle_getReceiver_ = (LLVMDerefHandleGetReceiverNode)super.insert((Node)LLVMDerefHandleGetReceiverNodeGen.create());
                        this.do80BitFloatDerefHandle_load_ = (LLVMDirectLoadNode.LLVM80BitFloatDirectLoadNode)super.insert((Node)LLVMDirectLoadNode.LLVM80BitFloatDirectLoadNode.create());
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVM80BitFloat lLVM80BitFloat = this.do80BitFloatDerefHandle((LLVMNativePointer)addressValue_, this.do80BitFloatDerefHandle_getReceiver_, do80BitFloatDerefHandle_language__, this.do80BitFloatDerefHandle_load_);
                        return lLVM80BitFloat;
                    }
                }
                if (LLVMTypes.isManagedPointer(addressValue)) {
                    addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if (exclude == 0) {
                        int count3_ = 0;
                        Foreign0Data s3_ = this.foreign0_cache;
                        if ((state & 4) != 0) {
                            while (s3_ != null && !s3_.nativeRead_.accepts(addressValue_.getObject())) {
                                s3_ = s3_.next_;
                                ++count3_;
                            }
                        }
                        if (s3_ == null && count3_ < 3) {
                            s3_ = (Foreign0Data)super.insert((Node)new Foreign0Data(this.foreign0_cache));
                            s3_.nativeRead_ = (LLVMManagedReadLibrary)s3_.insertAccessor(L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject()));
                            this.foreign0_cache = s3_;
                            this.state_ = state |= 4;
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVM80BitFloat lLVM80BitFloat = this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                            return lLVM80BitFloat;
                        }
                    }
                    LLVMManagedReadLibrary foreign1_nativeRead__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject());
                        this.exclude_ = exclude |= 1;
                        this.foreign0_cache = null;
                        state &= 0xFFFFFFFB;
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        LLVM80BitFloat lLVM80BitFloat = this.doForeign((LLVMManagedPointer)addressValue_, foreign1_nativeRead__);
                        return lLVM80BitFloat;
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            Foreign0Data s3_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s3_ = this.foreign0_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMDirectLoadNode.LLVM80BitFloatDirectLoadNode create(LLVMExpressionNode address) {
            return new LLVM80BitFloatDirectLoadNodeGen(address);
        }

        @GeneratedBy(value=LLVMDirectLoadNode.LLVM80BitFloatDirectLoadNode.class)
        private static final class Foreign0Data
        extends Node {
            @Node.Child
            Foreign0Data next_;
            @Node.Child
            LLVMManagedReadLibrary nativeRead_;

            Foreign0Data(Foreign0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMDirectLoadNode.LLVMIVarBitDirectLoadNode.class)
    public static final class LLVMIVarBitDirectLoadNodeGen
    extends LLVMDirectLoadNode.LLVMIVarBitDirectLoadNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int bitWidth;
        @Node.Child
        private LLVMExpressionNode address_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;
        @Node.Child
        private LLVMDerefHandleGetReceiverNode iVarBitDerefHandle_getReceiver_;
        @Node.Child
        private LLVMDirectLoadNode.LLVMIVarBitDirectLoadNode iVarBitDerefHandle_load_;
        @Node.Child
        private Foreign0Data foreign0_cache;

        private LLVMIVarBitDirectLoadNodeGen(LLVMExpressionNode address, int bitWidth) {
            this.bitWidth = bitWidth;
            this.address_ = address;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public int getBitWidth() {
            return this.bitWidth;
        }

        @Override
        @ExplodeLoop
        public Object executeWithTarget(Object addressValue) {
            LLVMPointer addressValue_;
            int state = this.state_;
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__1;
                LLVMLanguage iVarBitDerefHandle_language__;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__;
                LLVMLanguage iVarBitNative_language__;
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state & 1) != 0 && !LLVMNode.isAutoDerefHandle(iVarBitNative_language__ = (LLVMLanguage)(lLVMLanguageReference__ = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue_)) {
                    return this.doIVarBitNative((LLVMNativePointer)addressValue_, iVarBitNative_language__);
                }
                if ((state & 2) != 0 && LLVMNode.isAutoDerefHandle(iVarBitDerefHandle_language__ = (LLVMLanguage)(lLVMLanguageReference__1 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue_)) {
                    return this.doIVarBitDerefHandle((LLVMNativePointer)addressValue_, this.iVarBitDerefHandle_getReceiver_, iVarBitDerefHandle_language__, this.iVarBitDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue_.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary(state, (LLVMManagedPointer)addressValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary(int state, LLVMManagedPointer addressValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject());
                LLVMIVarBit lLVMIVarBit = this.doForeign(addressValue_, foreign1_nativeRead__);
                return lLVMIVarBit;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        @ExplodeLoop
        protected LLVMIVarBit executeManaged(LLVMManagedPointer addressValue) {
            int state = this.state_;
            if ((state & 0xC) != 0) {
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue.getObject())) {
                            return this.doForeign(addressValue, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary0(state, addressValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private LLVMIVarBit foreign1Boundary0(int state, LLVMManagedPointer addressValue) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue.getObject());
                LLVMIVarBit lLVMIVarBit = this.doForeign(addressValue, foreign1_nativeRead__);
                return lLVMIVarBit;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        @ExplodeLoop
        public Object executeGeneric(VirtualFrame frameValue) {
            LLVMPointer addressValue__;
            int state = this.state_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__3;
                LLVMLanguage iVarBitDerefHandle_language__;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__2;
                LLVMLanguage iVarBitNative_language__;
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state & 1) != 0 && !LLVMNode.isAutoDerefHandle(iVarBitNative_language__ = (LLVMLanguage)(lLVMLanguageReference__2 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue__)) {
                    return this.doIVarBitNative((LLVMNativePointer)addressValue__, iVarBitNative_language__);
                }
                if ((state & 2) != 0 && LLVMNode.isAutoDerefHandle(iVarBitDerefHandle_language__ = (LLVMLanguage)(lLVMLanguageReference__3 = this.lLVMLanguageReference_).get(), (LLVMNativePointer)addressValue__)) {
                    return this.doIVarBitDerefHandle((LLVMNativePointer)addressValue__, this.iVarBitDerefHandle_getReceiver_, iVarBitDerefHandle_language__, this.iVarBitDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue__.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue__, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary1(state, (LLVMManagedPointer)addressValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary1(int state, LLVMManagedPointer addressValue__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMManagedReadLibrary foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject());
                LLVMIVarBit lLVMIVarBit = this.doForeign(addressValue__, foreign1_nativeRead__);
                return lLVMIVarBit;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LLVMIVarBit executeAndSpecialize(Object addressValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                LLVMPointer addressValue_;
                if (LLVMTypes.isNativePointer(addressValue)) {
                    addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    LLVMLanguage iVarBitNative_language__ = null;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__4 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__4 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__4 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (!LLVMNode.isAutoDerefHandle(iVarBitNative_language__ = (LLVMLanguage)lLVMLanguageReference__4.get(), (LLVMNativePointer)addressValue_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMIVarBit lLVMIVarBit = this.doIVarBitNative((LLVMNativePointer)addressValue_, iVarBitNative_language__);
                        return lLVMIVarBit;
                    }
                    LLVMLanguage iVarBitDerefHandle_language__ = null;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__5 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__5 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__5 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (LLVMNode.isAutoDerefHandle(iVarBitDerefHandle_language__ = (LLVMLanguage)lLVMLanguageReference__5.get(), (LLVMNativePointer)addressValue_)) {
                        this.iVarBitDerefHandle_getReceiver_ = (LLVMDerefHandleGetReceiverNode)super.insert((Node)LLVMDerefHandleGetReceiverNodeGen.create());
                        this.iVarBitDerefHandle_load_ = (LLVMDirectLoadNode.LLVMIVarBitDirectLoadNode)super.insert((Node)this.createRecursive());
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVMIVarBit lLVMIVarBit = this.doIVarBitDerefHandle((LLVMNativePointer)addressValue_, this.iVarBitDerefHandle_getReceiver_, iVarBitDerefHandle_language__, this.iVarBitDerefHandle_load_);
                        return lLVMIVarBit;
                    }
                }
                if (LLVMTypes.isManagedPointer(addressValue)) {
                    addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if (exclude == 0) {
                        int count3_ = 0;
                        Foreign0Data s3_ = this.foreign0_cache;
                        if ((state & 4) != 0) {
                            while (s3_ != null && !s3_.nativeRead_.accepts(addressValue_.getObject())) {
                                s3_ = s3_.next_;
                                ++count3_;
                            }
                        }
                        if (s3_ == null && count3_ < 3) {
                            s3_ = (Foreign0Data)super.insert((Node)new Foreign0Data(this.foreign0_cache));
                            s3_.nativeRead_ = (LLVMManagedReadLibrary)s3_.insertAccessor(L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject()));
                            this.foreign0_cache = s3_;
                            this.state_ = state |= 4;
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVMIVarBit lLVMIVarBit = this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                            return lLVMIVarBit;
                        }
                    }
                    LLVMManagedReadLibrary foreign1_nativeRead__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        foreign1_nativeRead__ = (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject());
                        this.exclude_ = exclude |= 1;
                        this.foreign0_cache = null;
                        state &= 0xFFFFFFFB;
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        LLVMIVarBit lLVMIVarBit = this.doForeign((LLVMManagedPointer)addressValue_, foreign1_nativeRead__);
                        return lLVMIVarBit;
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            Foreign0Data s3_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s3_ = this.foreign0_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMDirectLoadNode.LLVMIVarBitDirectLoadNode create(LLVMExpressionNode address, int bitWidth) {
            return new LLVMIVarBitDirectLoadNodeGen(address, bitWidth);
        }

        @GeneratedBy(value=LLVMDirectLoadNode.LLVMIVarBitDirectLoadNode.class)
        private static final class Foreign0Data
        extends Node {
            @Node.Child
            Foreign0Data next_;
            @Node.Child
            LLVMManagedReadLibrary nativeRead_;

            Foreign0Data(Foreign0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }
}

