/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.except.LLVMAllocationFailureException;
import com.oracle.truffle.llvm.runtime.except.LLVMStackOverflowError;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.types.Type;

public abstract class LLVMGetStackSpaceInstruction
extends LLVMExpressionNode {
    protected final long size;
    protected final int alignment;
    protected final Type symbolType;
    @CompilerDirectives.CompilationFinal
    private FrameSlot stackPointer;

    public LLVMGetStackSpaceInstruction(long size, int alignment, Type symbolType) {
        this.size = size;
        this.alignment = alignment;
        this.symbolType = symbolType;
    }

    @Override
    public String toString() {
        return this.getShortString("size", "alignment", "symbolType");
    }

    protected FrameSlot getStackPointerSlot() {
        if (this.stackPointer == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.stackPointer = this.getRootNode().getFrameDescriptor().findFrameSlot((Object)"<stackpointer>");
        }
        return this.stackPointer;
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMAllocaInstruction
    extends LLVMGetStackSpaceInstruction {
        public LLVMAllocaInstruction(long size, int alignment, Type symbolType) {
            super(size, alignment, symbolType);
        }

        @Specialization
        protected LLVMNativePointer doOp(VirtualFrame frame, int nr, @CachedLanguage LLVMLanguage language) {
            try {
                return LLVMNativePointer.create(LLVMStack.allocateStackMemory(this, frame, language.getLLVMMemory(), this.getStackPointerSlot(), this.size * (long)nr, this.alignment));
            }
            catch (LLVMStackOverflowError soe) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMAllocationFailureException((Node)this, soe);
            }
        }

        @Specialization
        protected LLVMNativePointer doOp(VirtualFrame frame, long nr, @CachedLanguage LLVMLanguage language) {
            try {
                return LLVMNativePointer.create(LLVMStack.allocateStackMemory(this, frame, language.getLLVMMemory(), this.getStackPointerSlot(), this.size * nr, this.alignment));
            }
            catch (LLVMStackOverflowError soe) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMAllocationFailureException((Node)this, soe);
            }
        }
    }

    public static abstract class LLVMGetUniqueStackSpaceInstruction
    extends LLVMGetStackForConstInstruction {
        private final LLVMStack.UniquesRegion.UniqueSlot uniqueSlot;

        public LLVMGetUniqueStackSpaceInstruction(long size, int alignment, Type symbolType, LLVMStack.UniquesRegion.UniqueSlot uniqueSlot) {
            super(size, alignment, symbolType);
            this.uniqueSlot = uniqueSlot;
        }

        @Override
        public String toString() {
            return this.getShortString("size", "alignment", "symbolType", "uniqueSlot");
        }

        @Specialization
        protected LLVMNativePointer doOp(VirtualFrame frame) {
            return LLVMNativePointer.create(this.uniqueSlot.toPointer(frame, this.getStackPointerSlot()));
        }
    }

    public static abstract class LLVMAllocaConstInstruction
    extends LLVMGetStackForConstInstruction {
        public LLVMAllocaConstInstruction(long size, int alignment, Type symbolType) {
            super(size, alignment, symbolType);
        }

        @Specialization
        protected LLVMNativePointer doOp(VirtualFrame frame, @CachedLanguage LLVMLanguage language) {
            try {
                return LLVMNativePointer.create(LLVMStack.allocateStackMemory(this, frame, language.getLLVMMemory(), this.getStackPointerSlot(), this.size, this.alignment));
            }
            catch (LLVMStackOverflowError soe) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMAllocationFailureException((Node)this, soe);
            }
        }
    }

    public static abstract class LLVMGetStackForConstInstruction
    extends LLVMGetStackSpaceInstruction {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private Type[] types = null;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private long[] offsets = null;

        public LLVMGetStackForConstInstruction(long size, int alignment, Type symbolType) {
            super(size, alignment, symbolType);
        }

        public void setTypes(Type[] types) {
            this.types = types;
        }

        public void setOffsets(long[] offsets) {
            this.offsets = offsets;
        }

        public Type[] getTypes() {
            return this.types;
        }

        public long[] getOffsets() {
            return this.offsets;
        }

        public int getLength() {
            return this.offsets.length;
        }
    }
}

