/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMGetElementPtrNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.Type;

@GeneratedBy(value=LLVMGetElementPtrNode.class)
public final class LLVMGetElementPtrNodeGen
extends LLVMGetElementPtrNode {
    private LLVMSourceLocation sourceLocation;
    private boolean statement;
    @Node.Child
    private LLVMExpressionNode child0_;
    @Node.Child
    private LLVMExpressionNode child1_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private LLVMGetElementPtrNodeGen(long typeWidth, Type targetType, LLVMExpressionNode child0, LLVMExpressionNode child1) {
        super(typeWidth, targetType);
        this.child0_ = child0;
        this.child1_ = child1;
    }

    @Override
    public LLVMSourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    protected boolean isStatement() {
        return this.statement;
    }

    @Override
    protected void setStatement(boolean statement) {
        this.statement = statement;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 0x1B) == 0 && state != 0) {
            return this.executeGeneric_int0(frameValue, state);
        }
        if ((state & 0x17) == 0 && state != 0) {
            return this.executeGeneric_long1(frameValue, state);
        }
        return this.executeGeneric_generic2(frameValue, state);
    }

    private Object executeGeneric_int0(VirtualFrame frameValue, int state) {
        int child1Value_;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        try {
            child1Value_ = this.child1_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(child0Value_, ex.getResult());
        }
        assert ((state & 4) != 0);
        if (LLVMTypes.isPointer(child0Value_)) {
            LLVMPointer child0Value__ = LLVMTypes.asPointer(child0Value_);
            return this.doInt(child0Value__, child1Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(child0Value_, child1Value_);
    }

    private Object executeGeneric_long1(VirtualFrame frameValue, int state) {
        long child1Value_;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        try {
            child1Value_ = this.child1_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(child0Value_, ex.getResult());
        }
        assert ((state & 8) != 0);
        if (LLVMTypes.isPointer(child0Value_)) {
            LLVMPointer child0Value__ = LLVMTypes.asPointer(child0Value_);
            return this.doLong(child0Value__, child1Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(child0Value_, child1Value_);
    }

    private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
        LLVMPointer child1Value__;
        LLVMPointer child0Value__;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        Object child1Value_ = this.child1_.executeGeneric(frameValue);
        if ((state & 3) != 0 && LLVMTypes.isManagedPointer(child0Value_)) {
            child0Value__ = LLVMTypes.asManagedPointer(child0Value_);
            if (LLVMTypes.isManagedPointer(child1Value_)) {
                child1Value__ = LLVMTypes.asManagedPointer(child1Value_);
                if ((state & 1) != 0 && LLVMGetElementPtrNode.isNegated(child0Value__.getObject(), child1Value__.getObject())) {
                    return this.doPointerDiff((LLVMManagedPointer)child0Value__, (LLVMManagedPointer)child1Value__);
                }
                if ((state & 2) != 0 && LLVMGetElementPtrNode.isNegated(child1Value__.getObject(), child0Value__.getObject())) {
                    return this.doPointerDiffRev((LLVMManagedPointer)child0Value__, (LLVMManagedPointer)child1Value__);
                }
            }
        }
        if ((state & 0x1C) != 0 && LLVMTypes.isPointer(child0Value_)) {
            child0Value__ = LLVMTypes.asPointer(child0Value_);
            if ((state & 4) != 0 && child1Value_ instanceof Integer) {
                int child1Value__2 = (Integer)child1Value_;
                return this.doInt(child0Value__, child1Value__2);
            }
            if ((state & 8) != 0 && child1Value_ instanceof Long) {
                long child1Value__3 = (Long)child1Value_;
                return this.doLong(child0Value__, child1Value__3);
            }
            if ((state & 0x10) != 0 && LLVMTypes.isNativePointer(child1Value_)) {
                child1Value__ = LLVMTypes.asNativePointer(child1Value_);
                return this.doNativePointer(child0Value__, (LLVMNativePointer)child1Value__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(child0Value_, child1Value_);
    }

    private LLVMPointer executeAndSpecialize(Object child0Value, Object child1Value) {
        LLVMPointer child1Value_;
        LLVMPointer child0Value_;
        int state = this.state_;
        if (LLVMTypes.isManagedPointer(child0Value)) {
            child0Value_ = LLVMTypes.asManagedPointer(child0Value);
            if (LLVMTypes.isManagedPointer(child1Value)) {
                child1Value_ = LLVMTypes.asManagedPointer(child1Value);
                if (LLVMGetElementPtrNode.isNegated(child0Value_.getObject(), child1Value_.getObject())) {
                    this.state_ = state |= 1;
                    return this.doPointerDiff((LLVMManagedPointer)child0Value_, (LLVMManagedPointer)child1Value_);
                }
                if (LLVMGetElementPtrNode.isNegated(child1Value_.getObject(), child0Value_.getObject())) {
                    this.state_ = state |= 2;
                    return this.doPointerDiffRev((LLVMManagedPointer)child0Value_, (LLVMManagedPointer)child1Value_);
                }
            }
        }
        if (LLVMTypes.isPointer(child0Value)) {
            child0Value_ = LLVMTypes.asPointer(child0Value);
            if (child1Value instanceof Integer) {
                int child1Value_2 = (Integer)child1Value;
                this.state_ = state |= 4;
                return this.doInt(child0Value_, child1Value_2);
            }
            if (child1Value instanceof Long) {
                long child1Value_3 = (Long)child1Value;
                this.state_ = state |= 8;
                return this.doLong(child0Value_, child1Value_3);
            }
            if (LLVMTypes.isNativePointer(child1Value)) {
                child1Value_ = LLVMTypes.asNativePointer(child1Value);
                this.state_ = state |= 0x10;
                return this.doNativePointer(child0Value_, (LLVMNativePointer)child1Value_);
            }
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMGetElementPtrNode create(long typeWidth, Type targetType, LLVMExpressionNode child0, LLVMExpressionNode child1) {
        return new LLVMGetElementPtrNodeGen(typeWidth, targetType, child0, child1);
    }
}

