/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMCompareExchangeNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMCompareExchangeNode.class)
public final class LLVMCompareExchangeNodeGen
extends LLVMCompareExchangeNode {
    private LLVMSourceLocation sourceLocation;
    private boolean statement;
    @Node.Child
    private LLVMExpressionNode address_;
    @Node.Child
    private LLVMExpressionNode comparisonValue_;
    @Node.Child
    private LLVMExpressionNode newValue_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private LLVMCompareExchangeNodeGen(long resultSize, long secondValueOffset, LLVMExpressionNode address, LLVMExpressionNode comparisonValue, LLVMExpressionNode newValue) {
        super(resultSize, secondValueOffset);
        this.address_ = address;
        this.comparisonValue_ = comparisonValue;
        this.newValue_ = newValue;
    }

    @Override
    public LLVMSourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    protected boolean isStatement() {
        return this.statement;
    }

    @Override
    protected void setStatement(boolean statement) {
        this.statement = statement;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state = this.state_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        Object comparisonValueValue_ = this.comparisonValue_.executeGeneric(frameValue);
        Object newValueValue_ = this.newValue_.executeGeneric(frameValue);
        if (state != 0 && LLVMTypes.isPointer(addressValue_)) {
            LLVMPointer addressValue__ = LLVMTypes.asPointer(addressValue_);
            return this.doOp(frameValue, addressValue__, comparisonValueValue_, newValueValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, addressValue_, comparisonValueValue_, newValueValue_);
    }

    private Object executeAndSpecialize(VirtualFrame frameValue, Object addressValue, Object comparisonValueValue, Object newValueValue) {
        int state = this.state_;
        if (LLVMTypes.isPointer(addressValue)) {
            LLVMPointer addressValue_ = LLVMTypes.asPointer(addressValue);
            this.state_ = state |= 1;
            return this.doOp(frameValue, addressValue_, comparisonValueValue, newValueValue);
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_, this.comparisonValue_, this.newValue_}, new Object[]{addressValue, comparisonValueValue, newValueValue});
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public static LLVMCompareExchangeNode create(long resultSize, long secondValueOffset, LLVMExpressionNode address, LLVMExpressionNode comparisonValue, LLVMExpressionNode newValue) {
        return new LLVMCompareExchangeNodeGen(resultSize, secondValueOffset, address, comparisonValue, newValue);
    }

    @GeneratedBy(value=LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.class)
    static final class LLVMCMPXCHInternalNodeGen
    extends LLVMCompareExchangeNode.LLVMCMPXCHInternalNode {
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;
        @Node.Child
        private LLVMI8LoadNode op5_read_;
        @Node.Child
        private LLVMI8StoreNode op5_write_;
        @Node.Child
        private LLVMI16LoadNode op6_read_;
        @Node.Child
        private LLVMI16StoreNode op6_write_;
        @Node.Child
        private LLVMI32LoadNode op7_read_;
        @Node.Child
        private LLVMI32StoreNode op7_write_;
        @Node.Child
        private LLVMI64LoadNode op8_read_;
        @Node.Child
        private LLVMI64StoreNode op8_write_;
        @Node.Child
        private LLVMI64LoadNode op9_read_;
        @Node.Child
        private LLVMI64StoreNode op9_write_;

        private LLVMCMPXCHInternalNodeGen(long resultSize, long secondValueOffset) {
            super(resultSize, secondValueOffset);
        }

        @Override
        public Object executeWithTarget(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
            LLVMPointer arg0Value_;
            int state = this.state_;
            if ((state & 0x1F) != 0 && LLVMTypes.isNativePointer(arg0Value)) {
                arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                if ((state & 1) != 0 && arg1Value instanceof Byte) {
                    byte by = (Byte)arg1Value;
                    if (arg2Value instanceof Byte) {
                        byte arg2Value_ = (Byte)arg2Value;
                        TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        LLVMLanguage op0_language__ = (LLVMLanguage)lLVMLanguageReference__.get();
                        return this.doOp(frameValue, (LLVMNativePointer)arg0Value_, by, arg2Value_, op0_language__);
                    }
                }
                if ((state & 2) != 0 && arg1Value instanceof Short) {
                    short s = (Short)arg1Value;
                    if (arg2Value instanceof Short) {
                        short arg2Value_ = (Short)arg2Value;
                        TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__1 = this.lLVMLanguageReference_;
                        LLVMLanguage op1_language__ = (LLVMLanguage)lLVMLanguageReference__1.get();
                        return this.doOp(frameValue, (LLVMNativePointer)arg0Value_, s, arg2Value_, op1_language__);
                    }
                }
                if ((state & 4) != 0 && arg1Value instanceof Integer) {
                    int n = (Integer)arg1Value;
                    if (arg2Value instanceof Integer) {
                        int arg2Value_ = (Integer)arg2Value;
                        TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__2 = this.lLVMLanguageReference_;
                        LLVMLanguage op2_language__ = (LLVMLanguage)lLVMLanguageReference__2.get();
                        return this.doOp(frameValue, (LLVMNativePointer)arg0Value_, n, arg2Value_, op2_language__);
                    }
                }
                if ((state & 8) != 0 && arg1Value instanceof Long) {
                    long l = (Long)arg1Value;
                    if (arg2Value instanceof Long) {
                        long arg2Value_ = (Long)arg2Value;
                        TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__3 = this.lLVMLanguageReference_;
                        LLVMLanguage op3_language__ = (LLVMLanguage)lLVMLanguageReference__3.get();
                        return this.doOp(frameValue, (LLVMNativePointer)arg0Value_, l, arg2Value_, op3_language__);
                    }
                }
                if ((state & 0x10) != 0 && LLVMTypes.isNativePointer(arg1Value)) {
                    LLVMNativePointer lLVMNativePointer = LLVMTypes.asNativePointer(arg1Value);
                    if (LLVMTypes.isNativePointer(arg2Value)) {
                        LLVMNativePointer arg2Value_ = LLVMTypes.asNativePointer(arg2Value);
                        TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__4 = this.lLVMLanguageReference_;
                        LLVMLanguage op4_language__ = (LLVMLanguage)lLVMLanguageReference__4.get();
                        return this.doOp(frameValue, (LLVMNativePointer)arg0Value_, lLVMNativePointer, arg2Value_, op4_language__);
                    }
                }
            }
            if ((state & 0x3E0) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if ((state & 0x20) != 0 && arg1Value instanceof Byte) {
                    byte by = (Byte)arg1Value;
                    if (arg2Value instanceof Byte) {
                        byte arg2Value_ = (Byte)arg2Value;
                        TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__5 = this.lLVMLanguageReference_;
                        LLVMLanguage op5_language__ = (LLVMLanguage)lLVMLanguageReference__5.get();
                        return this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, by, arg2Value_, this.op5_read_, this.op5_write_, op5_language__);
                    }
                }
                if ((state & 0x40) != 0 && arg1Value instanceof Short) {
                    short s = (Short)arg1Value;
                    if (arg2Value instanceof Short) {
                        short arg2Value_ = (Short)arg2Value;
                        TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__6 = this.lLVMLanguageReference_;
                        LLVMLanguage op6_language__ = (LLVMLanguage)lLVMLanguageReference__6.get();
                        return this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, s, arg2Value_, this.op6_read_, this.op6_write_, op6_language__);
                    }
                }
                if ((state & 0x80) != 0 && arg1Value instanceof Integer) {
                    int n = (Integer)arg1Value;
                    if (arg2Value instanceof Integer) {
                        int arg2Value_ = (Integer)arg2Value;
                        TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__7 = this.lLVMLanguageReference_;
                        LLVMLanguage op7_language__ = (LLVMLanguage)lLVMLanguageReference__7.get();
                        return this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, n, arg2Value_, this.op7_read_, this.op7_write_, op7_language__);
                    }
                }
                if ((state & 0x100) != 0 && arg1Value instanceof Long) {
                    long l = (Long)arg1Value;
                    if (arg2Value instanceof Long) {
                        long arg2Value_ = (Long)arg2Value;
                        TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__8 = this.lLVMLanguageReference_;
                        LLVMLanguage op8_language__ = (LLVMLanguage)lLVMLanguageReference__8.get();
                        return this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, l, arg2Value_, this.op8_read_, this.op8_write_, op8_language__);
                    }
                }
                if ((state & 0x200) != 0 && LLVMTypes.isNativePointer(arg1Value)) {
                    LLVMNativePointer lLVMNativePointer = LLVMTypes.asNativePointer(arg1Value);
                    if (LLVMTypes.isNativePointer(arg2Value)) {
                        LLVMNativePointer arg2Value_ = LLVMTypes.asNativePointer(arg2Value);
                        TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__9 = this.lLVMLanguageReference_;
                        LLVMLanguage op9_language__ = (LLVMLanguage)lLVMLanguageReference__9.get();
                        return this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, lLVMNativePointer, arg2Value_, this.op9_read_, this.op9_write_, op9_language__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
        }

        private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                LLVMPointer arg0Value_;
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    LLVMLanguage op0_language__ = null;
                    if (arg1Value instanceof Byte) {
                        byte by = (Byte)arg1Value;
                        if (arg2Value instanceof Byte) {
                            byte arg2Value_ = (Byte)arg2Value;
                            TruffleLanguage.LanguageReference lLVMLanguageReference__10 = this.lLVMLanguageReference_;
                            if (lLVMLanguageReference__10 == null) {
                                this.lLVMLanguageReference_ = lLVMLanguageReference__10 = super.lookupLanguageReference(LLVMLanguage.class);
                            }
                            op0_language__ = (LLVMLanguage)lLVMLanguageReference__10.get();
                            this.state_ = state |= 1;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doOp(frameValue, (LLVMNativePointer)arg0Value_, by, arg2Value_, op0_language__);
                            return object;
                        }
                    }
                    LLVMLanguage op1_language__ = null;
                    if (arg1Value instanceof Short) {
                        short s = (Short)arg1Value;
                        if (arg2Value instanceof Short) {
                            short arg2Value_ = (Short)arg2Value;
                            TruffleLanguage.LanguageReference lLVMLanguageReference__11 = this.lLVMLanguageReference_;
                            if (lLVMLanguageReference__11 == null) {
                                this.lLVMLanguageReference_ = lLVMLanguageReference__11 = super.lookupLanguageReference(LLVMLanguage.class);
                            }
                            op1_language__ = (LLVMLanguage)lLVMLanguageReference__11.get();
                            this.state_ = state |= 2;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doOp(frameValue, (LLVMNativePointer)arg0Value_, s, arg2Value_, op1_language__);
                            return object;
                        }
                    }
                    LLVMLanguage op2_language__ = null;
                    if (arg1Value instanceof Integer) {
                        int n = (Integer)arg1Value;
                        if (arg2Value instanceof Integer) {
                            int arg2Value_ = (Integer)arg2Value;
                            TruffleLanguage.LanguageReference lLVMLanguageReference__12 = this.lLVMLanguageReference_;
                            if (lLVMLanguageReference__12 == null) {
                                this.lLVMLanguageReference_ = lLVMLanguageReference__12 = super.lookupLanguageReference(LLVMLanguage.class);
                            }
                            op2_language__ = (LLVMLanguage)lLVMLanguageReference__12.get();
                            this.state_ = state |= 4;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doOp(frameValue, (LLVMNativePointer)arg0Value_, n, arg2Value_, op2_language__);
                            return object;
                        }
                    }
                    LLVMLanguage op3_language__ = null;
                    if (arg1Value instanceof Long) {
                        long l = (Long)arg1Value;
                        if (arg2Value instanceof Long) {
                            long arg2Value_ = (Long)arg2Value;
                            TruffleLanguage.LanguageReference lLVMLanguageReference__13 = this.lLVMLanguageReference_;
                            if (lLVMLanguageReference__13 == null) {
                                this.lLVMLanguageReference_ = lLVMLanguageReference__13 = super.lookupLanguageReference(LLVMLanguage.class);
                            }
                            op3_language__ = (LLVMLanguage)lLVMLanguageReference__13.get();
                            this.state_ = state |= 8;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doOp(frameValue, (LLVMNativePointer)arg0Value_, l, arg2Value_, op3_language__);
                            return object;
                        }
                    }
                    LLVMLanguage op4_language__ = null;
                    if (LLVMTypes.isNativePointer(arg1Value)) {
                        LLVMNativePointer lLVMNativePointer = LLVMTypes.asNativePointer(arg1Value);
                        if (LLVMTypes.isNativePointer(arg2Value)) {
                            LLVMNativePointer arg2Value_ = LLVMTypes.asNativePointer(arg2Value);
                            TruffleLanguage.LanguageReference lLVMLanguageReference__14 = this.lLVMLanguageReference_;
                            if (lLVMLanguageReference__14 == null) {
                                this.lLVMLanguageReference_ = lLVMLanguageReference__14 = super.lookupLanguageReference(LLVMLanguage.class);
                            }
                            op4_language__ = (LLVMLanguage)lLVMLanguageReference__14.get();
                            this.state_ = state |= 0x10;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doOp(frameValue, (LLVMNativePointer)arg0Value_, lLVMNativePointer, arg2Value_, op4_language__);
                            return object;
                        }
                    }
                }
                if (LLVMTypes.isManagedPointer(arg0Value)) {
                    arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    LLVMLanguage op5_language__ = null;
                    if (arg1Value instanceof Byte) {
                        byte by = (Byte)arg1Value;
                        if (arg2Value instanceof Byte) {
                            byte arg2Value_ = (Byte)arg2Value;
                            this.op5_read_ = (LLVMI8LoadNode)super.insert((Node)LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.createI8Read());
                            this.op5_write_ = (LLVMI8StoreNode)super.insert((Node)LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.createI8Write());
                            TruffleLanguage.LanguageReference lLVMLanguageReference__15 = this.lLVMLanguageReference_;
                            if (lLVMLanguageReference__15 == null) {
                                this.lLVMLanguageReference_ = lLVMLanguageReference__15 = super.lookupLanguageReference(LLVMLanguage.class);
                            }
                            op5_language__ = (LLVMLanguage)lLVMLanguageReference__15.get();
                            this.state_ = state |= 0x20;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, by, arg2Value_, this.op5_read_, this.op5_write_, op5_language__);
                            return object;
                        }
                    }
                    LLVMLanguage op6_language__ = null;
                    if (arg1Value instanceof Short) {
                        short s = (Short)arg1Value;
                        if (arg2Value instanceof Short) {
                            short arg2Value_ = (Short)arg2Value;
                            this.op6_read_ = (LLVMI16LoadNode)super.insert((Node)LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.createI16Read());
                            this.op6_write_ = (LLVMI16StoreNode)super.insert((Node)LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.createI16Write());
                            TruffleLanguage.LanguageReference lLVMLanguageReference__16 = this.lLVMLanguageReference_;
                            if (lLVMLanguageReference__16 == null) {
                                this.lLVMLanguageReference_ = lLVMLanguageReference__16 = super.lookupLanguageReference(LLVMLanguage.class);
                            }
                            op6_language__ = (LLVMLanguage)lLVMLanguageReference__16.get();
                            this.state_ = state |= 0x40;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, s, arg2Value_, this.op6_read_, this.op6_write_, op6_language__);
                            return object;
                        }
                    }
                    LLVMLanguage op7_language__ = null;
                    if (arg1Value instanceof Integer) {
                        int n = (Integer)arg1Value;
                        if (arg2Value instanceof Integer) {
                            int arg2Value_ = (Integer)arg2Value;
                            this.op7_read_ = (LLVMI32LoadNode)super.insert((Node)LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.createI32Read());
                            this.op7_write_ = (LLVMI32StoreNode)super.insert((Node)LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.createI32Write());
                            TruffleLanguage.LanguageReference lLVMLanguageReference__17 = this.lLVMLanguageReference_;
                            if (lLVMLanguageReference__17 == null) {
                                this.lLVMLanguageReference_ = lLVMLanguageReference__17 = super.lookupLanguageReference(LLVMLanguage.class);
                            }
                            op7_language__ = (LLVMLanguage)lLVMLanguageReference__17.get();
                            this.state_ = state |= 0x80;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, n, arg2Value_, this.op7_read_, this.op7_write_, op7_language__);
                            return object;
                        }
                    }
                    LLVMLanguage op8_language__ = null;
                    if (arg1Value instanceof Long) {
                        long l = (Long)arg1Value;
                        if (arg2Value instanceof Long) {
                            long arg2Value_ = (Long)arg2Value;
                            this.op8_read_ = (LLVMI64LoadNode)super.insert((Node)LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.createI64Read());
                            this.op8_write_ = (LLVMI64StoreNode)super.insert((Node)LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.createI64Write());
                            TruffleLanguage.LanguageReference lLVMLanguageReference__18 = this.lLVMLanguageReference_;
                            if (lLVMLanguageReference__18 == null) {
                                this.lLVMLanguageReference_ = lLVMLanguageReference__18 = super.lookupLanguageReference(LLVMLanguage.class);
                            }
                            op8_language__ = (LLVMLanguage)lLVMLanguageReference__18.get();
                            this.state_ = state |= 0x100;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, l, arg2Value_, this.op8_read_, this.op8_write_, op8_language__);
                            return object;
                        }
                    }
                    LLVMLanguage op9_language__ = null;
                    if (LLVMTypes.isNativePointer(arg1Value)) {
                        LLVMNativePointer lLVMNativePointer = LLVMTypes.asNativePointer(arg1Value);
                        if (LLVMTypes.isNativePointer(arg2Value)) {
                            LLVMNativePointer arg2Value_ = LLVMTypes.asNativePointer(arg2Value);
                            this.op9_read_ = (LLVMI64LoadNode)super.insert((Node)LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.createI64Read());
                            this.op9_write_ = (LLVMI64StoreNode)super.insert((Node)LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.createI64Write());
                            TruffleLanguage.LanguageReference lLVMLanguageReference__19 = this.lLVMLanguageReference_;
                            if (lLVMLanguageReference__19 == null) {
                                this.lLVMLanguageReference_ = lLVMLanguageReference__19 = super.lookupLanguageReference(LLVMLanguage.class);
                            }
                            op9_language__ = (LLVMLanguage)lLVMLanguageReference__19.get();
                            this.state_ = state |= 0x200;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, lLVMNativePointer, arg2Value_, this.op9_read_, this.op9_write_, op9_language__);
                            return object;
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCompareExchangeNode.LLVMCMPXCHInternalNode create(long resultSize, long secondValueOffset) {
            return new LLVMCMPXCHInternalNodeGen(resultSize, secondValueOffset);
        }
    }
}

