/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.NFIContextExtension;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.memory.LLVMAllocateNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class AllocateReadOnlyGlobalsBlockNode
extends LLVMNode
implements LLVMAllocateNode {
    private final long size;
    @Node.Child
    InteropLibrary interop;
    @Node.Child
    LLVMToNativeNode toNative;
    private final TruffleObject allocateGlobalsBlock;

    public AllocateReadOnlyGlobalsBlockNode(LLVMContext context, StructureType type, DataLayout dataLayout) throws Type.TypeOverflowException {
        this.size = type.getSize(dataLayout);
        this.toNative = LLVMToNativeNode.createToNativeWithTarget();
        NFIContextExtension nfiContextExtension = context.getContextExtensionOrNull(NFIContextExtension.class);
        this.allocateGlobalsBlock = nfiContextExtension.getNativeFunction(context, "__sulong_allocate_globals_block", "(UINT64):POINTER");
        this.interop = (InteropLibrary)InteropLibrary.getFactory().create((Object)this.allocateGlobalsBlock);
    }

    @Override
    public LLVMPointer executeWithTarget() {
        try {
            Object ret = this.interop.execute((Object)this.allocateGlobalsBlock, new Object[]{this.size});
            return this.toNative.executeWithTarget(ret);
        }
        catch (InteropException ex) {
            throw new OutOfMemoryError("could not allocate globals block");
        }
    }
}

