/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.memory.LLVMAllocateNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.AllocateGlobalsBlockNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;

public abstract class AllocateGlobalsBlockNode
extends LLVMNode
implements LLVMAllocateNode {
    private final long size;

    protected AllocateGlobalsBlockNode(long size) {
        this.size = size;
    }

    @Specialization
    LLVMPointer doAllocate(@CachedLanguage LLVMLanguage language) {
        return language.getLLVMMemory().allocateMemory(this, this.size);
    }

    public static AllocateGlobalsBlockNode create(StructureType type, DataLayout dataLayout) throws Type.TypeOverflowException {
        return AllocateGlobalsBlockNodeGen.create(type.getSize(dataLayout));
    }
}

