/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.rust;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMUnsupportedException;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMDispatchNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMDispatchNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMFunctionStartNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.rust.LLVMStartFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;

public abstract class LLVMStart
extends LLVMIntrinsic {
    protected LLVMClosureDispatchNode createClosureDispatchNode() {
        CompilerAsserts.neverPartOfCompilation();
        return LLVMStartFactory.LLVMClosureDispatchNodeGen.create();
    }

    static abstract class LLVMClosureDispatchNode
    extends LLVMNode {
        LLVMClosureDispatchNode() {
        }

        public abstract Object executeDispatch(Object var1, Object[] var2);

        @Specialization(guards={"pointer.asNative() == cachedAddress"})
        protected Object doHandleCached(LLVMNativePointer pointer, Object[] arguments, @Cached(value="pointer.asNative()") long cachedAddress, @Cached(value="getFunctionDescriptor(pointer)") LLVMFunctionDescriptor cachedDescriptor, @Cached(value="getDispatchNode(cachedDescriptor)") LLVMDispatchNode dispatchNode) {
            return dispatchNode.executeDispatch(cachedDescriptor, arguments);
        }

        @Specialization(guards={"isSameObject(pointer.getObject(), cachedDescriptor)", "cachedDescriptor != null", "pointer.getOffset() == 0"})
        protected Object doDirectCached(LLVMManagedPointer pointer, Object[] arguments, @Cached(value="asFunctionDescriptor(pointer.getObject())") LLVMFunctionDescriptor cachedDescriptor, @Cached(value="getDispatchNode(cachedDescriptor)") LLVMDispatchNode dispatchNode) {
            return dispatchNode.executeDispatch(cachedDescriptor, arguments);
        }

        @Specialization
        protected Object doOther(LLVMManagedPointer pointer, Object[] arguments) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Inline cache was not big enough");
        }

        @CompilerDirectives.TruffleBoundary
        protected LLVMFunctionDescriptor getFunctionDescriptor(LLVMNativePointer fp) {
            return ((LLVMContext)this.lookupContextReference(LLVMLanguage.class).get()).getFunctionDescriptor(fp);
        }

        @CompilerDirectives.TruffleBoundary
        protected LLVMDispatchNode getDispatchNode(LLVMFunctionDescriptor fd) {
            return LLVMDispatchNodeGen.create(fd.getLLVMFunction().getType());
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMLangStartInternal
    extends LLVMStart {
        @CompilerDirectives.TruffleBoundary
        protected LangStartVtableType createLangStartVtable(LLVMGlobal vtableGlobal) throws Type.TypeOverflowException {
            Type vtableType = vtableGlobal.getPointeeType();
            LLVMFunctionStartNode startNode = (LLVMFunctionStartNode)this.getRootNode();
            DataLayout dataSpecConverter = startNode.getDatalayout();
            return LangStartVtableType.create(dataSpecConverter, vtableType);
        }

        @Specialization
        protected long doOp(LLVMStack.StackPointer stackPointer, LLVMNativePointer mainPointer, LLVMNativePointer vtable, long argc, LLVMPointer argv, @CachedContext(value=LLVMLanguage.class) LLVMContext ctx, @CachedLanguage LLVMLanguage language, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative, @Cached(value="createClosureDispatchNode()") LLVMClosureDispatchNode fnDispatchNode, @Cached(value="createClosureDispatchNode()") LLVMClosureDispatchNode dropInPlaceDispatchNode) {
            LLVMMemory memory = language.getLLVMMemory();
            LLVMGlobal vtableGlobal = ctx.findGlobal(vtable);
            assert (vtableGlobal != null);
            try {
                LangStartVtableType langStartVtable = this.createLangStartVtable(vtableGlobal);
                LLVMNativePointer fn = this.readFn(memory, vtable, langStartVtable);
                LLVMNativePointer dropInPlace = this.readDropInPlace(memory, vtable, langStartVtable);
                LLVMNativePointer main = this.coerceMainForFn(memory, langStartVtable, mainPointer);
                Integer exitCode = (Integer)fnDispatchNode.executeDispatch(fn, new Object[]{stackPointer, main});
                dropInPlaceDispatchNode.executeDispatch(dropInPlace, new Object[]{stackPointer, mainPointer});
                return exitCode.longValue();
            }
            catch (Type.TypeOverflowException e) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMUnsupportedException((Node)this, LLVMUnsupportedException.UnsupportedReason.UNSUPPORTED_VALUE_RANGE, (Throwable)e);
            }
        }

        protected LLVMNativePointer readFn(LLVMMemory memory, LLVMNativePointer vtablePointer, LangStartVtableType langStartVtable) {
            return LLVMNativePointer.create(langStartVtable.readFn(memory, vtablePointer.asNative()));
        }

        protected LLVMNativePointer readDropInPlace(LLVMMemory memory, LLVMNativePointer vtablePointer, LangStartVtableType langStartVtable) {
            return LLVMNativePointer.create(langStartVtable.readDropInPlace(memory, vtablePointer.asNative()));
        }

        protected LLVMNativePointer coerceMainForFn(LLVMMemory memory, LangStartVtableType langStartVtable, LLVMNativePointer mainPointer) {
            return LLVMNativePointer.create(langStartVtable.coerceMainForFn(memory, mainPointer.asNative()));
        }

        static final class LangStartVtableType {
            private final long offsetFn;
            private final boolean fnExpectsCoercedMain;

            private LangStartVtableType(DataLayout datalayout, StructureType type, FunctionType fnType) throws Type.TypeOverflowException {
                this.offsetFn = type.getOffsetOf(5L, datalayout);
                this.fnExpectsCoercedMain = !(((PointerType)fnType.getArgumentType(0)).getPointeeType() instanceof PointerType);
            }

            long readFn(LLVMMemory memory, long address) {
                return memory.getPointer(null, address + this.offsetFn).asNative();
            }

            long coerceMainForFn(LLVMMemory memory, long mainAddress) {
                if (this.fnExpectsCoercedMain) {
                    return memory.getPointer(null, mainAddress).asNative();
                }
                return mainAddress;
            }

            long readDropInPlace(LLVMMemory memory, long address) {
                return memory.getPointer(null, address).asNative();
            }

            static LangStartVtableType create(DataLayout datalayout, Type vtableType) throws Type.TypeOverflowException {
                FunctionType fnType = (FunctionType)((PointerType)((StructureType)vtableType).getElementType(5L)).getPointeeType();
                return new LangStartVtableType(datalayout, (StructureType)vtableType, fnType);
            }
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMLangStart
    extends LLVMStart {
        @Specialization
        protected long doOp(LLVMStack.StackPointer stackPointer, LLVMPointer main, long argc, LLVMPointer argv, @Cached(value="createClosureDispatchNode()") LLVMClosureDispatchNode dispatchNode) {
            dispatchNode.executeDispatch(main, new Object[]{stackPointer});
            return 0L;
        }
    }
}

