/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading.LLVMPThreadThreadIntrinsics;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMPThreadThreadIntrinsics.class)
public final class LLVMPThreadThreadIntrinsicsFactory {

    @GeneratedBy(value=LLVMPThreadThreadIntrinsics.LLVMPThreadSelf.class)
    public static final class LLVMPThreadSelfNodeGen
    extends LLVMPThreadThreadIntrinsics.LLVMPThreadSelf {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;

        private LLVMPThreadSelfNodeGen() {
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return this.doIntrinsic();
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMPThreadThreadIntrinsics.LLVMPThreadSelf create() {
            return new LLVMPThreadSelfNodeGen();
        }
    }

    @GeneratedBy(value=LLVMPThreadThreadIntrinsics.LLVMPThreadJoin.class)
    public static final class LLVMPThreadJoinNodeGen
    extends LLVMPThreadThreadIntrinsics.LLVMPThreadJoin {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode threadId_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;

        private LLVMPThreadJoinNodeGen(LLVMExpressionNode threadId) {
            this.threadId_ = threadId;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            long threadIdValue_;
            int state = this.state_;
            try {
                threadIdValue_ = this.threadId_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                LLVMContext context__ = (LLVMContext)lLVMLanguageContextReference__.get();
                return this.doIntrinsic(threadIdValue_, context__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(threadIdValue_);
        }

        private Object executeAndSpecialize(Object threadIdValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                LLVMContext context__ = null;
                if (threadIdValue instanceof Long) {
                    long threadIdValue_ = (Long)threadIdValue;
                    TruffleLanguage.ContextReference lLVMLanguageContextReference__1 = this.lLVMLanguageContextReference_;
                    if (lLVMLanguageContextReference__1 == null) {
                        this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__1 = super.lookupContextReference(LLVMLanguage.class);
                    }
                    context__ = (LLVMContext)lLVMLanguageContextReference__1.get();
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doIntrinsic(threadIdValue_, context__);
                    return object;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.threadId_}, new Object[]{threadIdValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMPThreadThreadIntrinsics.LLVMPThreadJoin create(LLVMExpressionNode threadId) {
            return new LLVMPThreadJoinNodeGen(threadId);
        }
    }

    @GeneratedBy(value=LLVMPThreadThreadIntrinsics.LLVMPThreadExit.class)
    public static final class LLVMPThreadExitNodeGen
    extends LLVMPThreadThreadIntrinsics.LLVMPThreadExit {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode retval_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;

        private LLVMPThreadExitNodeGen(LLVMExpressionNode retval) {
            this.retval_ = retval;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object retvalValue_ = this.retval_.executeGeneric(frameValue);
            if (state != 0) {
                TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                LLVMContext context__ = (LLVMContext)lLVMLanguageContextReference__.get();
                return this.doIntrinsic(retvalValue_, context__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(retvalValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int state = this.state_;
            Object retvalValue_ = this.retval_.executeGeneric(frameValue);
            if (state != 0) {
                TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__1 = this.lLVMLanguageContextReference_;
                LLVMContext context__ = (LLVMContext)lLVMLanguageContextReference__1.get();
                return this.doIntrinsic(retvalValue_, context__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(retvalValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int executeAndSpecialize(Object retvalValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                LLVMContext context__ = null;
                TruffleLanguage.ContextReference lLVMLanguageContextReference__2 = this.lLVMLanguageContextReference_;
                if (lLVMLanguageContextReference__2 == null) {
                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__2 = super.lookupContextReference(LLVMLanguage.class);
                }
                context__ = (LLVMContext)lLVMLanguageContextReference__2.get();
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                int n = this.doIntrinsic(retvalValue, context__);
                return n;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMPThreadThreadIntrinsics.LLVMPThreadExit create(LLVMExpressionNode retval) {
            return new LLVMPThreadExitNodeGen(retval);
        }
    }

    @GeneratedBy(value=LLVMPThreadThreadIntrinsics.LLVMPThreadCreate.class)
    public static final class LLVMPThreadCreateNodeGen
    extends LLVMPThreadThreadIntrinsics.LLVMPThreadCreate {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode thread_;
        @Node.Child
        private LLVMExpressionNode startRoutine_;
        @Node.Child
        private LLVMExpressionNode arg_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;
        @Node.Child
        private LLVMStoreNode store_;

        private LLVMPThreadCreateNodeGen(LLVMExpressionNode thread, LLVMExpressionNode startRoutine, LLVMExpressionNode arg) {
            this.thread_ = thread;
            this.startRoutine_ = startRoutine;
            this.arg_ = arg;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object threadValue_ = this.thread_.executeGeneric(frameValue);
            Object startRoutineValue_ = this.startRoutine_.executeGeneric(frameValue);
            Object argValue_ = this.arg_.executeGeneric(frameValue);
            if (state != 0 && LLVMTypes.isPointer(threadValue_)) {
                LLVMPointer threadValue__ = LLVMTypes.asPointer(threadValue_);
                if (LLVMTypes.isPointer(startRoutineValue_)) {
                    LLVMPointer startRoutineValue__ = LLVMTypes.asPointer(startRoutineValue_);
                    if (LLVMTypes.isPointer(argValue_)) {
                        LLVMPointer argValue__ = LLVMTypes.asPointer(argValue_);
                        TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                        LLVMContext context__ = (LLVMContext)lLVMLanguageContextReference__.get();
                        return this.doIntrinsic(threadValue__, startRoutineValue__, argValue__, this.store_, context__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(threadValue_, startRoutineValue_, argValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int state = this.state_;
            Object threadValue_ = this.thread_.executeGeneric(frameValue);
            Object startRoutineValue_ = this.startRoutine_.executeGeneric(frameValue);
            Object argValue_ = this.arg_.executeGeneric(frameValue);
            if (state != 0 && LLVMTypes.isPointer(threadValue_)) {
                LLVMPointer threadValue__ = LLVMTypes.asPointer(threadValue_);
                if (LLVMTypes.isPointer(startRoutineValue_)) {
                    LLVMPointer startRoutineValue__ = LLVMTypes.asPointer(startRoutineValue_);
                    if (LLVMTypes.isPointer(argValue_)) {
                        LLVMPointer argValue__ = LLVMTypes.asPointer(argValue_);
                        TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__1 = this.lLVMLanguageContextReference_;
                        LLVMContext context__ = (LLVMContext)lLVMLanguageContextReference__1.get();
                        return this.doIntrinsic(threadValue__, startRoutineValue__, argValue__, this.store_, context__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(threadValue_, startRoutineValue_, argValue_);
        }

        private int executeAndSpecialize(Object threadValue, Object startRoutineValue, Object argValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                LLVMContext context__ = null;
                if (LLVMTypes.isPointer(threadValue)) {
                    LLVMPointer threadValue_ = LLVMTypes.asPointer(threadValue);
                    if (LLVMTypes.isPointer(startRoutineValue)) {
                        LLVMPointer startRoutineValue_ = LLVMTypes.asPointer(startRoutineValue);
                        if (LLVMTypes.isPointer(argValue)) {
                            LLVMPointer argValue_ = LLVMTypes.asPointer(argValue);
                            this.store_ = (LLVMStoreNode)super.insert((Node)CommonNodeFactory.createStoreNode(LLVMInteropType.ValueKind.I64));
                            TruffleLanguage.ContextReference lLVMLanguageContextReference__2 = this.lLVMLanguageContextReference_;
                            if (lLVMLanguageContextReference__2 == null) {
                                this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__2 = super.lookupContextReference(LLVMLanguage.class);
                            }
                            context__ = (LLVMContext)lLVMLanguageContextReference__2.get();
                            this.state_ = state |= 1;
                            lock.unlock();
                            hasLock = false;
                            int n = this.doIntrinsic(threadValue_, startRoutineValue_, argValue_, this.store_, context__);
                            return n;
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.thread_, this.startRoutine_, this.arg_}, new Object[]{threadValue, startRoutineValue, argValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMPThreadThreadIntrinsics.LLVMPThreadCreate create(LLVMExpressionNode thread, LLVMExpressionNode startRoutine, LLVMExpressionNode arg) {
            return new LLVMPThreadCreateNodeGen(thread, startRoutine, arg);
        }
    }
}

