/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMVarArgCompoundValue;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.memory.VarargsAreaStackAllocationNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVM80BitFloatStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;

@NodeChild
public abstract class LLVMX86_64VAStart
extends LLVMExpressionNode {
    private final int numberOfExplicitArguments;
    @Node.Child
    private VarargsAreaStackAllocationNode stackAllocationNode;
    @Node.Child
    private LLVMStoreNode i64RegSaveAreaStore;
    @Node.Child
    private LLVMStoreNode i32RegSaveAreaStore;
    @Node.Child
    private LLVMStoreNode fp80bitRegSaveAreaStore;
    @Node.Child
    private LLVMStoreNode pointerRegSaveAreaStore;
    @Node.Child
    private LLVMStoreNode i64OverflowArgAreaStore;
    @Node.Child
    private LLVMStoreNode i32OverflowArgAreaStore;
    @Node.Child
    private LLVMStoreNode fp80bitOverflowArgAreaStore;
    @Node.Child
    private LLVMStoreNode pointerOverflowArgAreaStore;
    @Node.Child
    private LLVMStoreNode gpOffsetStore;
    @Node.Child
    private LLVMStoreNode fpOffsetStore;
    @Node.Child
    private LLVMStoreNode overflowArgAreaStore;
    @Node.Child
    private LLVMStoreNode regSaveAreaStore;
    @Node.Child
    private LLVMMemMoveNode memmove;

    public LLVMX86_64VAStart(int numberOfExplicitArguments, VarargsAreaStackAllocationNode stackAllocationNode, LLVMMemMoveNode memmove) {
        this.numberOfExplicitArguments = numberOfExplicitArguments;
        this.stackAllocationNode = stackAllocationNode;
        this.i64RegSaveAreaStore = LLVMI64StoreNodeGen.create(null, null);
        this.i32RegSaveAreaStore = LLVMI32StoreNodeGen.create(null, null);
        this.fp80bitRegSaveAreaStore = LLVM80BitFloatStoreNodeGen.create(null, null);
        this.pointerRegSaveAreaStore = LLVMPointerStoreNodeGen.create(null, null);
        this.i64OverflowArgAreaStore = LLVMI64StoreNodeGen.create(null, null);
        this.i32OverflowArgAreaStore = LLVMI32StoreNodeGen.create(null, null);
        this.fp80bitOverflowArgAreaStore = LLVM80BitFloatStoreNodeGen.create(null, null);
        this.pointerOverflowArgAreaStore = LLVMPointerStoreNodeGen.create(null, null);
        this.gpOffsetStore = LLVMI32StoreNodeGen.create(null, null);
        this.fpOffsetStore = LLVMI32StoreNodeGen.create(null, null);
        this.overflowArgAreaStore = LLVMPointerStoreNodeGen.create(null, null);
        this.regSaveAreaStore = LLVMPointerStoreNodeGen.create(null, null);
        this.memmove = memmove;
    }

    private void setGPOffset(LLVMPointer address, int value) {
        LLVMPointer p = address.increment(0L);
        this.gpOffsetStore.executeWithTarget(p, value);
    }

    private void setFPOffset(LLVMPointer address, int value) {
        LLVMPointer p = address.increment(4L);
        this.fpOffsetStore.executeWithTarget(p, value);
    }

    private void setOverflowArgArea(LLVMPointer address, Object value) {
        LLVMPointer p = address.increment(8L);
        this.overflowArgAreaStore.executeWithTarget(p, value);
    }

    private void setRegSaveArea(LLVMPointer address, Object value) {
        LLVMPointer p = address.increment(16L);
        this.regSaveAreaStore.executeWithTarget(p, value);
    }

    private void initializeVaList(LLVMPointer valist, int gpOffset, int fpOffset, Object overflowArgArea, Object regSaveArea) {
        this.setGPOffset(valist, gpOffset);
        this.setFPOffset(valist, fpOffset);
        this.setOverflowArgArea(valist, overflowArgArea);
        this.setRegSaveArea(valist, regSaveArea);
    }

    private static VarArgArea getVarArgArea(Object arg) {
        if (arg instanceof Boolean) {
            return VarArgArea.GP_AREA;
        }
        if (arg instanceof Byte) {
            return VarArgArea.GP_AREA;
        }
        if (arg instanceof Short) {
            return VarArgArea.GP_AREA;
        }
        if (arg instanceof Integer) {
            return VarArgArea.GP_AREA;
        }
        if (arg instanceof Long) {
            return VarArgArea.GP_AREA;
        }
        if (arg instanceof Float) {
            return VarArgArea.FP_AREA;
        }
        if (arg instanceof Double) {
            return VarArgArea.FP_AREA;
        }
        if (arg instanceof LLVMVarArgCompoundValue) {
            return VarArgArea.OVERFLOW_AREA;
        }
        if (LLVMPointer.isInstance(arg)) {
            return VarArgArea.GP_AREA;
        }
        if (arg instanceof LLVM80BitFloat) {
            return VarArgArea.OVERFLOW_AREA;
        }
        if (arg instanceof LLVMFloatVector && ((LLVMFloatVector)arg).getLength() <= 2) {
            return VarArgArea.FP_AREA;
        }
        CompilerDirectives.transferToInterpreter();
        throw new AssertionError(arg);
    }

    private static Object[] getArgumentsArray(VirtualFrame frame) {
        Object[] arguments = frame.getArguments();
        Object[] newArguments = new Object[arguments.length - 1];
        System.arraycopy(arguments, 1, newArguments, 0, newArguments.length);
        return newArguments;
    }

    private int computeOverflowArgAreaSize(Object[] realArguments) {
        assert (this.numberOfExplicitArguments <= realArguments.length);
        int overflowArea = 0;
        int gpOffset = this.calculateUsedGpArea(realArguments);
        int fpOffset = 48 + this.calculateUsedFpArea(realArguments);
        for (int i = this.numberOfExplicitArguments; i < realArguments.length; ++i) {
            Object arg = realArguments[i];
            VarArgArea area = LLVMX86_64VAStart.getVarArgArea(arg);
            if (area == VarArgArea.GP_AREA && gpOffset < 48) {
                gpOffset += 8;
                continue;
            }
            if (area == VarArgArea.FP_AREA && fpOffset < 176) {
                fpOffset += 16;
                continue;
            }
            if (area != VarArgArea.OVERFLOW_AREA) {
                overflowArea += 8;
                continue;
            }
            if (arg instanceof LLVM80BitFloat) {
                overflowArea += 16;
                continue;
            }
            if (arg instanceof LLVMVarArgCompoundValue) {
                LLVMVarArgCompoundValue obj = (LLVMVarArgCompoundValue)arg;
                overflowArea = (int)((long)overflowArea + obj.getSize());
                continue;
            }
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError(arg);
        }
        return overflowArea;
    }

    @ExplodeLoop
    private int calculateUsedFpArea(Object[] realArguments) {
        assert (this.numberOfExplicitArguments <= realArguments.length);
        int usedFpArea = 0;
        int fpAreaLimit = 128;
        for (int i = 0; i < this.numberOfExplicitArguments && usedFpArea < 128; ++i) {
            if (LLVMX86_64VAStart.getVarArgArea(realArguments[i]) != VarArgArea.FP_AREA) continue;
            usedFpArea += 16;
        }
        return usedFpArea;
    }

    @ExplodeLoop
    private int calculateUsedGpArea(Object[] realArguments) {
        assert (this.numberOfExplicitArguments <= realArguments.length);
        int usedGpArea = 0;
        for (int i = 0; i < this.numberOfExplicitArguments && usedGpArea < 48; ++i) {
            if (LLVMX86_64VAStart.getVarArgArea(realArguments[i]) != VarArgArea.GP_AREA) continue;
            usedGpArea += 8;
        }
        return usedGpArea;
    }

    @Specialization
    protected Object vaStart(VirtualFrame frame, LLVMPointer targetAddress) {
        Object[] arguments = LLVMX86_64VAStart.getArgumentsArray(frame);
        int vaLength = arguments.length - this.numberOfExplicitArguments;
        LLVMPointer regSaveArea = this.stackAllocationNode.executeWithTarget(frame, 176L);
        int overflowArgAreaSize = this.computeOverflowArgAreaSize(arguments);
        LLVMPointer overflowArgArea = this.stackAllocationNode.executeWithTarget(frame, overflowArgAreaSize);
        int gpOffset = this.calculateUsedGpArea(arguments);
        int fpOffset = 48 + this.calculateUsedFpArea(arguments);
        this.initializeVaList(targetAddress, gpOffset, fpOffset, overflowArgArea, regSaveArea);
        if (vaLength > 0) {
            int overflowOffset = 0;
            for (int i = 0; i < vaLength; ++i) {
                Object object = arguments[this.numberOfExplicitArguments + i];
                VarArgArea area = LLVMX86_64VAStart.getVarArgArea(object);
                if (area == VarArgArea.GP_AREA && gpOffset < 48) {
                    LLVMX86_64VAStart.storeArgument(regSaveArea, gpOffset, this.memmove, this.i64RegSaveAreaStore, this.i32RegSaveAreaStore, this.fp80bitRegSaveAreaStore, this.pointerRegSaveAreaStore, object);
                    gpOffset += 8;
                    continue;
                }
                if (area == VarArgArea.FP_AREA && fpOffset < 176) {
                    LLVMX86_64VAStart.storeArgument(regSaveArea, fpOffset, this.memmove, this.i64RegSaveAreaStore, this.i32RegSaveAreaStore, this.fp80bitRegSaveAreaStore, this.pointerRegSaveAreaStore, object);
                    fpOffset += 16;
                    continue;
                }
                assert (overflowArgAreaSize >= overflowOffset);
                overflowOffset = (int)((long)overflowOffset + LLVMX86_64VAStart.storeArgument(overflowArgArea, overflowOffset, this.memmove, this.i64OverflowArgAreaStore, this.i32OverflowArgAreaStore, this.fp80bitOverflowArgAreaStore, this.pointerOverflowArgAreaStore, object));
            }
        }
        return null;
    }

    private static long storeArgument(LLVMPointer ptr, long offset, LLVMMemMoveNode memmove, LLVMStoreNode storeI64Node, LLVMStoreNode storeI32Node, LLVMStoreNode storeFP80Node, LLVMStoreNode storePointerNode, Object object) {
        if (object instanceof Number) {
            return LLVMX86_64VAStart.doPrimitiveWrite(ptr, offset, storeI64Node, object);
        }
        if (object instanceof LLVMVarArgCompoundValue) {
            LLVMVarArgCompoundValue obj = (LLVMVarArgCompoundValue)object;
            LLVMPointer currentPtr = ptr.increment(offset);
            memmove.executeWithTarget(currentPtr, obj.getAddr(), obj.getSize());
            return obj.getSize();
        }
        if (LLVMPointer.isInstance(object)) {
            LLVMPointer currentPtr = ptr.increment(offset);
            storePointerNode.executeWithTarget(currentPtr, object);
            return 8L;
        }
        if (object instanceof LLVM80BitFloat) {
            LLVMPointer currentPtr = ptr.increment(offset);
            storeFP80Node.executeWithTarget(currentPtr, object);
            return 16L;
        }
        if (object instanceof LLVMFloatVector) {
            LLVMFloatVector floatVec = (LLVMFloatVector)object;
            for (int i = 0; i < floatVec.getLength(); ++i) {
                LLVMPointer currentPtr = ptr.increment(offset + (long)(i * 4));
                storeI32Node.executeWithTarget(currentPtr, Float.floatToIntBits(floatVec.getValue(i)));
            }
            return floatVec.getLength() * 4;
        }
        CompilerDirectives.transferToInterpreter();
        throw new AssertionError(object);
    }

    private static int doPrimitiveWrite(LLVMPointer ptr, long offset, LLVMStoreNode storeNode, Object arg) throws AssertionError {
        long value;
        LLVMPointer currentPtr = ptr.increment(offset);
        if (arg instanceof Boolean) {
            value = (Boolean)arg != false ? 1L : 0L;
        } else if (arg instanceof Byte) {
            value = Integer.toUnsignedLong(((Byte)arg).byteValue());
        } else if (arg instanceof Short) {
            value = Integer.toUnsignedLong(((Short)arg).shortValue());
        } else if (arg instanceof Integer) {
            value = Integer.toUnsignedLong((Integer)arg);
        } else if (arg instanceof Long) {
            value = (Long)arg;
        } else if (arg instanceof Float) {
            value = Integer.toUnsignedLong(Float.floatToIntBits(((Float)arg).floatValue()));
        } else if (arg instanceof Double) {
            value = Double.doubleToRawLongBits((Double)arg);
        } else {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError(arg);
        }
        storeNode.executeWithTarget(currentPtr, value);
        return 8;
    }

    private static enum VarArgArea {
        GP_AREA,
        FP_AREA,
        OVERFLOW_AREA;

    }
}

