/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.utilities.AssumedValue;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.debug.LLDBSupport;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMDebugGlobalVariable;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugValue;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLDBBoxedPrimitive;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLDBConstant;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLDBGlobalConstant;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLDBMemoryValue;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLDBVector;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;

@GenerateUncached
public abstract class LLVMToDebugValueNode
extends LLVMNode
implements LLVMDebugValue.Builder {
    protected abstract LLVMDebugValue executeWithTarget(Object var1);

    @Override
    public LLVMDebugValue build(Object irValue) {
        return this.executeWithTarget(irValue);
    }

    @Specialization
    protected LLVMDebugValue fromBoolean(boolean value) {
        return new LLDBConstant.Integer(1L, value ? 1L : 0L);
    }

    @Specialization
    protected LLVMDebugValue fromByte(byte value) {
        return new LLDBConstant.Integer(8L, value);
    }

    @Specialization
    protected LLVMDebugValue fromShort(short value) {
        return new LLDBConstant.Integer(16L, value);
    }

    @Specialization
    protected LLVMDebugValue fromInt(int value) {
        return new LLDBConstant.Integer(32L, value);
    }

    @Specialization
    protected LLVMDebugValue fromLong(long value) {
        return new LLDBConstant.Integer(64L, value);
    }

    @Specialization
    protected LLVMDebugValue fromIVarBit(LLVMIVarBit value) {
        return new LLDBConstant.IVarBit(value);
    }

    @Specialization
    protected LLVMDebugValue fromNativePointer(LLVMNativePointer value) {
        return new LLDBConstant.Pointer(value);
    }

    @Specialization
    protected LLVMDebugValue fromManagedPointer(LLVMManagedPointer value) {
        Object target = value.getObject();
        if (target instanceof LLVMGlobalContainer) {
            return this.fromGlobalContainer((LLVMGlobalContainer)target);
        }
        try {
            InteropLibrary interop = (InteropLibrary)InteropLibrary.getFactory().getUncached();
            if (interop.isBoolean(target)) {
                return new LLDBBoxedPrimitive(interop.asBoolean(target));
            }
            if (interop.isNumber(target)) {
                Number unboxedValue;
                if (interop.fitsInByte(target)) {
                    unboxedValue = interop.asByte(target);
                } else if (interop.fitsInShort(target)) {
                    unboxedValue = interop.asShort(target);
                } else if (interop.fitsInInt(target)) {
                    unboxedValue = interop.asInt(target);
                } else if (interop.fitsInLong(target)) {
                    unboxedValue = interop.asLong(target);
                } else if (interop.fitsInFloat(target)) {
                    unboxedValue = Float.valueOf(interop.asFloat(target));
                } else if (interop.fitsInDouble(target)) {
                    unboxedValue = interop.asDouble(target);
                } else {
                    return LLVMDebugValue.UNAVAILABLE;
                }
                return new LLDBBoxedPrimitive(unboxedValue);
            }
        }
        catch (UnsupportedMessageException unsupportedMessageException) {
            // empty catch block
        }
        return new LLDBConstant.Pointer(value);
    }

    @Specialization
    protected LLVMDebugValue fromFunctionHandle(LLVMFunctionDescriptor value) {
        return new LLDBConstant.Function(value);
    }

    @Specialization
    protected LLVMDebugValue fromFloat(float value) {
        return new LLDBConstant.Float(value);
    }

    @Specialization
    protected LLVMDebugValue fromDouble(double value) {
        return new LLDBConstant.Double(value);
    }

    @Specialization
    protected LLVMDebugValue from80BitFloat(LLVM80BitFloat value) {
        return new LLDBConstant.BigFloat(value);
    }

    @Specialization
    protected LLVMDebugValue fromI1Vector(LLVMI1Vector value) {
        return new LLDBVector.I1(value);
    }

    @Specialization
    protected LLVMDebugValue fromI8Vector(LLVMI8Vector value) {
        return new LLDBVector.I8(value);
    }

    @Specialization
    protected LLVMDebugValue fromI16Vector(LLVMI16Vector value) {
        return new LLDBVector.I16(value);
    }

    @Specialization
    protected LLVMDebugValue fromI32Vector(LLVMI32Vector value) {
        return new LLDBVector.I32(value);
    }

    @Specialization
    protected LLVMDebugValue fromI64Vector(LLVMI64Vector value) {
        return new LLDBVector.I64(value);
    }

    @Specialization
    protected LLVMDebugValue fromFloatVector(LLVMFloatVector value) {
        return new LLDBVector.Float(value);
    }

    @Specialization
    protected LLVMDebugValue fromDoubleVector(LLVMDoubleVector value) {
        return new LLDBVector.Double(value);
    }

    @Specialization
    protected LLVMDebugValue fromAddressVector(LLVMPointerVector value) {
        return new LLDBVector.Address(value);
    }

    @Specialization
    protected LLVMDebugValue fromGlobalContainer(LLVMGlobalContainer value) {
        if (value.isPointer()) {
            return this.executeWithTarget(LLVMNativePointer.create(value.getAddress()));
        }
        Object target = value.get();
        if (LLVMPointer.isInstance(target)) {
            return this.executeWithTarget(target);
        }
        return this.executeWithTarget(LLVMManagedPointer.create(target));
    }

    @Specialization
    protected LLVMDebugValue fromGlobal(LLVMDebugGlobalVariable value) {
        int index;
        LLVMGlobal global = value.getDescriptor();
        LLVMContext context = value.getContext();
        AssumedValue<LLVMPointer>[] globals = context.findSymbolTable(global.getBitcodeID(false));
        Object target = globals[index = global.getSymbolIndex(false)].get();
        if (LLVMManagedPointer.isInstance(target)) {
            LLVMManagedPointer managedPointer = LLVMManagedPointer.cast(target);
            if (LLDBSupport.pointsToObjectAccess(LLVMManagedPointer.cast(target))) {
                return new LLDBMemoryValue(managedPointer);
            }
        } else if (!LLVMPointer.isInstance(target)) {
            return this.executeWithTarget(target);
        }
        return new LLDBGlobalConstant(global, context);
    }

    @Fallback
    protected LLVMDebugValue fromGenericObject(Object value) {
        return LLVMDebugValue.UNAVAILABLE;
    }
}

