/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.bit;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.bit.CountTrailingZeroesNode;

@GeneratedBy(value=CountTrailingZeroesNode.class)
public final class CountTrailingZeroesNodeFactory {

    @GeneratedBy(value=CountTrailingZeroesNode.CountTrailingZeroesI64Node.class)
    public static final class CountTrailingZeroesI64NodeGen
    extends CountTrailingZeroesNode.CountTrailingZeroesI64Node {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private CountTrailingZeroesI64NodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            boolean child1Value_;
            long child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (state != 0) {
                return this.doI64(child0Value_, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) {
            boolean child1Value_;
            long child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (state != 0) {
                return this.doI64(child0Value_, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private long executeAndSpecialize(Object child0Value, Object child1Value) {
            int state = this.state_;
            if (child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                if (child1Value instanceof Boolean) {
                    boolean child1Value_ = (Boolean)child1Value;
                    this.state_ = state |= 1;
                    return this.doI64(child0Value_, child1Value_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static CountTrailingZeroesNode.CountTrailingZeroesI64Node create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new CountTrailingZeroesI64NodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=CountTrailingZeroesNode.CountTrailingZeroesI32Node.class)
    public static final class CountTrailingZeroesI32NodeGen
    extends CountTrailingZeroesNode.CountTrailingZeroesI32Node {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private CountTrailingZeroesI32NodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            boolean child1Value_;
            int child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (state != 0) {
                return this.doI32(child0Value_, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            boolean child1Value_;
            int child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (state != 0) {
                return this.doI32(child0Value_, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private int executeAndSpecialize(Object child0Value, Object child1Value) {
            int state = this.state_;
            if (child0Value instanceof Integer) {
                int child0Value_ = (Integer)child0Value;
                if (child1Value instanceof Boolean) {
                    boolean child1Value_ = (Boolean)child1Value;
                    this.state_ = state |= 1;
                    return this.doI32(child0Value_, child1Value_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static CountTrailingZeroesNode.CountTrailingZeroesI32Node create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new CountTrailingZeroesI32NodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=CountTrailingZeroesNode.CountTrailingZeroesI16Node.class)
    public static final class CountTrailingZeroesI16NodeGen
    extends CountTrailingZeroesNode.CountTrailingZeroesI16Node {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private CountTrailingZeroesI16NodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            boolean child1Value_;
            short child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (state != 0) {
                return this.doI16(child0Value_, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        @Override
        public short executeI16(VirtualFrame frameValue) {
            boolean child1Value_;
            short child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (state != 0) {
                return this.doI16(child0Value_, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private short executeAndSpecialize(Object child0Value, Object child1Value) {
            int state = this.state_;
            if (child0Value instanceof Short) {
                short child0Value_ = (Short)child0Value;
                if (child1Value instanceof Boolean) {
                    boolean child1Value_ = (Boolean)child1Value;
                    this.state_ = state |= 1;
                    return this.doI16(child0Value_, child1Value_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static CountTrailingZeroesNode.CountTrailingZeroesI16Node create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new CountTrailingZeroesI16NodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=CountTrailingZeroesNode.CountTrailingZeroesI8Node.class)
    public static final class CountTrailingZeroesI8NodeGen
    extends CountTrailingZeroesNode.CountTrailingZeroesI8Node {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private CountTrailingZeroesI8NodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            boolean child1Value_;
            byte child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (state != 0) {
                return this.doI8(child0Value_, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) {
            boolean child1Value_;
            byte child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (state != 0) {
                return this.doI8(child0Value_, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private byte executeAndSpecialize(Object child0Value, Object child1Value) {
            int state = this.state_;
            if (child0Value instanceof Byte) {
                byte child0Value_ = (Byte)child0Value;
                if (child1Value instanceof Boolean) {
                    boolean child1Value_ = (Boolean)child1Value;
                    this.state_ = state |= 1;
                    return this.doI8(child0Value_, child1Value_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static CountTrailingZeroesNode.CountTrailingZeroesI8Node create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new CountTrailingZeroesI8NodeGen(child0, child1);
        }
    }
}

