/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMDoubleStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMDoubleStoreNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChildren(value={@NodeChild(value="result", type=LLVMExpressionNode.class), @NodeChild(value="a", type=LLVMExpressionNode.class), @NodeChild(value="b", type=LLVMExpressionNode.class), @NodeChild(value="c", type=LLVMExpressionNode.class), @NodeChild(value="d", type=LLVMExpressionNode.class)})
public abstract class LLVMComplexDoubleDiv
extends LLVMExpressionNode {
    @Node.Child
    private LLVMDoubleStoreNode store = LLVMDoubleStoreNodeGen.create(null, null);

    @Specialization
    public Object doDouble(LLVMPointer result, double a, double b, double c, double d) {
        double denom = c * c + d * d;
        double zReal = (a * c + b * d) / denom;
        double zImag = (b * c - a * d) / denom;
        this.store.executeWithTarget(result, zReal);
        this.store.executeWithTarget(result.increment(8L), zImag);
        return result;
    }
}

