/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMBuiltin;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMArithmetic {
    public static final CarryArithmetic CARRY_ADD = new CarryArithmetic(){

        @Override
        public byte evalI8(byte left, byte right, byte cin, Object addr, LLVMStoreNode store) {
            int res = (left & 0xFF) + (right & 0xFF) + (cin & 0xFF);
            boolean overflow = (res & 0xF00) != 0;
            store.executeWithTarget(addr, overflow ? (byte)1 : 0);
            return (byte)res;
        }

        @Override
        public short evalI16(short left, short right, short cin, Object addr, LLVMStoreNode store) {
            int res = (left & 0xFFFF) + (right & 0xFFFF) + (cin & 0xFFFF);
            boolean overflow = (res & 0xF0000) != 0;
            store.executeWithTarget(addr, overflow ? (byte)1 : 0);
            return (short)res;
        }

        @Override
        public int evalI32(int left, int right, int cin, Object addr, LLVMStoreNode store) {
            int res1 = left + right;
            boolean overflow1 = (~res1 & left | ~res1 & right | left & right) < 0;
            int res2 = res1 + cin;
            boolean overflow2 = (~res2 & res1 | ~res2 & cin | res1 & cin) < 0;
            store.executeWithTarget(addr, overflow1 | overflow2 ? 1 : 0);
            return res2;
        }

        @Override
        public long evalI64(long left, long right, long cin, Object addr, LLVMStoreNode store) {
            long res1 = left + right;
            boolean overflow1 = ((res1 ^ 0xFFFFFFFFFFFFFFFFL) & left | (res1 ^ 0xFFFFFFFFFFFFFFFFL) & right | left & right) < 0L;
            long res2 = res1 + cin;
            boolean overflow2 = ((res2 ^ 0xFFFFFFFFFFFFFFFFL) & res1 | (res2 ^ 0xFFFFFFFFFFFFFFFFL) & cin | res1 & cin) < 0L;
            store.executeWithTarget(addr, overflow1 | overflow2 ? 1 : 0);
            return res2;
        }
    };
    public static final CarryArithmetic CARRY_SUB = new CarryArithmetic(){

        @Override
        public byte evalI8(byte left, byte right, byte cin, Object addr, LLVMStoreNode store) {
            int res = (left & 0xFF) - (right & 0xFF) - (cin & 0xFF);
            boolean overflow = res < 0;
            store.executeWithTarget(addr, overflow ? (byte)1 : 0);
            return (byte)res;
        }

        @Override
        public short evalI16(short left, short right, short cin, Object addr, LLVMStoreNode store) {
            int res = (left & 0xFFFF) - (right & 0xFFFF) - (cin & 0xFFFF);
            boolean overflow = res < 0;
            store.executeWithTarget(addr, overflow ? (byte)1 : 0);
            return (short)res;
        }

        @Override
        public int evalI32(int left, int right, int cin, Object addr, LLVMStoreNode store) {
            int res1 = left - right;
            boolean overflow1 = Integer.compareUnsigned(left, right) < 0;
            int res2 = res1 - cin;
            boolean overflow2 = Integer.compareUnsigned(res1, cin) < 0;
            store.executeWithTarget(addr, overflow1 | overflow2 ? 1 : 0);
            return res2;
        }

        @Override
        public long evalI64(long left, long right, long cin, Object addr, LLVMStoreNode store) {
            long res1 = left - right;
            boolean overflow1 = Long.compareUnsigned(left, right) < 0;
            long res2 = res1 - cin;
            boolean overflow2 = Long.compareUnsigned(res1, cin) < 0;
            store.executeWithTarget(addr, overflow1 | overflow2 ? 1 : 0);
            return res2;
        }
    };
    public static final Arithmetic SIGNED_ADD = new Arithmetic(){

        @Override
        public boolean evalI8(byte left, byte right, Object addr, LLVMStoreNode store) {
            int res = left + right;
            boolean overflow = ((res ^ left) & (res ^ right) & 0x80) != 0;
            store.executeWithTarget(addr, (byte)res);
            return overflow;
        }

        @Override
        public boolean evalI16(short left, short right, Object addr, LLVMStoreNode store) {
            int res = left + right;
            boolean overflow = ((res ^ left) & (res ^ right) & 0x8000) != 0;
            store.executeWithTarget(addr, (short)res);
            return overflow;
        }

        @Override
        public boolean evalI32(int left, int right, Object addr, LLVMStoreNode store) {
            int res;
            boolean overflow = false;
            try {
                res = Math.addExact(left, right);
            }
            catch (ArithmeticException e) {
                res = left + right;
                overflow = true;
            }
            store.executeWithTarget(addr, res);
            return overflow;
        }

        @Override
        public boolean evalI64(long left, long right, Object addr, LLVMStoreNode store) {
            long res;
            boolean overflow = false;
            try {
                res = Math.addExact(left, right);
            }
            catch (ArithmeticException e) {
                res = left + right;
                overflow = true;
            }
            store.executeWithTarget(addr, res);
            return overflow;
        }
    };
    public static final Arithmetic UNSIGNED_ADD = new Arithmetic(){

        @Override
        public boolean evalI8(byte left, byte right, Object addr, LLVMStoreNode store) {
            int res = (left & 0xFF) + (right & 0xFF);
            boolean overflow = (res & 0x100) != 0;
            store.executeWithTarget(addr, (byte)res);
            return overflow;
        }

        @Override
        public boolean evalI16(short left, short right, Object addr, LLVMStoreNode store) {
            int res = (left & 0xFFFF) + (right & 0xFFFF);
            boolean overflow = (res & 0x10000) != 0;
            store.executeWithTarget(addr, (short)res);
            return overflow;
        }

        @Override
        public boolean evalI32(int left, int right, Object addr, LLVMStoreNode store) {
            int res = left + right;
            boolean overflow = (~res & left | ~res & right | left & right) < 0;
            store.executeWithTarget(addr, res);
            return overflow;
        }

        @Override
        public boolean evalI64(long left, long right, Object addr, LLVMStoreNode store) {
            long res = left + right;
            boolean overflow = ((res ^ 0xFFFFFFFFFFFFFFFFL) & left | (res ^ 0xFFFFFFFFFFFFFFFFL) & right | left & right) < 0L;
            store.executeWithTarget(addr, res);
            return overflow;
        }
    };
    public static final Arithmetic SIGNED_SUB = new Arithmetic(){

        @Override
        public boolean evalI8(byte left, byte right, Object addr, LLVMStoreNode store) {
            int res = left - right;
            boolean overflow = ((left ^ right) & (left ^ res) & 0x80) != 0;
            store.executeWithTarget(addr, (byte)res);
            return overflow;
        }

        @Override
        public boolean evalI16(short left, short right, Object addr, LLVMStoreNode store) {
            int res = left - right;
            boolean overflow = ((left ^ right) & (left ^ res) & 0x8000) != 0;
            store.executeWithTarget(addr, (short)res);
            return overflow;
        }

        @Override
        public boolean evalI32(int left, int right, Object addr, LLVMStoreNode store) {
            int res;
            boolean overflow = false;
            try {
                res = Math.subtractExact(left, right);
            }
            catch (ArithmeticException e) {
                res = left - right;
                overflow = true;
            }
            store.executeWithTarget(addr, res);
            return overflow;
        }

        @Override
        public boolean evalI64(long left, long right, Object addr, LLVMStoreNode store) {
            long res;
            boolean overflow = false;
            try {
                res = Math.subtractExact(left, right);
            }
            catch (ArithmeticException e) {
                res = left - right;
                overflow = true;
            }
            store.executeWithTarget(addr, res);
            return overflow;
        }
    };
    public static final Arithmetic UNSIGNED_SUB = new Arithmetic(){

        @Override
        public boolean evalI8(byte left, byte right, Object addr, LLVMStoreNode store) {
            int res = (left & 0xFF) - (right & 0xFF);
            boolean overflow = res < 0;
            store.executeWithTarget(addr, (byte)res);
            return overflow;
        }

        @Override
        public boolean evalI16(short left, short right, Object addr, LLVMStoreNode store) {
            int res = (left & 0xFFFF) - (right & 0xFFFF);
            boolean overflow = res < 0;
            store.executeWithTarget(addr, (short)res);
            return overflow;
        }

        @Override
        public boolean evalI32(int left, int right, Object addr, LLVMStoreNode store) {
            int res = left - right;
            boolean overflow = Integer.compareUnsigned(left, right) < 0;
            store.executeWithTarget(addr, res);
            return overflow;
        }

        @Override
        public boolean evalI64(long left, long right, Object addr, LLVMStoreNode store) {
            long res = left - right;
            boolean overflow = Long.compareUnsigned(left, right) < 0;
            store.executeWithTarget(addr, res);
            return overflow;
        }
    };
    public static final Arithmetic SIGNED_MUL = new Arithmetic(){

        @Override
        public boolean evalI8(byte left, byte right, Object addr, LLVMStoreNode store) {
            int res = left * right;
            boolean overflow = (byte)res != res;
            store.executeWithTarget(addr, (byte)res);
            return overflow;
        }

        @Override
        public boolean evalI16(short left, short right, Object addr, LLVMStoreNode store) {
            int res = left * right;
            boolean overflow = (short)res != res;
            store.executeWithTarget(addr, (short)res);
            return overflow;
        }

        @Override
        public boolean evalI32(int left, int right, Object addr, LLVMStoreNode store) {
            int res;
            boolean overflow = false;
            try {
                res = Math.multiplyExact(left, right);
            }
            catch (ArithmeticException e) {
                res = left * right;
                overflow = true;
            }
            store.executeWithTarget(addr, res);
            return overflow;
        }

        @Override
        public boolean evalI64(long left, long right, Object addr, LLVMStoreNode store) {
            long res;
            boolean overflow = false;
            try {
                res = Math.multiplyExact(left, right);
            }
            catch (ArithmeticException e) {
                res = left * right;
                overflow = true;
            }
            store.executeWithTarget(addr, res);
            return overflow;
        }
    };
    public static final Arithmetic UNSIGNED_MUL = new Arithmetic(){

        @Override
        public boolean evalI8(byte left, byte right, Object addr, LLVMStoreNode store) {
            int res = (left & 0xFF) * (right & 0xFF);
            boolean overflow = (res & 0xFF) != res;
            store.executeWithTarget(addr, (byte)res);
            return overflow;
        }

        @Override
        public boolean evalI16(short left, short right, Object addr, LLVMStoreNode store) {
            int res = (left & 0xFFFF) * (right & 0xFFFF);
            boolean overflow = (res & 0xFFFF) != res;
            store.executeWithTarget(addr, (short)res);
            return overflow;
        }

        @Override
        public boolean evalI32(int left, int right, Object addr, LLVMStoreNode store) {
            long res = ((long)left & 0xFFFFFFFFL) * ((long)right & 0xFFFFFFFFL);
            boolean overflow = (res & 0xFFFFFFFFL) != res;
            store.executeWithTarget(addr, (int)res);
            return overflow;
        }

        @Override
        public boolean evalI64(long left, long right, Object addr, LLVMStoreNode store) {
            long res = left * right;
            boolean overflow = false;
            if ((left | right) >>> 31 != 0L && right != 0L && Long.divideUnsigned(res, right) != left) {
                overflow = true;
            }
            store.executeWithTarget(addr, res);
            return overflow;
        }
    };

    private LLVMArithmetic() {
    }

    @NodeChildren(value={@NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class), @NodeChild(value="cin", type=LLVMExpressionNode.class), @NodeChild(value="cout", type=LLVMExpressionNode.class)})
    public static abstract class LLVMArithmeticWithOverflowAndCarry
    extends LLVMBuiltin {
        private final CarryArithmetic arithmetic;

        public LLVMArithmeticWithOverflowAndCarry(CarryArithmetic arithmetic) {
            this.arithmetic = arithmetic;
        }

        @Specialization
        protected byte doIntrinsic(byte left, byte right, byte cin, Object addr, @Cached(value="createStoreI8()") LLVMStoreNode store) {
            return this.arithmetic.evalI8(left, right, cin, addr, store);
        }

        @Specialization
        protected short doIntrinsic(short left, short right, short cin, Object addr, @Cached(value="createStoreI16()") LLVMStoreNode store) {
            return this.arithmetic.evalI16(left, right, cin, addr, store);
        }

        @Specialization
        protected int doIntrinsic(int left, int right, int cin, Object addr, @Cached(value="createStoreI32()") LLVMStoreNode store) {
            return this.arithmetic.evalI32(left, right, cin, addr, store);
        }

        @Specialization
        protected long doIntrinsic(long left, long right, long cin, Object addr, @Cached(value="createStoreI64()") LLVMStoreNode store) {
            return this.arithmetic.evalI64(left, right, cin, addr, store);
        }
    }

    @NodeChildren(value={@NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class), @NodeChild(value="target", type=LLVMExpressionNode.class)})
    public static abstract class LLVMArithmeticWithOverflow
    extends LLVMBuiltin {
        private final long secondValueOffset;
        private final Arithmetic arithmetic;
        @Node.Child
        private LLVMStoreNode storeI8 = LLVMArithmeticWithOverflow.createStoreI1();

        public LLVMArithmeticWithOverflow(Arithmetic arithmetic, long secondValueOffset) {
            this.secondValueOffset = secondValueOffset;
            this.arithmetic = arithmetic;
        }

        @Specialization
        protected Object doIntrinsic(byte left, byte right, LLVMPointer addr, @Cached(value="createStoreI8()") LLVMStoreNode store) {
            boolean overflow = this.arithmetic.evalI8(left, right, addr, store);
            this.storeI8.executeWithTarget(addr.increment(this.secondValueOffset), overflow);
            return addr;
        }

        @Specialization
        protected Object doIntrinsic(short left, short right, LLVMPointer addr, @Cached(value="createStoreI16()") LLVMStoreNode store) {
            boolean overflow = this.arithmetic.evalI16(left, right, addr, store);
            this.storeI8.executeWithTarget(addr.increment(this.secondValueOffset), overflow);
            return addr;
        }

        @Specialization
        protected Object doIntrinsic(int left, int right, LLVMPointer addr, @Cached(value="createStoreI32()") LLVMStoreNode store) {
            boolean overflow = this.arithmetic.evalI32(left, right, addr, store);
            this.storeI8.executeWithTarget(addr.increment(this.secondValueOffset), overflow);
            return addr;
        }

        @Specialization
        protected Object doIntrinsic(long left, long right, LLVMPointer addr, @Cached(value="createStoreI64()") LLVMStoreNode store) {
            boolean overflow = this.arithmetic.evalI64(left, right, addr, store);
            this.storeI8.executeWithTarget(addr.increment(this.secondValueOffset), overflow);
            return addr;
        }
    }

    @NodeChildren(value={@NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class), @NodeChild(value="target", type=LLVMExpressionNode.class)})
    public static abstract class GCCArithmetic
    extends LLVMBuiltin {
        private final Arithmetic arithmetic;

        public GCCArithmetic(Arithmetic arithmetic) {
            this.arithmetic = arithmetic;
        }

        @Specialization
        protected byte doIntrinsic(byte left, byte right, Object addr, @Cached(value="createStoreI8()") LLVMStoreNode store) {
            return this.arithmetic.evalI8(left, right, addr, store) ? (byte)1 : 0;
        }

        @Specialization
        protected short doIntrinsic(short left, short right, Object addr, @Cached(value="createStoreI16()") LLVMStoreNode store) {
            return this.arithmetic.evalI16(left, right, addr, store) ? (byte)1 : 0;
        }

        @Specialization
        protected int doIntrinsic(int left, int right, Object addr, @Cached(value="createStoreI32()") LLVMStoreNode store) {
            return this.arithmetic.evalI32(left, right, addr, store) ? 1 : 0;
        }

        @Specialization
        protected long doIntrinsic(long left, long right, Object addr, @Cached(value="createStoreI64()") LLVMStoreNode store) {
            return this.arithmetic.evalI64(left, right, addr, store) ? 1L : 0L;
        }
    }

    public static interface CarryArithmetic {
        public byte evalI8(byte var1, byte var2, byte var3, Object var4, LLVMStoreNode var5);

        public short evalI16(short var1, short var2, short var3, Object var4, LLVMStoreNode var5);

        public int evalI32(int var1, int var2, int var3, Object var4, LLVMStoreNode var5);

        public long evalI64(long var1, long var3, long var5, Object var7, LLVMStoreNode var8);
    }

    public static interface Arithmetic {
        public boolean evalI8(byte var1, byte var2, Object var3, LLVMStoreNode var4);

        public boolean evalI16(short var1, short var2, Object var3, LLVMStoreNode var4);

        public boolean evalI32(int var1, int var2, Object var3, LLVMStoreNode var4);

        public boolean evalI64(long var1, long var3, Object var5, LLVMStoreNode var6);
    }
}

