/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMReturnAddress;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@GeneratedBy(value=LLVMReturnAddress.class)
public final class LLVMReturnAddressNodeGen
extends LLVMReturnAddress {
    private LLVMSourceLocation sourceLocation;
    private boolean statement;
    @Node.Child
    private LLVMExpressionNode val_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private LLVMReturnAddressNodeGen(LLVMExpressionNode val) {
        this.val_ = val;
    }

    @Override
    public LLVMSourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    protected boolean isStatement() {
        return this.statement;
    }

    @Override
    protected void setStatement(boolean statement) {
        this.statement = statement;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int valValue_;
        int state = this.state_;
        try {
            valValue_ = this.val_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        if (state != 0) {
            return this.doPointee(valValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(valValue_);
    }

    private LLVMNativePointer executeAndSpecialize(Object valValue) {
        int state = this.state_;
        if (valValue instanceof Integer) {
            int valValue_ = (Integer)valValue;
            this.state_ = state |= 1;
            return this.doPointee(valValue_);
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.val_}, new Object[]{valValue});
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public static LLVMReturnAddress create(LLVMExpressionNode val) {
        return new LLVMReturnAddressNodeGen(val);
    }
}

