/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMBuiltin;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;

public abstract class LLVMByteSwap {

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMByteSwapI64Vector
    extends LLVMBuiltin {
        private final int vectorLen;

        protected LLVMByteSwapI64Vector(int vectorLen) {
            this.vectorLen = vectorLen;
        }

        @ExplodeLoop
        @Specialization
        protected LLVMI64Vector doI64Vector(LLVMI64Vector vector) {
            long[] result = new long[this.vectorLen];
            for (int i = 0; i < this.vectorLen; ++i) {
                result[i] = Long.reverseBytes(vector.getValue(i));
            }
            return LLVMI64Vector.create(result);
        }

        @ExplodeLoop
        @Specialization
        protected LLVMI64Vector doPointerVector(LLVMPointerVector vector, @Cached(value="createToNativeNodes()") LLVMToNativeNode[] toNative) {
            long[] result = new long[this.vectorLen];
            for (int i = 0; i < this.vectorLen; ++i) {
                long value = toNative[i].executeWithTarget(vector.getValue(i)).asNative();
                result[i] = Long.reverseBytes(value);
            }
            return LLVMI64Vector.create(result);
        }

        @CompilerDirectives.TruffleBoundary
        protected LLVMToNativeNode[] createToNativeNodes() {
            LLVMToNativeNode[] result = new LLVMToNativeNode[this.vectorLen];
            for (int i = 0; i < result.length; ++i) {
                result[i] = LLVMToNativeNode.createToNativeWithTarget();
            }
            return result;
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMByteSwapI32Vector
    extends LLVMBuiltin {
        private final int vectorLen;

        protected LLVMByteSwapI32Vector(int vectorLen) {
            this.vectorLen = vectorLen;
        }

        @ExplodeLoop
        @Specialization
        protected LLVMI32Vector doI32Vector(LLVMI32Vector vector) {
            int[] result = new int[this.vectorLen];
            for (int i = 0; i < this.vectorLen; ++i) {
                result[i] = Integer.reverseBytes(vector.getValue(i));
            }
            return LLVMI32Vector.create(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMByteSwapI16Vector
    extends LLVMBuiltin {
        private final int vectorLen;

        protected LLVMByteSwapI16Vector(int vectorLen) {
            this.vectorLen = vectorLen;
        }

        @ExplodeLoop
        @Specialization
        protected LLVMI16Vector doI16Vector(LLVMI16Vector vector) {
            short[] result = new short[this.vectorLen];
            for (int i = 0; i < this.vectorLen; ++i) {
                result[i] = Short.reverseBytes(vector.getValue(i));
            }
            return LLVMI16Vector.create(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMByteSwapI64
    extends LLVMBuiltin {
        @Specialization
        protected long doI64(long value) {
            return Long.reverseBytes(value);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMByteSwapI32
    extends LLVMBuiltin {
        @Specialization
        protected int doI32(int value) {
            return Integer.reverseBytes(value);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMByteSwapI16
    extends LLVMBuiltin {
        @Specialization
        protected short doI16(short value) {
            return Short.reverseBytes(value);
        }
    }
}

