/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.memory.LLVMNativeMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@NodeChild(type=LLVMExpressionNode.class)
public abstract class LLVMTruffleReleaseHandle
extends LLVMIntrinsic {
    @CompilerDirectives.TruffleBoundary
    @Specialization
    protected Object doIntrinsic(LLVMNativePointer handle, @CachedContext(value=LLVMLanguage.class) LLVMContext context, @CachedLanguage LLVMLanguage language) {
        long address = handle.asNative();
        if (!language.getNoDerefHandleAssumption().isValid() && LLVMNativeMemory.isDerefHandleMemory(address)) {
            context.getDerefHandleContainer().free(this, address);
        } else {
            context.getHandleContainer().free(this, address);
        }
        return null;
    }

    @Fallback
    protected Object doFail(Object handle) {
        CompilerDirectives.transferToInterpreter();
        throw new UnsupportedOperationException(handle + " not supported.");
    }
}

