/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMReadStringNode.class)
public final class LLVMReadStringNodeGen
extends LLVMReadStringNode {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<LLVMAsForeignLibrary> L_L_V_M_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @Node.Child
    private LLVMAsForeignLibrary readForeign_foreigns_;
    @Node.Child
    private LLVMReadStringNode.ForeignReadStringNode readForeign_read_;

    private LLVMReadStringNodeGen() {
    }

    private boolean fallbackGuard_(int state, Object arg0Value) {
        if ((state & 1) == 0 && arg0Value instanceof String) {
            return false;
        }
        if (LLVMTypes.isManagedPointer(arg0Value)) {
            LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
            if (LLVMReadStringNode.isString(arg0Value_)) {
                return false;
            }
            arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
            if ((state & 8) == 0 || this.readForeign_foreigns_.isForeign(arg0Value_)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String executeWithTarget(Object arg0Value) {
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof String) {
            String arg0Value_ = (String)arg0Value;
            return this.readString(arg0Value_);
        }
        if ((state & 6) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
            LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
            if ((state & 2) != 0 && LLVMReadStringNode.isString(arg0Value_)) {
                return this.readString(arg0Value_);
            }
            if ((state & 4) != 0 && this.readForeign_foreigns_.isForeign(arg0Value_)) {
                return this.readForeign(arg0Value_, this.readForeign_foreigns_, this.readForeign_read_);
            }
        }
        if ((state & 0x10) != 0 && this.fallbackGuard_(state, arg0Value)) {
            return this.readOther(arg0Value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (arg0Value instanceof String) {
                String arg0Value_ = (String)arg0Value;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                String string = this.readString(arg0Value_);
                return string;
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if (LLVMReadStringNode.isString(arg0Value_)) {
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    String string = this.readString(arg0Value_);
                    return string;
                }
                if ((state & 8) == 0) {
                    this.readForeign_foreigns_ = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3));
                    this.state_ = state |= 8;
                }
                if (this.readForeign_foreigns_.isForeign(arg0Value_)) {
                    this.readForeign_foreigns_ = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3));
                    this.readForeign_read_ = (LLVMReadStringNode.ForeignReadStringNode)super.insert((Node)LLVMReadStringNode.ForeignReadStringNode.create());
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    String string = this.readForeign(arg0Value_, this.readForeign_foreigns_, this.readForeign_read_);
                    return string;
                }
            }
            this.state_ = state |= 0x10;
            lock.unlock();
            hasLock = false;
            String string = this.readOther(arg0Value);
            return string;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0x17) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x17 & (state & 0x17) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMReadStringNode create() {
        return new LLVMReadStringNodeGen();
    }

    @GeneratedBy(value=LLVMReadStringNode.PointerReadStringNode.class)
    static final class PointerReadStringNodeGen
    extends LLVMReadStringNode.PointerReadStringNode {
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private CachedPointerData cachedPointer_cache;

        private PointerReadStringNodeGen() {
        }

        @Override
        @ExplodeLoop
        protected String execute(Object arg0Value) {
            int state = this.state_;
            if (state != 0 && LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                if ((state & 1) != 0) {
                    CachedPointerData s1_ = this.cachedPointer_cache;
                    while (s1_ != null) {
                        if (s1_.cachedAddress_.isSame(arg0Value_)) {
                            assert (this.isReadOnlyMemory(s1_.cachedAddress_));
                            return this.doCachedPointer(arg0Value_, s1_.cachedAddress_, s1_.result_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.doReadString(arg0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value);
        }

        private String executeAndSpecialize(Object arg0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if (LLVMTypes.isPointer(arg0Value)) {
                    LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                    if (exclude == 0) {
                        LLVMPointer cachedAddress__;
                        int count1_ = 0;
                        CachedPointerData s1_ = this.cachedPointer_cache;
                        if ((state & 1) != 0) {
                            while (s1_ != null) {
                                if (s1_.cachedAddress_.isSame(arg0Value_)) {
                                    assert (this.isReadOnlyMemory(s1_.cachedAddress_));
                                    break;
                                }
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && (cachedAddress__ = arg0Value_).isSame(arg0Value_) && this.isReadOnlyMemory(cachedAddress__) && count1_ < 3) {
                            s1_ = new CachedPointerData(this.cachedPointer_cache);
                            s1_.cachedAddress_ = cachedAddress__;
                            s1_.result_ = this.doReadString(cachedAddress__);
                            this.cachedPointer_cache = s1_;
                            this.state_ = state |= 1;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            String string = this.doCachedPointer(arg0Value_, s1_.cachedAddress_, s1_.result_);
                            return string;
                        }
                    }
                    this.exclude_ = exclude |= 1;
                    this.cachedPointer_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    String string = this.doReadString(arg0Value_);
                    return string;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            CachedPointerData s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.cachedPointer_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMReadStringNode.PointerReadStringNode create() {
            return new PointerReadStringNodeGen();
        }

        @GeneratedBy(value=LLVMReadStringNode.PointerReadStringNode.class)
        private static final class CachedPointerData {
            @CompilerDirectives.CompilationFinal
            CachedPointerData next_;
            @CompilerDirectives.CompilationFinal
            LLVMPointer cachedAddress_;
            @CompilerDirectives.CompilationFinal
            String result_;

            CachedPointerData(CachedPointerData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=LLVMReadStringNode.ForeignReadStringNode.class)
    static final class ForeignReadStringNodeGen
    extends LLVMReadStringNode.ForeignReadStringNode {
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private Default0Data default0_cache;
        @Node.Child
        private LLVMReadStringNode.PointerReadStringNode default1_read_;

        private ForeignReadStringNodeGen() {
        }

        @Override
        @ExplodeLoop
        protected String execute(LLVMManagedPointer arg0Value, Object arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0) {
                    Default0Data s1_ = this.default0_cache;
                    while (s1_ != null) {
                        if (s1_.interop_.accepts(arg1Value)) {
                            return this.doDefault(arg0Value, arg1Value, s1_.interop_, s1_.read_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.default1Boundary(state, arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private String default1Boundary(int state, LLVMManagedPointer arg0Value, Object arg1Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary default1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value);
                String string = this.doDefault(arg0Value, arg1Value, default1_interop__, this.default1_read_);
                return string;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String executeAndSpecialize(LLVMManagedPointer arg0Value, Object arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                String string;
                if (exclude == 0) {
                    int count1_ = 0;
                    Default0Data s1_ = this.default0_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && !s1_.interop_.accepts(arg1Value)) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 3) {
                        s1_ = (Default0Data)super.insert((Node)new Default0Data(this.default0_cache));
                        s1_.interop_ = (InteropLibrary)s1_.insertAccessor(INTEROP_LIBRARY_.create(arg1Value));
                        s1_.read_ = s1_.insertAccessor(LLVMReadStringNode.PointerReadStringNode.create());
                        this.default0_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        String string2 = this.doDefault(arg0Value, arg1Value, s1_.interop_, s1_.read_);
                        return string2;
                    }
                }
                InteropLibrary default1_interop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    default1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value);
                    this.default1_read_ = (LLVMReadStringNode.PointerReadStringNode)super.insert((Node)LLVMReadStringNode.PointerReadStringNode.create());
                    this.exclude_ = exclude |= 1;
                    this.default0_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    string = this.doDefault(arg0Value, arg1Value, default1_interop__, this.default1_read_);
                }
                catch (Throwable throwable) {
                    encapsulating_.set(prev_);
                    throw throwable;
                }
                encapsulating_.set(prev_);
                return string;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            Default0Data s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.default0_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMReadStringNode.ForeignReadStringNode create() {
            return new ForeignReadStringNodeGen();
        }

        @GeneratedBy(value=LLVMReadStringNode.ForeignReadStringNode.class)
        private static final class Default0Data
        extends Node {
            @Node.Child
            Default0Data next_;
            @Node.Child
            InteropLibrary interop_;
            @Node.Child
            LLVMReadStringNode.PointerReadStringNode read_;

            Default0Data(Default0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }
}

