/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;

public abstract class LLVMPolyglotRead
extends LLVMIntrinsic {

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMPolyglotGetArrayElement
    extends LLVMPolyglotRead {
        @Node.Child
        protected ForeignToLLVM toLLVM;

        public LLVMPolyglotGetArrayElement(ForeignToLLVM toLLVM) {
            this.toLLVM = toLLVM;
        }

        @Specialization
        protected Object doIntrinsic(LLVMManagedPointer value, int id, @Cached LLVMAsForeignNode asForeign, @CachedLibrary(limit="3") InteropLibrary foreignRead, @Cached BranchProfile exception) {
            Object foreign = asForeign.execute(value);
            try {
                Object rawValue = foreignRead.readArrayElement(foreign, (long)id);
                return this.toLLVM.executeWithTarget(rawValue);
            }
            catch (UnsupportedMessageException e) {
                exception.enter();
                throw new LLVMPolyglotException((Node)foreignRead, "Can not read from index %d of polyglot value.", id);
            }
            catch (InvalidArrayIndexException e) {
                exception.enter();
                throw new LLVMPolyglotException((Node)foreignRead, "Index %d does not exist.", id);
            }
        }

        @CompilerDirectives.TruffleBoundary
        @Fallback
        public Object fallback(Object value, Object id) {
            throw new LLVMPolyglotException(this, "Invalid argument to polyglot builtin.");
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMPolyglotGetMember
    extends LLVMPolyglotRead {
        @Node.Child
        protected ForeignToLLVM toLLVM;

        public LLVMPolyglotGetMember(ForeignToLLVM toLLVM) {
            this.toLLVM = toLLVM;
        }

        @Specialization
        protected Object uncached(LLVMManagedPointer value, Object id, @Cached LLVMAsForeignNode asForeign, @Cached(value="createReadString()") LLVMReadStringNode readStr, @CachedLibrary(limit="3") InteropLibrary foreignRead, @Cached BranchProfile exception) {
            Object foreign = asForeign.execute(value);
            String name = readStr.executeWithTarget(id);
            try {
                Object rawValue = foreignRead.readMember(foreign, name);
                return this.toLLVM.executeWithTarget(rawValue);
            }
            catch (UnsupportedMessageException e) {
                exception.enter();
                throw new LLVMPolyglotException((Node)foreignRead, "Can not read member '%s' of polyglot value.", name);
            }
            catch (UnknownIdentifierException e) {
                exception.enter();
                throw new LLVMPolyglotException((Node)foreignRead, "Member '%s' does not exist.", e.getUnknownIdentifier());
            }
        }

        @Fallback
        public Object fallback(Object value, Object id) {
            throw new LLVMPolyglotException(this, "Invalid argument to polyglot builtin.");
        }
    }
}

