/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;

@NodeChild(type=LLVMExpressionNode.class)
public abstract class LLVMPolyglotGetStringSize
extends LLVMIntrinsic {
    @Specialization
    long getForeignStringSize(LLVMManagedPointer object, @Cached LLVMAsForeignNode asForeign, @Cached BoxedGetStringSize getSize) {
        return getSize.execute(asForeign.execute(object));
    }

    @Specialization
    long getStringSize(String str) {
        return str.length();
    }

    @Fallback
    public long fallback(Object value) {
        throw new LLVMPolyglotException(this, "Invalid argument to polyglot builtin.");
    }

    static abstract class BoxedGetStringSize
    extends LLVMNode {
        BoxedGetStringSize() {
        }

        abstract long execute(Object var1);

        @Specialization(limit="3")
        long doBoxed(Object object, @CachedLibrary(value="object") InteropLibrary interop, @Cached BranchProfile exception) {
            try {
                String unboxed = interop.asString(object);
                return unboxed.length();
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException(this, "Polyglot value is not a string.");
            }
        }
    }
}

