/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotEval;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMPolyglotEval.class)
public final class LLVMPolyglotEvalNodeGen
extends LLVMPolyglotEval {
    private LLVMSourceLocation sourceLocation;
    private boolean statement;
    @Node.Child
    private LLVMExpressionNode child0_;
    @Node.Child
    private LLVMExpressionNode child1_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @Node.Child
    private EvalData eval_cache;

    private LLVMPolyglotEvalNodeGen(LLVMPolyglotEval.GetSourceNode getSource, LLVMExpressionNode child0, LLVMExpressionNode child1) {
        super(getSource);
        this.child0_ = child0;
        this.child1_ = child1;
    }

    @Override
    public LLVMSourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    protected boolean isStatement() {
        return this.statement;
    }

    @Override
    protected void setStatement(boolean statement) {
        this.statement = statement;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        EvalData s1_;
        int state = this.state_;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        Object child1Value_ = this.child1_.executeGeneric(frameValue);
        if (state != 0 && (s1_ = this.eval_cache) != null) {
            return this.doEval(child0Value_, child1Value_, s1_.readId_, s1_.readSrc_, s1_.toLLVM_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(child0Value_, child1Value_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object child0Value, Object child1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            EvalData s1_ = (EvalData)super.insert((Node)new EvalData());
            s1_.readId_ = s1_.insertAccessor(this.createReadString());
            s1_.readSrc_ = s1_.insertAccessor(this.createReadString());
            s1_.toLLVM_ = s1_.insertAccessor(this.createForeignToLLVM());
            this.eval_cache = s1_;
            this.state_ = state |= 1;
            lock.unlock();
            hasLock = false;
            Object object = this.doEval(child0Value, child1Value, s1_.readId_, s1_.readSrc_, s1_.toLLVM_);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public static LLVMPolyglotEval create(LLVMPolyglotEval.GetSourceNode getSource, LLVMExpressionNode child0, LLVMExpressionNode child1) {
        return new LLVMPolyglotEvalNodeGen(getSource, child0, child1);
    }

    @GeneratedBy(value=LLVMPolyglotEval.GetSourceFileNode.class)
    static final class GetSourceFileNodeGen
    extends LLVMPolyglotEval.GetSourceFileNode {
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;

        private GetSourceFileNodeGen() {
        }

        @Override
        CallTarget execute(String arg0Value, String arg1Value) {
            int state = this.state_;
            if (state != 0) {
                TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                LLVMContext ctx__ = (LLVMContext)lLVMLanguageContextReference__.get();
                return this.uncached(arg0Value, arg1Value, ctx__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CallTarget executeAndSpecialize(String arg0Value, String arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                LLVMContext ctx__ = null;
                TruffleLanguage.ContextReference lLVMLanguageContextReference__1 = this.lLVMLanguageContextReference_;
                if (lLVMLanguageContextReference__1 == null) {
                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__1 = super.lookupContextReference(LLVMLanguage.class);
                }
                ctx__ = (LLVMContext)lLVMLanguageContextReference__1.get();
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                CallTarget callTarget = this.uncached(arg0Value, arg1Value, ctx__);
                return callTarget;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMPolyglotEval.GetSourceFileNode create() {
            return new GetSourceFileNodeGen();
        }
    }

    @GeneratedBy(value=LLVMPolyglotEval.GetSourceStringNode.class)
    static final class GetSourceStringNodeGen
    extends LLVMPolyglotEval.GetSourceStringNode {
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;
        @CompilerDirectives.CompilationFinal
        private CachedData cached_cache;

        private GetSourceStringNodeGen() {
        }

        @Override
        @ExplodeLoop
        CallTarget execute(String arg0Value, String arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if (arg0Value.equals(s1_.cachedId_) && arg1Value.equals(s1_.cachedCode_)) {
                            TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__;
                            TruffleLanguage.ContextReference<LLVMContext> ctxRef__ = lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                            return this.doCached(arg0Value, arg1Value, s1_.cachedId_, s1_.cachedCode_, ctxRef__, s1_.callTarget_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__1;
                    TruffleLanguage.ContextReference<LLVMContext> uncached_ctxRef__ = lLVMLanguageContextReference__1 = this.lLVMLanguageContextReference_;
                    return this.uncached(arg0Value, arg1Value, uncached_ctxRef__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CallTarget executeAndSpecialize(String arg0Value, String arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                TruffleLanguage.ContextReference ctxRef__ = null;
                if (exclude == 0) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null) {
                            if (arg0Value.equals(s1_.cachedId_) && arg1Value.equals(s1_.cachedCode_)) {
                                TruffleLanguage.ContextReference lLVMLanguageContextReference__2 = this.lLVMLanguageContextReference_;
                                if (lLVMLanguageContextReference__2 == null) {
                                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__2 = super.lookupContextReference(LLVMLanguage.class);
                                }
                                ctxRef__ = lLVMLanguageContextReference__2;
                                break;
                            }
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 2) {
                        s1_ = new CachedData(this.cached_cache);
                        s1_.cachedId_ = arg0Value;
                        s1_.cachedCode_ = arg1Value;
                        TruffleLanguage.ContextReference lLVMLanguageContextReference__3 = this.lLVMLanguageContextReference_;
                        if (lLVMLanguageContextReference__3 == null) {
                            this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__3 = super.lookupContextReference(LLVMLanguage.class);
                        }
                        ctxRef__ = lLVMLanguageContextReference__3;
                        s1_.callTarget_ = this.uncached(s1_.cachedId_, s1_.cachedCode_, (TruffleLanguage.ContextReference<LLVMContext>)ctxRef__);
                        this.cached_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        CallTarget callTarget = this.doCached(arg0Value, arg1Value, s1_.cachedId_, s1_.cachedCode_, ctxRef__, s1_.callTarget_);
                        return callTarget;
                    }
                }
                TruffleLanguage.ContextReference uncached_ctxRef__ = null;
                TruffleLanguage.ContextReference lLVMLanguageContextReference__4 = this.lLVMLanguageContextReference_;
                if (lLVMLanguageContextReference__4 == null) {
                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__4 = super.lookupContextReference(LLVMLanguage.class);
                }
                uncached_ctxRef__ = lLVMLanguageContextReference__4;
                this.exclude_ = exclude |= 1;
                this.cached_cache = null;
                state &= 0xFFFFFFFE;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                CallTarget callTarget = this.uncached(arg0Value, arg1Value, (TruffleLanguage.ContextReference<LLVMContext>)uncached_ctxRef__);
                return callTarget;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            CachedData s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMPolyglotEval.GetSourceStringNode create() {
            return new GetSourceStringNodeGen();
        }

        @GeneratedBy(value=LLVMPolyglotEval.GetSourceStringNode.class)
        private static final class CachedData {
            @CompilerDirectives.CompilationFinal
            CachedData next_;
            @CompilerDirectives.CompilationFinal
            String cachedId_;
            @CompilerDirectives.CompilationFinal
            String cachedCode_;
            @CompilerDirectives.CompilationFinal
            CallTarget callTarget_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=LLVMPolyglotEval.class)
    private static final class EvalData
    extends Node {
        @Node.Child
        LLVMReadStringNode readId_;
        @Node.Child
        LLVMReadStringNode readSrc_;
        @Node.Child
        ForeignToLLVM toLLVM_;

        EvalData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

