/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.c;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMCTypeIntrinsics;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMCTypeIntrinsics.class)
public final class LLVMCTypeIntrinsicsFactory {

    @GeneratedBy(value=LLVMCTypeIntrinsics.LLVMIsupper.class)
    public static final class LLVMIsupperNodeGen
    extends LLVMCTypeIntrinsics.LLVMIsupper {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;

        private LLVMIsupperNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if ((state & 1) != 0 && LLVMCTypeIntrinsics.isLowercaseLetter(child0Value_)) {
                return this.fromLower(child0Value_);
            }
            if ((state & 2) != 0 && LLVMCTypeIntrinsics.isUppercaseLetter(child0Value_)) {
                return this.fromUpper(child0Value_);
            }
            if ((state & 4) != 0 && LLVMCTypeIntrinsics.isAsciiCharacter(child0Value_)) {
                return this.fromCharacter(child0Value_);
            }
            if ((state & 8) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if ((state & 1) != 0 && LLVMCTypeIntrinsics.isLowercaseLetter(child0Value_)) {
                return this.fromLower(child0Value_);
            }
            if ((state & 2) != 0 && LLVMCTypeIntrinsics.isUppercaseLetter(child0Value_)) {
                return this.fromUpper(child0Value_);
            }
            if ((state & 4) != 0 && LLVMCTypeIntrinsics.isAsciiCharacter(child0Value_)) {
                return this.fromCharacter(child0Value_);
            }
            if ((state & 8) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        private int executeAndSpecialize(Object child0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if (child0Value instanceof Integer) {
                    int child0Value_ = (Integer)child0Value;
                    if ((exclude & 1) == 0 && LLVMCTypeIntrinsics.isLowercaseLetter(child0Value_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        int n = this.fromLower(child0Value_);
                        return n;
                    }
                    if ((exclude & 2) == 0 && LLVMCTypeIntrinsics.isUppercaseLetter(child0Value_)) {
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        int n = this.fromUpper(child0Value_);
                        return n;
                    }
                    if ((exclude & 4) == 0 && LLVMCTypeIntrinsics.isAsciiCharacter(child0Value_)) {
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        int n = this.fromCharacter(child0Value_);
                        return n;
                    }
                    this.exclude_ = exclude |= 7;
                    state &= 0xFFFFFFF8;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doIntrinsic(child0Value_);
                    return n;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCTypeIntrinsics.LLVMIsupper create(LLVMExpressionNode child0) {
            return new LLVMIsupperNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMCTypeIntrinsics.LLVMIsspace.class)
    public static final class LLVMIsspaceNodeGen
    extends LLVMCTypeIntrinsics.LLVMIsspace {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMIsspaceNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        private int executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Integer) {
                int child0Value_ = (Integer)child0Value;
                this.state_ = state |= 1;
                return this.doIntrinsic(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMCTypeIntrinsics.LLVMIsspace create(LLVMExpressionNode child0) {
            return new LLVMIsspaceNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMCTypeIntrinsics.LLVMIsalpha.class)
    public static final class LLVMIsalphaNodeGen
    extends LLVMCTypeIntrinsics.LLVMIsalpha {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMIsalphaNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        private int executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Integer) {
                int child0Value_ = (Integer)child0Value;
                this.state_ = state |= 1;
                return this.doIntrinsic(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMCTypeIntrinsics.LLVMIsalpha create(LLVMExpressionNode child0) {
            return new LLVMIsalphaNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMCTypeIntrinsics.LLVMTolower.class)
    public static final class LLVMTolowerNodeGen
    extends LLVMCTypeIntrinsics.LLVMTolower {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;

        private LLVMTolowerNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if ((state & 1) != 0 && LLVMCTypeIntrinsics.isLowercaseLetter(child0Value_)) {
                return this.fromLower(child0Value_);
            }
            if ((state & 2) != 0 && LLVMCTypeIntrinsics.isUppercaseLetter(child0Value_)) {
                return this.fromUpper(child0Value_);
            }
            if ((state & 4) != 0 && LLVMCTypeIntrinsics.isAsciiCharacter(child0Value_)) {
                return this.fromCharacter(child0Value_);
            }
            if ((state & 8) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if ((state & 1) != 0 && LLVMCTypeIntrinsics.isLowercaseLetter(child0Value_)) {
                return this.fromLower(child0Value_);
            }
            if ((state & 2) != 0 && LLVMCTypeIntrinsics.isUppercaseLetter(child0Value_)) {
                return this.fromUpper(child0Value_);
            }
            if ((state & 4) != 0 && LLVMCTypeIntrinsics.isAsciiCharacter(child0Value_)) {
                return this.fromCharacter(child0Value_);
            }
            if ((state & 8) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        private int executeAndSpecialize(Object child0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if (child0Value instanceof Integer) {
                    int child0Value_ = (Integer)child0Value;
                    if ((exclude & 1) == 0 && LLVMCTypeIntrinsics.isLowercaseLetter(child0Value_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        int n = this.fromLower(child0Value_);
                        return n;
                    }
                    if ((exclude & 2) == 0 && LLVMCTypeIntrinsics.isUppercaseLetter(child0Value_)) {
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        int n = this.fromUpper(child0Value_);
                        return n;
                    }
                    if ((exclude & 4) == 0 && LLVMCTypeIntrinsics.isAsciiCharacter(child0Value_)) {
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        int n = this.fromCharacter(child0Value_);
                        return n;
                    }
                    this.exclude_ = exclude |= 7;
                    state &= 0xFFFFFFF8;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doIntrinsic(child0Value_);
                    return n;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCTypeIntrinsics.LLVMTolower create(LLVMExpressionNode child0) {
            return new LLVMTolowerNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMCTypeIntrinsics.LLVMToUpper.class)
    public static final class LLVMToUpperNodeGen
    extends LLVMCTypeIntrinsics.LLVMToUpper {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;

        private LLVMToUpperNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if ((state & 1) != 0 && LLVMCTypeIntrinsics.isLowercaseLetter(child0Value_)) {
                return this.fromLower(child0Value_);
            }
            if ((state & 2) != 0 && LLVMCTypeIntrinsics.isUppercaseLetter(child0Value_)) {
                return this.fromUpper(child0Value_);
            }
            if ((state & 4) != 0 && LLVMCTypeIntrinsics.isAsciiCharacter(child0Value_)) {
                return this.fromCharacter(child0Value_);
            }
            if ((state & 8) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if ((state & 1) != 0 && LLVMCTypeIntrinsics.isLowercaseLetter(child0Value_)) {
                return this.fromLower(child0Value_);
            }
            if ((state & 2) != 0 && LLVMCTypeIntrinsics.isUppercaseLetter(child0Value_)) {
                return this.fromUpper(child0Value_);
            }
            if ((state & 4) != 0 && LLVMCTypeIntrinsics.isAsciiCharacter(child0Value_)) {
                return this.fromCharacter(child0Value_);
            }
            if ((state & 8) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        private int executeAndSpecialize(Object child0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if (child0Value instanceof Integer) {
                    int child0Value_ = (Integer)child0Value;
                    if ((exclude & 1) == 0 && LLVMCTypeIntrinsics.isLowercaseLetter(child0Value_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        int n = this.fromLower(child0Value_);
                        return n;
                    }
                    if ((exclude & 2) == 0 && LLVMCTypeIntrinsics.isUppercaseLetter(child0Value_)) {
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        int n = this.fromUpper(child0Value_);
                        return n;
                    }
                    if ((exclude & 4) == 0 && LLVMCTypeIntrinsics.isAsciiCharacter(child0Value_)) {
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        int n = this.fromCharacter(child0Value_);
                        return n;
                    }
                    this.exclude_ = exclude |= 7;
                    state &= 0xFFFFFFF8;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doIntrinsic(child0Value_);
                    return n;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCTypeIntrinsics.LLVMToUpper create(LLVMExpressionNode child0) {
            return new LLVMToUpperNodeGen(child0);
        }
    }
}

