/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.c;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.interop.LLVMNegatedForeignObject;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMBuiltin;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVM80BitFloatStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVM80BitFloatStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMDoubleStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMDoubleStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMFloatStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMFloatStoreNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;

public abstract class LLVMCMathsIntrinsics {

    @NodeChildren(value={@NodeChild(value="magnitude", type=LLVMExpressionNode.class), @NodeChild(value="sign", type=LLVMExpressionNode.class)})
    public static abstract class LLVMCopySign
    extends LLVMBuiltin {
        @Specialization
        protected float doFloat(float magnitude, float sign) {
            return Math.copySign(magnitude, sign);
        }

        @Specialization
        protected double doDouble(double magnitude, double sign) {
            return Math.copySign(magnitude, sign);
        }

        @Specialization
        protected LLVM80BitFloat doLLVM80BitFloat(LLVM80BitFloat magnitude, LLVM80BitFloat sign) {
            if (magnitude.getSign() != sign.getSign()) {
                return magnitude.negate();
            }
            return magnitude;
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMATan2
    extends LLVMIntrinsic {
        @Specialization
        protected double doIntrinsic(double value1, double value2) {
            return Math.atan2(value1, value2);
        }

        @Specialization
        protected float doIntrinsic(float value1, float value2) {
            return (float)Math.atan2(value1, value2);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value1, LLVM80BitFloat value2) {
            double result = this.doIntrinsic(value1.getDoubleValue(), value2.getDoubleValue());
            return LLVM80BitFloat.fromDouble(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMATan
    extends LLVMIntrinsic {
        @Specialization
        protected double doIntrinsic(double value) {
            return Math.atan(value);
        }

        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.atan(value);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value) {
            double result = this.doIntrinsic(value.getDoubleValue());
            return LLVM80BitFloat.fromDouble(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMTanh
    extends LLVMIntrinsic {
        @Specialization
        protected double doIntrinsic(double value) {
            return Math.tanh(value);
        }

        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.tanh(value);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value) {
            double result = this.doIntrinsic(value.getDoubleValue());
            return LLVM80BitFloat.fromDouble(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMTan
    extends LLVMIntrinsic {
        @Specialization
        protected double doIntrinsic(double value) {
            return Math.tan(value);
        }

        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.tan(value);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value) {
            double result = this.doIntrinsic(value.getDoubleValue());
            return LLVM80BitFloat.fromDouble(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMACos
    extends LLVMIntrinsic {
        @Specialization
        protected double doIntrinsic(double value) {
            return Math.acos(value);
        }

        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.acos(value);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value) {
            double result = this.doIntrinsic(value.getDoubleValue());
            return LLVM80BitFloat.fromDouble(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMCosh
    extends LLVMIntrinsic {
        @Specialization
        protected double doIntrinsic(double value) {
            return Math.cosh(value);
        }

        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.cosh(value);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value) {
            double result = this.doIntrinsic(value.getDoubleValue());
            return LLVM80BitFloat.fromDouble(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMCos
    extends LLVMBuiltin {
        @Specialization
        protected double doIntrinsic(double value) {
            return Math.cos(value);
        }

        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.cos(value);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value) {
            double result = this.doIntrinsic(value.getDoubleValue());
            return LLVM80BitFloat.fromDouble(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMASin
    extends LLVMIntrinsic {
        @Specialization
        protected double doIntrinsic(double value) {
            return Math.asin(value);
        }

        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.asin(value);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value) {
            double result = this.doIntrinsic(value.getDoubleValue());
            return LLVM80BitFloat.fromDouble(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMSinh
    extends LLVMIntrinsic {
        @Specialization
        protected double doIntrinsic(double value) {
            return Math.sinh(value);
        }

        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.sinh(value);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value) {
            double result = this.doIntrinsic(value.getDoubleValue());
            return LLVM80BitFloat.fromDouble(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMSin
    extends LLVMBuiltin {
        @Specialization
        protected double doIntrinsic(double value) {
            return Math.sin(value);
        }

        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.sin(value);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value) {
            double result = this.doIntrinsic(value.getDoubleValue());
            return LLVM80BitFloat.fromDouble(result);
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMPow
    extends LLVMBuiltin {
        @Specialization
        protected float doFloat(float val, int pow) {
            return (float)Math.pow(val, pow);
        }

        @Specialization
        protected float doFloat(float val, float pow) {
            return (float)Math.pow(val, pow);
        }

        @Specialization
        protected double doDouble(double a, int b) {
            return Math.pow(a, b);
        }

        @Specialization
        protected double doDouble(double a, double b) {
            return Math.pow(a, b);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value, int pow) {
            double result = this.doDouble(value.getDoubleValue(), pow);
            return LLVM80BitFloat.fromDouble(result);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat a, LLVM80BitFloat b) {
            double result = this.doDouble(a.getDoubleValue(), b.getDoubleValue());
            return LLVM80BitFloat.fromDouble(result);
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMFmod
    extends LLVMIntrinsic {
        @Specialization
        protected double doIntrinsic(double numer, double denom) {
            return numer % denom;
        }

        @Specialization
        protected float doIntrinsic(float numer, float denom) {
            return numer % denom;
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value, LLVM80BitFloat denom) {
            double result = this.doIntrinsic(value.getDoubleValue(), denom.getDoubleValue());
            return LLVM80BitFloat.fromDouble(result);
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMModf
    extends LLVMIntrinsic {
        @Specialization
        protected double doIntrinsic(double value, LLVMPointer integralAddr, @Cached(value="createDoubleStore()") LLVMDoubleStoreNode store) {
            double fractional = value % 1.0;
            double integral = value - fractional;
            store.executeWithTarget(integralAddr, integral);
            return fractional;
        }

        @Specialization
        protected float doIntrinsic(float value, LLVMPointer integralAddr, @Cached(value="createFloatStore()") LLVMFloatStoreNode store) {
            float fractional = value % 1.0f;
            float integral = value - fractional;
            store.executeWithTarget(integralAddr, Float.valueOf(integral));
            return fractional;
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat longDoubleValue, LLVMPointer integralAddr, @Cached(value="create80BitFloatStore()") LLVM80BitFloatStoreNode store) {
            double value = longDoubleValue.getDoubleValue();
            double fractional = value % 1.0;
            double integral = value - fractional;
            store.executeWithTarget(integralAddr, integral);
            return LLVM80BitFloat.fromDouble(fractional);
        }

        @CompilerDirectives.TruffleBoundary
        protected static LLVMDoubleStoreNode createDoubleStore() {
            return LLVMDoubleStoreNodeGen.create(null, null);
        }

        @CompilerDirectives.TruffleBoundary
        protected static LLVMFloatStoreNode createFloatStore() {
            return LLVMFloatStoreNodeGen.create(null, null);
        }

        @CompilerDirectives.TruffleBoundary
        protected static LLVM80BitFloatStoreNode create80BitFloatStore() {
            return LLVM80BitFloatStoreNodeGen.create(null, null);
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMLdexp
    extends LLVMIntrinsic {
        @Specialization
        protected float doIntrinsic(float value, int exp) {
            return value * (float)Math.pow(2.0, exp);
        }

        @Specialization
        protected double doIntrinsic(double value, int exp) {
            return value * Math.pow(2.0, exp);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value, int exp) {
            double result = this.doIntrinsic(value.getDoubleValue(), exp);
            return LLVM80BitFloat.fromDouble(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMExp2
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.pow(2.0, value);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.pow(2.0, value);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value) {
            double result = this.doIntrinsic(value.getDoubleValue());
            return LLVM80BitFloat.fromDouble(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMExpm1
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.expm1(value);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.expm1(value);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value) {
            double result = this.doIntrinsic(value.getDoubleValue());
            return LLVM80BitFloat.fromDouble(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMExp
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.exp(value);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.exp(value);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value) {
            double result = this.doIntrinsic(value.getDoubleValue());
            return LLVM80BitFloat.fromDouble(result);
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMMaxnum
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value1, float value2) {
            if (Float.isNaN(value1)) {
                return value2;
            }
            if (Float.isNaN(value2)) {
                return value1;
            }
            return Math.max(value1, value2);
        }

        @Specialization
        protected double doIntrinsic(double value1, double value2) {
            if (Double.isNaN(value1)) {
                return value2;
            }
            if (Double.isNaN(value2)) {
                return value1;
            }
            return Math.max(value1, value2);
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMMinnum
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value1, float value2) {
            if (Float.isNaN(value1)) {
                return value2;
            }
            if (Float.isNaN(value2)) {
                return value1;
            }
            return Math.min(value1, value2);
        }

        @Specialization
        protected double doIntrinsic(double value1, double value2) {
            if (Double.isNaN(value1)) {
                return value2;
            }
            if (Double.isNaN(value2)) {
                return value1;
            }
            return Math.min(value1, value2);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    @NodeField(name="vectorLength", type=int.class)
    public static abstract class LLVMFAbsVectorNode
    extends LLVMBuiltin {
        protected abstract int getVectorLength();

        @ExplodeLoop
        @Specialization
        protected LLVMDoubleVector doVector(LLVMDoubleVector value) {
            assert (value.getLength() == this.getVectorLength());
            double[] result = new double[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result[i] = Math.abs(value.getValue(i));
            }
            return LLVMDoubleVector.create(result);
        }

        @ExplodeLoop
        @Specialization
        protected LLVMFloatVector doVector(LLVMFloatVector value) {
            assert (value.getLength() == this.getVectorLength());
            float[] result = new float[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result[i] = Math.abs(value.getValue(i));
            }
            return LLVMFloatVector.create(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMFAbs
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value) {
            return Math.abs(value);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.abs(value);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value) {
            return value.abs();
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMAbs
    extends LLVMIntrinsic {
        @Specialization
        protected int doInt(int value) {
            return Math.abs(value);
        }

        @Specialization
        protected long doLong(long value) {
            return Math.abs(value);
        }

        @Specialization
        protected LLVMNativePointer doNative(LLVMNativePointer value) {
            return LLVMNativePointer.create(this.doLong(value.asNative()));
        }

        @Specialization
        protected LLVMManagedPointer doManaged(LLVMManagedPointer value, @Cached ConditionProfile negated) {
            if (negated.profile(value.getObject() instanceof LLVMNegatedForeignObject)) {
                LLVMNegatedForeignObject obj = (LLVMNegatedForeignObject)value.getObject();
                assert (!(obj.getForeign() instanceof LLVMNegatedForeignObject));
                return LLVMManagedPointer.create(obj.getForeign(), -value.getOffset());
            }
            return value;
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMRound
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value) {
            return Math.round(value);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.round(value);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value) {
            double result = this.doIntrinsic(value.getDoubleValue());
            return LLVM80BitFloat.fromDouble(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMFloor
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.floor(value);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.floor(value);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value) {
            double result = this.doIntrinsic(value.getDoubleValue());
            return LLVM80BitFloat.fromDouble(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMCeil
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.ceil(value);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.ceil(value);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value) {
            double result = this.doIntrinsic(value.getDoubleValue());
            return LLVM80BitFloat.fromDouble(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMRint
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.rint(value);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.rint(value);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value) {
            double result = this.doIntrinsic(value.getDoubleValue());
            return LLVM80BitFloat.fromDouble(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMLog1p
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.log1p(value);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.log1p(value);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value) {
            double result = this.doIntrinsic(value.getDoubleValue());
            return LLVM80BitFloat.fromDouble(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMLog10
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.log10(value);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.log10(value);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value) {
            double result = this.doIntrinsic(value.getDoubleValue());
            return LLVM80BitFloat.fromDouble(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMLog2
    extends LLVMBuiltin {
        private static final double LOG_2 = Math.log(2.0);

        @Specialization
        protected float doIntrinsic(float value) {
            return (float)(Math.log(value) / LOG_2);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.log(value) / LOG_2;
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value) {
            double result = this.doIntrinsic(value.getDoubleValue());
            return LLVM80BitFloat.fromDouble(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMLog
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.log(value);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.log(value);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value) {
            double result = this.doIntrinsic(value.getDoubleValue());
            return LLVM80BitFloat.fromDouble(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    @NodeField(name="vectorLength", type=int.class)
    public static abstract class LLVMSqrtVectorNode
    extends LLVMBuiltin {
        protected abstract int getVectorLength();

        @ExplodeLoop
        @Specialization
        protected LLVMDoubleVector doVector(LLVMDoubleVector value) {
            assert (value.getLength() == this.getVectorLength());
            double[] result = new double[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result[i] = Math.sqrt(value.getValue(i));
            }
            return LLVMDoubleVector.create(result);
        }

        @ExplodeLoop
        @Specialization
        protected LLVMFloatVector doVector(LLVMFloatVector value) {
            assert (value.getLength() == this.getVectorLength());
            float[] result = new float[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result[i] = (float)Math.sqrt(value.getValue(i));
            }
            return LLVMFloatVector.create(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMSqrt
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.sqrt(value);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.sqrt(value);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value) {
            double result = this.doIntrinsic(value.getDoubleValue());
            return LLVM80BitFloat.fromDouble(result);
        }
    }
}

