/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.interop.nfi.LLVMNativeConvertNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMNativeDispatchNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMNativeDispatchNode.class)
public final class LLVMNativeDispatchNodeGen
extends LLVMNativeDispatchNode {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;
    @Node.Child
    private CachedData cached_cache;
    @Node.Child
    private GenericData generic_cache;

    private LLVMNativeDispatchNodeGen(FunctionType type) {
        super(type);
    }

    @Override
    @ExplodeLoop
    public Object executeDispatch(Object arg0Value, Object[] arg1Value) {
        int state = this.state_;
        if (state != 0 && LLVMTypes.isNativePointer(arg0Value)) {
            GenericData s2_;
            LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
            if ((state & 1) != 0) {
                CachedData s1_ = this.cached_cache;
                while (s1_ != null) {
                    assert (s1_.nativeCall_.accepts(s1_.nativeFunctionHandle_));
                    if (arg0Value_.asNative() == s1_.cachedFunction_.asNative()) {
                        TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__;
                        TruffleLanguage.ContextReference<LLVMContext> context__ = lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                        return this.doCached(arg0Value_, arg1Value, context__, s1_.cachedFunction_, s1_.nativeFunctionHandle_, s1_.nativeCall_, s1_.toNative_, s1_.fromNative_, s1_.statistics_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0 && (s2_ = this.generic_cache) != null) {
                TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__1;
                TruffleLanguage.ContextReference<LLVMContext> context__1 = lLVMLanguageContextReference__1 = this.lLVMLanguageContextReference_;
                return this.doGeneric(arg0Value_, arg1Value, context__1, s2_.toNative_, s2_.fromNative_, s2_.nativeCall_, s2_.statistics_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value);
    }

    private Object executeAndSpecialize(Object arg0Value, Object[] arg1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (LLVMTypes.isNativePointer(arg0Value)) {
                Object object;
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                TruffleLanguage.ContextReference context__ = null;
                int count1_ = 0;
                CachedData s1_ = this.cached_cache;
                if ((state & 1) != 0) {
                    while (s1_ != null) {
                        assert (s1_.nativeCall_.accepts(s1_.nativeFunctionHandle_));
                        if (arg0Value_.asNative() == s1_.cachedFunction_.asNative()) {
                            TruffleLanguage.ContextReference lLVMLanguageContextReference__2 = this.lLVMLanguageContextReference_;
                            if (lLVMLanguageContextReference__2 == null) {
                                this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__2 = super.lookupContextReference(LLVMLanguage.class);
                            }
                            context__ = lLVMLanguageContextReference__2;
                            break;
                        }
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null) {
                    LLVMNativePointer cachedFunction__ = arg0Value_;
                    if (arg0Value_.asNative() == cachedFunction__.asNative() && count1_ < 3) {
                        s1_ = (CachedData)super.insert((Node)new CachedData(this.cached_cache));
                        TruffleLanguage.ContextReference lLVMLanguageContextReference__3 = this.lLVMLanguageContextReference_;
                        if (lLVMLanguageContextReference__3 == null) {
                            this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__3 = super.lookupContextReference(LLVMLanguage.class);
                        }
                        context__ = lLVMLanguageContextReference__3;
                        s1_.cachedFunction_ = cachedFunction__;
                        s1_.nativeFunctionHandle_ = this.dispatchIdentity(cachedFunction__.asNative());
                        s1_.nativeCall_ = (InteropLibrary)s1_.insertAccessor(INTEROP_LIBRARY_.create(s1_.nativeFunctionHandle_));
                        s1_.toNative_ = s1_.insertAccessor(this.createToNativeNodes());
                        s1_.fromNative_ = s1_.insertAccessor(this.createFromNativeNode());
                        s1_.statistics_ = LLVMNode.nativeCallStatisticsEnabled((TruffleLanguage.ContextReference<LLVMContext>)context__);
                        this.cached_cache = s1_;
                        this.state_ = state |= 1;
                    }
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    object = this.doCached(arg0Value_, arg1Value, (TruffleLanguage.ContextReference<LLVMContext>)context__, s1_.cachedFunction_, s1_.nativeFunctionHandle_, s1_.nativeCall_, s1_.toNative_, s1_.fromNative_, s1_.statistics_);
                    return object;
                }
                TruffleLanguage.ContextReference context__1 = null;
                GenericData s2_ = (GenericData)super.insert((Node)new GenericData());
                TruffleLanguage.ContextReference lLVMLanguageContextReference__4 = this.lLVMLanguageContextReference_;
                if (lLVMLanguageContextReference__4 == null) {
                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__4 = super.lookupContextReference(LLVMLanguage.class);
                }
                context__1 = lLVMLanguageContextReference__4;
                s2_.toNative_ = s2_.insertAccessor(this.createToNativeNodes());
                s2_.fromNative_ = s2_.insertAccessor(this.createFromNativeNode());
                s2_.nativeCall_ = (InteropLibrary)s2_.insertAccessor(INTEROP_LIBRARY_.createDispatched(5));
                s2_.statistics_ = LLVMNode.nativeCallStatisticsEnabled((TruffleLanguage.ContextReference<LLVMContext>)context__1);
                this.generic_cache = s2_;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                object = this.doGeneric(arg0Value_, arg1Value, (TruffleLanguage.ContextReference<LLVMContext>)context__1, s2_.toNative_, s2_.fromNative_, s2_.nativeCall_, s2_.statistics_);
                return object;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        CachedData s1_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMNativeDispatchNode create(FunctionType type) {
        return new LLVMNativeDispatchNodeGen(type);
    }

    @GeneratedBy(value=LLVMNativeDispatchNode.class)
    private static final class GenericData
    extends Node {
        @Node.Children
        LLVMNativeConvertNode[] toNative_;
        @Node.Child
        LLVMNativeConvertNode fromNative_;
        @Node.Child
        InteropLibrary nativeCall_;
        @CompilerDirectives.CompilationFinal
        boolean statistics_;

        GenericData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T[] insertAccessor(T[] node) {
            return super.insert(node);
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=LLVMNativeDispatchNode.class)
    private static final class CachedData
    extends Node {
        @Node.Child
        CachedData next_;
        @CompilerDirectives.CompilationFinal
        LLVMNativePointer cachedFunction_;
        @CompilerDirectives.CompilationFinal
        Object nativeFunctionHandle_;
        @Node.Child
        InteropLibrary nativeCall_;
        @Node.Children
        LLVMNativeConvertNode[] toNative_;
        @Node.Child
        LLVMNativeConvertNode fromNative_;
        @CompilerDirectives.CompilationFinal
        boolean statistics_;

        CachedData(CachedData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T[] insertAccessor(T[] node) {
            return super.insert(node);
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

