/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMBitcodeLibraryFunctions;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.except.LLVMUserException;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMInstrumentableNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMLandingpadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.func.LandingpadEntryNodeWrapper;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.op.ToComparableValue;
import com.oracle.truffle.llvm.runtime.nodes.op.ToComparableValueNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMLandingpadNode
extends LLVMExpressionNode {
    @Node.Child
    private LLVMExpressionNode getStack;
    @Node.Child
    private LLVMExpressionNode allocateLandingPadValue;
    @Node.Child
    private LLVMPointerStoreNode writePointer;
    @Node.Child
    private LLVMI32StoreNode writeI32;
    @Node.Children
    private final LandingpadEntryNode[] entries;
    private final FrameSlot exceptionSlot;
    private final boolean cleanup;

    public LLVMLandingpadNode(LLVMExpressionNode getStack, LLVMExpressionNode allocateLandingPadValue, FrameSlot exceptionSlot, boolean cleanup, LandingpadEntryNode[] entries) {
        this.getStack = getStack;
        this.allocateLandingPadValue = allocateLandingPadValue;
        this.writePointer = LLVMPointerStoreNodeGen.create(null, null);
        this.writeI32 = LLVMI32StoreNodeGen.create(null, null);
        this.exceptionSlot = exceptionSlot;
        this.cleanup = cleanup;
        this.entries = entries;
    }

    @Specialization
    public Object doLandingpad(VirtualFrame frame) {
        try {
            LLVMUserException exception = (LLVMUserException)frame.getObject(this.exceptionSlot);
            LLVMPointer unwindHeader = exception.getUnwindHeader();
            LLVMStack.StackPointer stack = (LLVMStack.StackPointer)this.getStack.executeGeneric(frame);
            int clauseId = this.getEntryIdentifier(frame, stack, unwindHeader);
            if (clauseId == 0 && !this.cleanup) {
                throw exception;
            }
            LLVMPointer landingPadValue = this.allocateLandingPadValue.executeLLVMPointer(frame);
            this.writePointer.executeWithTarget(landingPadValue, unwindHeader);
            this.writeI32.executeWithTarget(landingPadValue.increment(8L), clauseId);
            return landingPadValue;
        }
        catch (FrameSlotTypeException | UnexpectedResultException e) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException(e);
        }
    }

    @ExplodeLoop
    private int getEntryIdentifier(VirtualFrame frame, LLVMStack.StackPointer stack, LLVMPointer unwindHeader) {
        for (int i = 0; i < this.entries.length; ++i) {
            int clauseId = this.entries[i].execute(frame, stack, unwindHeader);
            if (clauseId == 0) continue;
            return clauseId;
        }
        return 0;
    }

    public static LandingpadEntryNode createCatchEntry(LLVMExpressionNode catchType) {
        return LLVMLandingpadNodeGen.LandingpadCatchEntryNodeGen.create(null, null, catchType);
    }

    public static LandingpadEntryNode createFilterEntry(LLVMExpressionNode[] filterTypes) {
        return LLVMLandingpadNodeGen.LandingpadFilterEntryNodeGen.create(filterTypes);
    }

    public static abstract class LandingpadFilterEntryNode
    extends LandingpadEntryNode {
        @Node.Children
        private final LLVMExpressionNode[] filterTypes;
        @Node.Child
        private LLVMBitcodeLibraryFunctions.SulongCanCatchNode canCatch;

        LandingpadFilterEntryNode(LLVMExpressionNode[] filterTypes) {
            this.filterTypes = filterTypes;
        }

        LLVMBitcodeLibraryFunctions.SulongCanCatchNode getCanCatch() {
            if (this.canCatch == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                LLVMContext context = (LLVMContext)this.lookupContextReference(LLVMLanguage.class).get();
                this.canCatch = (LLVMBitcodeLibraryFunctions.SulongCanCatchNode)this.insert(new LLVMBitcodeLibraryFunctions.SulongCanCatchNode(context));
            }
            return this.canCatch;
        }

        @Specialization
        int getIdentifier(VirtualFrame frame, LLVMStack.StackPointer stack, LLVMPointer unwindHeader) {
            if (!this.filterMatches(frame, stack, unwindHeader)) {
                return -1;
            }
            return 0;
        }

        @ExplodeLoop
        private boolean filterMatches(VirtualFrame frame, LLVMStack.StackPointer stack, LLVMPointer unwindHeader) {
            try {
                for (int i = 0; i < this.filterTypes.length; ++i) {
                    LLVMPointer filterAddress = this.filterTypes[i].executeLLVMPointer(frame);
                    if (filterAddress.isNull()) {
                        return true;
                    }
                    if (this.getCanCatch().canCatch(stack, unwindHeader, filterAddress) == 0) continue;
                    return true;
                }
                return false;
            }
            catch (UnexpectedResultException e) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(e);
            }
        }
    }

    @NodeChildren(value={@NodeChild(value="stack", type=LLVMExpressionNode.class), @NodeChild(value="unwindHeader", type=LLVMExpressionNode.class), @NodeChild(value="catchType", type=LLVMExpressionNode.class)})
    static abstract class LandingpadCatchEntryNode
    extends LandingpadEntryNode {
        @Node.Child
        private LLVMBitcodeLibraryFunctions.SulongCanCatchNode canCatch;
        @Node.Child
        private ToComparableValue toComparableValue = ToComparableValueNodeGen.create();

        LandingpadCatchEntryNode() {
        }

        public LLVMBitcodeLibraryFunctions.SulongCanCatchNode getCanCatch() {
            if (this.canCatch == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                LLVMContext context = (LLVMContext)this.lookupContextReference(LLVMLanguage.class).get();
                this.canCatch = (LLVMBitcodeLibraryFunctions.SulongCanCatchNode)this.insert(new LLVMBitcodeLibraryFunctions.SulongCanCatchNode(context));
            }
            return this.canCatch;
        }

        @Specialization
        int getIdentifier(LLVMStack.StackPointer stack, LLVMPointer unwindHeader, LLVMPointer catchType) {
            if (catchType.isNull()) {
                return 1;
            }
            if (this.getCanCatch().canCatch(stack, unwindHeader, catchType) != 0) {
                return (int)this.toComparableValue.executeWithTarget(catchType);
            }
            return 0;
        }
    }

    @GenerateWrapper
    public static abstract class LandingpadEntryNode
    extends LLVMInstrumentableNode {
        public abstract int execute(VirtualFrame var1, LLVMStack.StackPointer var2, LLVMPointer var3);

        @Override
        protected abstract boolean isStatement();

        @Override
        protected abstract void setStatement(boolean var1);

        public InstrumentableNode.WrapperNode createWrapper(ProbeNode probe) {
            return new LandingpadEntryNodeWrapper(this, probe);
        }
    }
}

