/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.LLVMArgumentBuffer;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMExitException;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMAccessSymbolNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMAccessSymbolNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VoidType;

public class LLVMGlobalRootNode
extends RootNode {
    private final DirectCallNode startFunction;
    private final int mainFunctionType;
    private final String applicationPath;
    @Node.Child
    LLVMAccessSymbolNode accessMainFunction;

    public LLVMGlobalRootNode(LLVMLanguage language, FrameDescriptor descriptor, LLVMFunction mainFunction, CallTarget startFunction, String applicationPath) {
        super((TruffleLanguage)language, descriptor);
        this.startFunction = Truffle.getRuntime().createDirectCallNode(startFunction);
        this.mainFunctionType = LLVMGlobalRootNode.getMainFunctionType(mainFunction);
        this.accessMainFunction = LLVMAccessSymbolNodeGen.create(mainFunction);
        this.applicationPath = applicationPath;
    }

    public boolean isInternal() {
        return true;
    }

    public Object execute(VirtualFrame frame) {
        return this.executeWithoutFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @CompilerDirectives.TruffleBoundary
    private Object executeWithoutFrame() {
        Throwable throwable = null;
        try (LLVMStack.StackPointer basePointer = this.getContext().getThreadingStack().getStack().newFrame();){
            try {
                LLVMArgumentBuffer appPath = new LLVMArgumentBuffer(this.applicationPath);
                LLVMManagedPointer applicationPathObj = LLVMManagedPointer.create(appPath);
                Object[] realArgs = new Object[]{basePointer, this.mainFunctionType, applicationPathObj, this.accessMainFunction.execute()};
                Object result = this.startFunction.call(realArgs);
                this.getContext().awaitThreadTermination();
                Integer n = (int)((Integer)result);
                this.getContext().shutdownThreads();
                return n;
            }
            catch (LLVMExitException e) {
                Integer n;
                block20: {
                    block21: {
                        LLVMContext context = this.getContext();
                        context.setCleanupNecessary(false);
                        context.awaitThreadTermination();
                        n = e.getExitStatus();
                        this.getContext().shutdownThreads();
                        if (basePointer == null) break block20;
                        if (throwable == null) break block21;
                        try {
                            basePointer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block20;
                    }
                    basePointer.close();
                }
                return n;
                {
                    catch (Throwable throwable3) {
                        try {
                            this.getContext().shutdownThreads();
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                    }
                }
            }
        }
    }

    private static int getMainFunctionType(LLVMFunction function) {
        CompilerAsserts.neverPartOfCompilation();
        FunctionType functionType = function.getType();
        Type returnType = functionType.getReturnType();
        if (functionType.getNumberOfArguments() > 0 && functionType.getArgumentType(0) instanceof PrimitiveType && ((PrimitiveType)functionType.getArgumentType(0)).getPrimitiveKind() == PrimitiveType.PrimitiveKind.I64) {
            return 1;
        }
        if (returnType instanceof VoidType) {
            return 2;
        }
        if (returnType instanceof PrimitiveType) {
            switch (((PrimitiveType)returnType).getPrimitiveKind()) {
                case I8: {
                    return 3;
                }
                case I16: {
                    return 4;
                }
                case I32: {
                    return 0;
                }
                case I64: {
                    return 5;
                }
            }
        }
        throw new AssertionError((Object)"Unexpected main method signature");
    }

    public final LLVMContext getContext() {
        return (LLVMContext)this.lookupContextReference(LLVMLanguage.class).get();
    }
}

