/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RepeatingNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMLoopNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMLoopNodeWrapper;

@GenerateWrapper
public abstract class LLVMLoopNode
extends LLVMControlFlowNode {
    public static LLVMLoopNode create(RepeatingNode bodyNode, int[] successorIDs) {
        return LLVMLoopNodeFactory.LLVMLoopNodeImplNodeGen.create(bodyNode, successorIDs);
    }

    public abstract void executeLoop(VirtualFrame var1);

    public InstrumentableNode.WrapperNode createWrapper(ProbeNode probe) {
        return new LLVMLoopNodeWrapper(this, probe);
    }

    @Override
    protected abstract boolean isStatement();

    @Override
    protected abstract void setStatement(boolean var1);

    static abstract class LLVMLoopNodeImpl
    extends LLVMLoopNode {
        @Node.Child
        private LoopNode loop;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final int[] successors;

        LLVMLoopNodeImpl(RepeatingNode bodyNode, int[] successors) {
            this.loop = Truffle.getRuntime().createLoopNode(bodyNode);
            this.successors = successors;
        }

        @Override
        public int[] getSuccessors() {
            return this.successors;
        }

        @Specialization
        public void loop(VirtualFrame frame) {
            this.loop.execute(frame);
        }

        @Override
        public int getSuccessorCount() {
            return this.successors.length;
        }

        @Override
        public LLVMStatementNode getPhiNode(int successorIndex) {
            return null;
        }
    }
}

