/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMIndirectBranchNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@GeneratedBy(value=LLVMIndirectBranchNode.class)
public final class LLVMIndirectBranchNodeFactory {

    @GeneratedBy(value=LLVMIndirectBranchNode.LLVMIndirectBranchNodeImpl.class)
    static final class LLVMIndirectBranchNodeImplNodeGen
    extends LLVMIndirectBranchNode.LLVMIndirectBranchNodeImpl {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode branchAddress_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMIndirectBranchNodeImplNodeGen(int[] indices, LLVMStatementNode[] phiWriteNodes, LLVMExpressionNode branchAddress) {
            super(indices, phiWriteNodes);
            this.branchAddress_ = branchAddress;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public int executeCondition(VirtualFrame frameValue) {
            int state = this.state_;
            Object branchAddressValue_ = this.branchAddress_.executeGeneric(frameValue);
            if (state != 0 && LLVMTypes.isNativePointer(branchAddressValue_)) {
                LLVMNativePointer branchAddressValue__ = LLVMTypes.asNativePointer(branchAddressValue_);
                return this.doCondition(branchAddressValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(branchAddressValue_);
        }

        private int executeAndSpecialize(Object branchAddressValue) {
            int state = this.state_;
            if (LLVMTypes.isNativePointer(branchAddressValue)) {
                LLVMNativePointer branchAddressValue_ = LLVMTypes.asNativePointer(branchAddressValue);
                this.state_ = state |= 1;
                return this.doCondition(branchAddressValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.branchAddress_}, new Object[]{branchAddressValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMIndirectBranchNode.LLVMIndirectBranchNodeImpl create(int[] indices, LLVMStatementNode[] phiWriteNodes, LLVMExpressionNode branchAddress) {
            return new LLVMIndirectBranchNodeImplNodeGen(indices, phiWriteNodes, branchAddress);
        }
    }
}

