/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMIndirectBranchNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMIndirectBranchNodeWrapper;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@GenerateWrapper
@NodeChild(value="branchAddress", type=LLVMExpressionNode.class)
public abstract class LLVMIndirectBranchNode
extends LLVMControlFlowNode {
    public static LLVMIndirectBranchNode create(LLVMExpressionNode branchAddress, int[] indices, LLVMStatementNode[] phiWriteNodes) {
        return LLVMIndirectBranchNodeFactory.LLVMIndirectBranchNodeImplNodeGen.create(indices, phiWriteNodes, branchAddress);
    }

    public InstrumentableNode.WrapperNode createWrapper(ProbeNode probe) {
        return new LLVMIndirectBranchNodeWrapper(this, probe);
    }

    public abstract int executeCondition(VirtualFrame var1);

    @Override
    protected abstract boolean isStatement();

    @Override
    protected abstract void setStatement(boolean var1);

    static abstract class LLVMIndirectBranchNodeImpl
    extends LLVMIndirectBranchNode {
        @Node.Children
        private final LLVMStatementNode[] phiWriteNodes;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final int[] successors;

        LLVMIndirectBranchNodeImpl(int[] indices, LLVMStatementNode[] phiWriteNodes) {
            assert (indices.length > 1);
            this.successors = indices;
            this.phiWriteNodes = phiWriteNodes;
        }

        @Override
        public int getSuccessorCount() {
            return this.successors.length;
        }

        @Override
        public LLVMStatementNode getPhiNode(int successorIndex) {
            return this.phiWriteNodes[successorIndex];
        }

        @Specialization
        public int doCondition(LLVMNativePointer branchAddress) {
            return (int)branchAddress.asNative();
        }

        @Override
        public int[] getSuccessors() {
            return this.successors;
        }
    }
}

