/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToVectorNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;

@GeneratedBy(value=LLVMToVectorNode.class)
public final class LLVMToVectorNodeFactory {

    @GeneratedBy(value=LLVMToVectorNode.LLVMBitcastToDoubleVectorNode.class)
    public static final class LLVMBitcastToDoubleVectorNodeGen
    extends LLVMToVectorNode.LLVMBitcastToDoubleVectorNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMBitcastToDoubleVectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0x1FE) == 0 && state != 0) {
                return this.executeGeneric_long0(frameValue, state);
            }
            if ((state & 0x1FD) == 0 && state != 0) {
                return this.executeGeneric_double1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_long0(VirtualFrame frameValue, int state) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doLong(fromNodeValue_);
        }

        private Object executeGeneric_double1(VirtualFrame frameValue, int state) {
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__ = (Long)fromNodeValue_;
                return this.doLong(fromNodeValue__);
            }
            if ((state & 2) != 0 && fromNodeValue_ instanceof Double) {
                double fromNodeValue__ = (Double)fromNodeValue_;
                return this.doDouble(fromNodeValue__);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                return this.doI1Vector(fromNodeValue__);
            }
            if ((state & 8) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                return this.doI8Vector(fromNodeValue__);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                return this.doI16Vector(fromNodeValue__);
            }
            if ((state & 0x20) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                return this.doI32Vector(fromNodeValue__);
            }
            if ((state & 0x40) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                return this.doFloatVector(fromNodeValue__);
            }
            if ((state & 0x80) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                return this.doI64Vector(fromNodeValue__);
            }
            if ((state & 0x100) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                return this.doDoubleVector(fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMDoubleVector executeAndSpecialize(Object fromNodeValue) {
            int state = this.state_;
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (Long)fromNodeValue;
                this.state_ = state |= 1;
                return this.doLong(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (Double)fromNodeValue;
                this.state_ = state |= 2;
                return this.doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_ = state |= 4;
                return this.doI1Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_ = state |= 8;
                return this.doI8Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_ = state |= 0x10;
                return this.doI16Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_ = state |= 0x20;
                return this.doI32Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                this.state_ = state |= 0x40;
                return this.doFloatVector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_ = state |= 0x80;
                return this.doI64Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_ = state |= 0x100;
                return this.doDoubleVector(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToVectorNode.LLVMBitcastToDoubleVectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMBitcastToDoubleVectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMBitcastToFloatVectorNode.class)
    public static final class LLVMBitcastToFloatVectorNodeGen
    extends LLVMToVectorNode.LLVMBitcastToFloatVectorNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMBitcastToFloatVectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0x1FE) == 0 && state != 0) {
                return this.executeGeneric_int0(frameValue, state);
            }
            if ((state & 0x1FD) == 0 && state != 0) {
                return this.executeGeneric_float1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_int0(VirtualFrame frameValue, int state) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doInt(fromNodeValue_);
        }

        private Object executeGeneric_float1(VirtualFrame frameValue, int state) {
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__ = (Integer)fromNodeValue_;
                return this.doInt(fromNodeValue__);
            }
            if ((state & 2) != 0 && fromNodeValue_ instanceof Float) {
                float fromNodeValue__ = ((Float)fromNodeValue_).floatValue();
                return this.doFloat(fromNodeValue__);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                return this.doI1Vector(fromNodeValue__);
            }
            if ((state & 8) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                return this.doI8Vector(fromNodeValue__);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                return this.doI16Vector(fromNodeValue__);
            }
            if ((state & 0x20) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                return this.doI32Vector(fromNodeValue__);
            }
            if ((state & 0x40) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                return this.doFloatVector(fromNodeValue__);
            }
            if ((state & 0x80) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                return this.doI64Vector(fromNodeValue__);
            }
            if ((state & 0x100) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                return this.doDoubleVector(fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMFloatVector executeAndSpecialize(Object fromNodeValue) {
            int state = this.state_;
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (Integer)fromNodeValue;
                this.state_ = state |= 1;
                return this.doInt(fromNodeValue_);
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = ((Float)fromNodeValue).floatValue();
                this.state_ = state |= 2;
                return this.doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_ = state |= 4;
                return this.doI1Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_ = state |= 8;
                return this.doI8Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_ = state |= 0x10;
                return this.doI16Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_ = state |= 0x20;
                return this.doI32Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                this.state_ = state |= 0x40;
                return this.doFloatVector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_ = state |= 0x80;
                return this.doI64Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_ = state |= 0x100;
                return this.doDoubleVector(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToVectorNode.LLVMBitcastToFloatVectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMBitcastToFloatVectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMBitcastToPointerVectorNode.class)
    public static final class LLVMBitcastToPointerVectorNodeGen
    extends LLVMToVectorNode.LLVMBitcastToPointerVectorNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMBitcastToPointerVectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (state != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                return this.doI64Vector(fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMPointerVector executeAndSpecialize(Object fromNodeValue) {
            int state = this.state_;
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_ = state |= 1;
                return this.doI64Vector(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMToVectorNode.LLVMBitcastToPointerVectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMBitcastToPointerVectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMBitcastToI64VectorNode.class)
    public static final class LLVMBitcastToI64VectorNodeGen
    extends LLVMToVectorNode.LLVMBitcastToI64VectorNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMBitcastToI64VectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0xFE) == 0 && state != 0) {
                return this.executeGeneric_long0(frameValue, state);
            }
            if ((state & 0xFD) == 0 && state != 0) {
                return this.executeGeneric_double1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_long0(VirtualFrame frameValue, int state) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_double1(VirtualFrame frameValue, int state) {
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__ = (Long)fromNodeValue_;
                return this.doI64(fromNodeValue__);
            }
            if ((state & 2) != 0 && fromNodeValue_ instanceof Double) {
                double fromNodeValue__ = (Double)fromNodeValue_;
                return this.doDouble(fromNodeValue__);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                return this.doI1Vector(fromNodeValue__);
            }
            if ((state & 8) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                return this.doI8Vector(fromNodeValue__);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                return this.doI16Vector(fromNodeValue__);
            }
            if ((state & 0x20) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                return this.doI32Vector(fromNodeValue__);
            }
            if ((state & 0x40) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                return this.doI64Vector(fromNodeValue__);
            }
            if ((state & 0x80) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                return this.doDoubleVector(fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMI64Vector executeAndSpecialize(Object fromNodeValue) {
            int state = this.state_;
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (Long)fromNodeValue;
                this.state_ = state |= 1;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (Double)fromNodeValue;
                this.state_ = state |= 2;
                return this.doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_ = state |= 4;
                return this.doI1Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_ = state |= 8;
                return this.doI8Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_ = state |= 0x10;
                return this.doI16Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_ = state |= 0x20;
                return this.doI32Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_ = state |= 0x40;
                return this.doI64Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_ = state |= 0x80;
                return this.doDoubleVector(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToVectorNode.LLVMBitcastToI64VectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMBitcastToI64VectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMBitcastToI32VectorNode.class)
    public static final class LLVMBitcastToI32VectorNodeGen
    extends LLVMToVectorNode.LLVMBitcastToI32VectorNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMBitcastToI32VectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0x7FE) == 0 && state != 0) {
                return this.executeGeneric_int0(frameValue, state);
            }
            if ((state & 0x7FD) == 0 && state != 0) {
                return this.executeGeneric_float1(frameValue, state);
            }
            if ((state & 0x7FB) == 0 && state != 0) {
                return this.executeGeneric_long2(frameValue, state);
            }
            if ((state & 0x7F7) == 0 && state != 0) {
                return this.executeGeneric_double3(frameValue, state);
            }
            return this.executeGeneric_generic4(frameValue, state);
        }

        private Object executeGeneric_int0(VirtualFrame frameValue, int state) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_float1(VirtualFrame frameValue, int state) {
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private Object executeGeneric_long2(VirtualFrame frameValue, int state) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_double3(VirtualFrame frameValue, int state) {
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 8) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_generic4(VirtualFrame frameValue, int state) {
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__ = (Integer)fromNodeValue_;
                return this.doI32(fromNodeValue__);
            }
            if ((state & 2) != 0 && fromNodeValue_ instanceof Float) {
                float fromNodeValue__ = ((Float)fromNodeValue_).floatValue();
                return this.doFloat(fromNodeValue__);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__ = (Long)fromNodeValue_;
                return this.doI64(fromNodeValue__);
            }
            if ((state & 8) != 0 && fromNodeValue_ instanceof Double) {
                double fromNodeValue__ = (Double)fromNodeValue_;
                return this.doDouble(fromNodeValue__);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                return this.doI1Vector(fromNodeValue__);
            }
            if ((state & 0x20) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                return this.doI8Vector(fromNodeValue__);
            }
            if ((state & 0x40) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                return this.doI16Vector(fromNodeValue__);
            }
            if ((state & 0x80) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                return this.doI32Vector(fromNodeValue__);
            }
            if ((state & 0x100) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                return this.doI64Vector(fromNodeValue__);
            }
            if ((state & 0x200) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                return this.doFloatVector(fromNodeValue__);
            }
            if ((state & 0x400) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                return this.doDoubleVector(fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMI32Vector executeAndSpecialize(Object fromNodeValue) {
            int state = this.state_;
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (Integer)fromNodeValue;
                this.state_ = state |= 1;
                return this.doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = ((Float)fromNodeValue).floatValue();
                this.state_ = state |= 2;
                return this.doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (Long)fromNodeValue;
                this.state_ = state |= 4;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (Double)fromNodeValue;
                this.state_ = state |= 8;
                return this.doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_ = state |= 0x10;
                return this.doI1Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_ = state |= 0x20;
                return this.doI8Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_ = state |= 0x40;
                return this.doI16Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_ = state |= 0x80;
                return this.doI32Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_ = state |= 0x100;
                return this.doI64Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                this.state_ = state |= 0x200;
                return this.doFloatVector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_ = state |= 0x400;
                return this.doDoubleVector(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToVectorNode.LLVMBitcastToI32VectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMBitcastToI32VectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMBitcastToI16VectorNode.class)
    public static final class LLVMBitcastToI16VectorNodeGen
    extends LLVMToVectorNode.LLVMBitcastToI16VectorNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMBitcastToI16VectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0xFFE) == 0 && state != 0) {
                return this.executeGeneric_short0(frameValue, state);
            }
            if ((state & 0xFFD) == 0 && state != 0) {
                return this.executeGeneric_int1(frameValue, state);
            }
            if ((state & 0xFFB) == 0 && state != 0) {
                return this.executeGeneric_long2(frameValue, state);
            }
            if ((state & 0xFF7) == 0 && state != 0) {
                return this.executeGeneric_float3(frameValue, state);
            }
            if ((state & 0xFEF) == 0 && state != 0) {
                return this.executeGeneric_double4(frameValue, state);
            }
            return this.executeGeneric_generic5(frameValue, state);
        }

        private Object executeGeneric_short0(VirtualFrame frameValue, int state) {
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doI16(fromNodeValue_);
        }

        private Object executeGeneric_int1(VirtualFrame frameValue, int state) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_long2(VirtualFrame frameValue, int state) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_float3(VirtualFrame frameValue, int state) {
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 8) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private Object executeGeneric_double4(VirtualFrame frameValue, int state) {
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x10) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_generic5(VirtualFrame frameValue, int state) {
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && fromNodeValue_ instanceof Short) {
                short fromNodeValue__ = (Short)fromNodeValue_;
                return this.doI16(fromNodeValue__);
            }
            if ((state & 2) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__ = (Integer)fromNodeValue_;
                return this.doI32(fromNodeValue__);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__ = (Long)fromNodeValue_;
                return this.doI64(fromNodeValue__);
            }
            if ((state & 8) != 0 && fromNodeValue_ instanceof Float) {
                float fromNodeValue__ = ((Float)fromNodeValue_).floatValue();
                return this.doFloat(fromNodeValue__);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof Double) {
                double fromNodeValue__ = (Double)fromNodeValue_;
                return this.doDouble(fromNodeValue__);
            }
            if ((state & 0x20) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                return this.do80BitFloat(fromNodeValue__);
            }
            if ((state & 0x40) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                return this.doI1Vector(fromNodeValue__);
            }
            if ((state & 0x80) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                return this.doI8Vector(fromNodeValue__);
            }
            if ((state & 0x100) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                return this.doI16Vector(fromNodeValue__);
            }
            if ((state & 0x200) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                return this.doI32Vector(fromNodeValue__);
            }
            if ((state & 0x400) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                return this.doI64Vector(fromNodeValue__);
            }
            if ((state & 0x800) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                return this.doDoubleVector(fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMI16Vector executeAndSpecialize(Object fromNodeValue) {
            int state = this.state_;
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_ = (Short)fromNodeValue;
                this.state_ = state |= 1;
                return this.doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (Integer)fromNodeValue;
                this.state_ = state |= 2;
                return this.doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (Long)fromNodeValue;
                this.state_ = state |= 4;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = ((Float)fromNodeValue).floatValue();
                this.state_ = state |= 8;
                return this.doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (Double)fromNodeValue;
                this.state_ = state |= 0x10;
                return this.doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat)fromNodeValue;
                this.state_ = state |= 0x20;
                return this.do80BitFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_ = state |= 0x40;
                return this.doI1Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_ = state |= 0x80;
                return this.doI8Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_ = state |= 0x100;
                return this.doI16Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_ = state |= 0x200;
                return this.doI32Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_ = state |= 0x400;
                return this.doI64Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_ = state |= 0x800;
                return this.doDoubleVector(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToVectorNode.LLVMBitcastToI16VectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMBitcastToI16VectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMBitcastToI8VectorNode.class)
    public static final class LLVMBitcastToI8VectorNodeGen
    extends LLVMToVectorNode.LLVMBitcastToI8VectorNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMBitcastToI8VectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0x1FFE) == 0 && state != 0) {
                return this.executeGeneric_byte0(frameValue, state);
            }
            if ((state & 0x1FFD) == 0 && state != 0) {
                return this.executeGeneric_short1(frameValue, state);
            }
            if ((state & 0x1FFB) == 0 && state != 0) {
                return this.executeGeneric_int2(frameValue, state);
            }
            if ((state & 0x1FF7) == 0 && state != 0) {
                return this.executeGeneric_long3(frameValue, state);
            }
            if ((state & 0x1FEF) == 0 && state != 0) {
                return this.executeGeneric_float4(frameValue, state);
            }
            if ((state & 0x1FDF) == 0 && state != 0) {
                return this.executeGeneric_double5(frameValue, state);
            }
            return this.executeGeneric_generic6(frameValue, state);
        }

        private Object executeGeneric_byte0(VirtualFrame frameValue, int state) {
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doI8(fromNodeValue_);
        }

        private Object executeGeneric_short1(VirtualFrame frameValue, int state) {
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doI16(fromNodeValue_);
        }

        private Object executeGeneric_int2(VirtualFrame frameValue, int state) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_long3(VirtualFrame frameValue, int state) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 8) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_float4(VirtualFrame frameValue, int state) {
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x10) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private Object executeGeneric_double5(VirtualFrame frameValue, int state) {
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x20) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_generic6(VirtualFrame frameValue, int state) {
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && fromNodeValue_ instanceof Byte) {
                byte fromNodeValue__ = (Byte)fromNodeValue_;
                return this.doI8(fromNodeValue__);
            }
            if ((state & 2) != 0 && fromNodeValue_ instanceof Short) {
                short fromNodeValue__ = (Short)fromNodeValue_;
                return this.doI16(fromNodeValue__);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__ = (Integer)fromNodeValue_;
                return this.doI32(fromNodeValue__);
            }
            if ((state & 8) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__ = (Long)fromNodeValue_;
                return this.doI64(fromNodeValue__);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof Float) {
                float fromNodeValue__ = ((Float)fromNodeValue_).floatValue();
                return this.doFloat(fromNodeValue__);
            }
            if ((state & 0x20) != 0 && fromNodeValue_ instanceof Double) {
                double fromNodeValue__ = (Double)fromNodeValue_;
                return this.doDouble(fromNodeValue__);
            }
            if ((state & 0x40) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                return this.do80BitFloat(fromNodeValue__);
            }
            if ((state & 0x80) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                return this.doI1Vector(fromNodeValue__);
            }
            if ((state & 0x100) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                return this.doI8Vector(fromNodeValue__);
            }
            if ((state & 0x200) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                return this.doI16Vector(fromNodeValue__);
            }
            if ((state & 0x400) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                return this.doI32Vector(fromNodeValue__);
            }
            if ((state & 0x800) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                return this.doI64Vector(fromNodeValue__);
            }
            if ((state & 0x1000) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                return this.doDoubleVector(fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMI8Vector executeAndSpecialize(Object fromNodeValue) {
            int state = this.state_;
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_ = (Byte)fromNodeValue;
                this.state_ = state |= 1;
                return this.doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_ = (Short)fromNodeValue;
                this.state_ = state |= 2;
                return this.doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (Integer)fromNodeValue;
                this.state_ = state |= 4;
                return this.doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (Long)fromNodeValue;
                this.state_ = state |= 8;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = ((Float)fromNodeValue).floatValue();
                this.state_ = state |= 0x10;
                return this.doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (Double)fromNodeValue;
                this.state_ = state |= 0x20;
                return this.doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat)fromNodeValue;
                this.state_ = state |= 0x40;
                return this.do80BitFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_ = state |= 0x80;
                return this.doI1Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_ = state |= 0x100;
                return this.doI8Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_ = state |= 0x200;
                return this.doI16Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_ = state |= 0x400;
                return this.doI32Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_ = state |= 0x800;
                return this.doI64Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_ = state |= 0x1000;
                return this.doDoubleVector(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToVectorNode.LLVMBitcastToI8VectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMBitcastToI8VectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMBitcastToI1VectorNode.class)
    public static final class LLVMBitcastToI1VectorNodeGen
    extends LLVMToVectorNode.LLVMBitcastToI1VectorNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMBitcastToI1VectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0x3FFE) == 0 && state != 0) {
                return this.executeGeneric_boolean0(frameValue, state);
            }
            if ((state & 0x3FFD) == 0 && state != 0) {
                return this.executeGeneric_byte1(frameValue, state);
            }
            if ((state & 0x3FFB) == 0 && state != 0) {
                return this.executeGeneric_short2(frameValue, state);
            }
            if ((state & 0x3FF7) == 0 && state != 0) {
                return this.executeGeneric_int3(frameValue, state);
            }
            if ((state & 0x3FEF) == 0 && state != 0) {
                return this.executeGeneric_long4(frameValue, state);
            }
            if ((state & 0x3FDF) == 0 && state != 0) {
                return this.executeGeneric_float5(frameValue, state);
            }
            if ((state & 0x3FBF) == 0 && state != 0) {
                return this.executeGeneric_double6(frameValue, state);
            }
            return this.executeGeneric_generic7(frameValue, state);
        }

        private Object executeGeneric_boolean0(VirtualFrame frameValue, int state) {
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doI1(fromNodeValue_);
        }

        private Object executeGeneric_byte1(VirtualFrame frameValue, int state) {
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doI8(fromNodeValue_);
        }

        private Object executeGeneric_short2(VirtualFrame frameValue, int state) {
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.doI16(fromNodeValue_);
        }

        private Object executeGeneric_int3(VirtualFrame frameValue, int state) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 8) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_long4(VirtualFrame frameValue, int state) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x10) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_float5(VirtualFrame frameValue, int state) {
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x20) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private Object executeGeneric_double6(VirtualFrame frameValue, int state) {
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x40) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_generic7(VirtualFrame frameValue, int state) {
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && fromNodeValue_ instanceof Boolean) {
                boolean fromNodeValue__ = (Boolean)fromNodeValue_;
                return this.doI1(fromNodeValue__);
            }
            if ((state & 2) != 0 && fromNodeValue_ instanceof Byte) {
                byte fromNodeValue__ = (Byte)fromNodeValue_;
                return this.doI8(fromNodeValue__);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof Short) {
                short fromNodeValue__ = (Short)fromNodeValue_;
                return this.doI16(fromNodeValue__);
            }
            if ((state & 8) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__ = (Integer)fromNodeValue_;
                return this.doI32(fromNodeValue__);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__ = (Long)fromNodeValue_;
                return this.doI64(fromNodeValue__);
            }
            if ((state & 0x20) != 0 && fromNodeValue_ instanceof Float) {
                float fromNodeValue__ = ((Float)fromNodeValue_).floatValue();
                return this.doFloat(fromNodeValue__);
            }
            if ((state & 0x40) != 0 && fromNodeValue_ instanceof Double) {
                double fromNodeValue__ = (Double)fromNodeValue_;
                return this.doDouble(fromNodeValue__);
            }
            if ((state & 0x80) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                return this.do80BitFloat(fromNodeValue__);
            }
            if ((state & 0x100) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                return this.doI1Vector(fromNodeValue__);
            }
            if ((state & 0x200) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                return this.doI8Vector(fromNodeValue__);
            }
            if ((state & 0x400) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                return this.doI16Vector(fromNodeValue__);
            }
            if ((state & 0x800) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                return this.doI32Vector(fromNodeValue__);
            }
            if ((state & 0x1000) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                return this.doI64Vector(fromNodeValue__);
            }
            if ((state & 0x2000) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                return this.doDoubleVector(fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMI1Vector executeAndSpecialize(Object fromNodeValue) {
            int state = this.state_;
            if (fromNodeValue instanceof Boolean) {
                boolean fromNodeValue_ = (Boolean)fromNodeValue;
                this.state_ = state |= 1;
                return this.doI1(fromNodeValue_);
            }
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_ = (Byte)fromNodeValue;
                this.state_ = state |= 2;
                return this.doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_ = (Short)fromNodeValue;
                this.state_ = state |= 4;
                return this.doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (Integer)fromNodeValue;
                this.state_ = state |= 8;
                return this.doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (Long)fromNodeValue;
                this.state_ = state |= 0x10;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = ((Float)fromNodeValue).floatValue();
                this.state_ = state |= 0x20;
                return this.doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (Double)fromNodeValue;
                this.state_ = state |= 0x40;
                return this.doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat)fromNodeValue;
                this.state_ = state |= 0x80;
                return this.do80BitFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_ = state |= 0x100;
                return this.doI1Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_ = state |= 0x200;
                return this.doI8Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_ = state |= 0x400;
                return this.doI16Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_ = state |= 0x800;
                return this.doI32Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_ = state |= 0x1000;
                return this.doI64Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_ = state |= 0x2000;
                return this.doDoubleVector(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToVectorNode.LLVMBitcastToI1VectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMBitcastToI1VectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMSignedCastToDoubleVectorNode.class)
    public static final class LLVMSignedCastToDoubleVectorNodeGen
    extends LLVMToVectorNode.LLVMSignedCastToDoubleVectorNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMSignedCastToDoubleVectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                return this.doI1(fromNodeValue__);
            }
            if ((state & 2) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                return this.doI8(fromNodeValue__);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                return this.doI16(fromNodeValue__);
            }
            if ((state & 8) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                return this.doI32(fromNodeValue__);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                return this.doI64(fromNodeValue__);
            }
            if ((state & 0x20) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                return this.doFloat(fromNodeValue__);
            }
            if ((state & 0x40) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                return this.doDouble(fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMDoubleVector executeAndSpecialize(Object fromNodeValue) {
            int state = this.state_;
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_ = state |= 1;
                return this.doI1(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_ = state |= 2;
                return this.doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_ = state |= 4;
                return this.doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_ = state |= 8;
                return this.doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_ = state |= 0x10;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                this.state_ = state |= 0x20;
                return this.doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_ = state |= 0x40;
                return this.doDouble(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToVectorNode.LLVMSignedCastToDoubleVectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMSignedCastToDoubleVectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMSignedCastToFloatVectorNode.class)
    public static final class LLVMSignedCastToFloatVectorNodeGen
    extends LLVMToVectorNode.LLVMSignedCastToFloatVectorNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMSignedCastToFloatVectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                return this.doI1(fromNodeValue__);
            }
            if ((state & 2) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                return this.doI8(fromNodeValue__);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                return this.doI16(fromNodeValue__);
            }
            if ((state & 8) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                return this.doI32(fromNodeValue__);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                return this.doI64(fromNodeValue__);
            }
            if ((state & 0x20) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                return this.doFloat(fromNodeValue__);
            }
            if ((state & 0x40) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                return this.doDouble(fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMFloatVector executeAndSpecialize(Object fromNodeValue) {
            int state = this.state_;
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_ = state |= 1;
                return this.doI1(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_ = state |= 2;
                return this.doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_ = state |= 4;
                return this.doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_ = state |= 8;
                return this.doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_ = state |= 0x10;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                this.state_ = state |= 0x20;
                return this.doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_ = state |= 0x40;
                return this.doDouble(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToVectorNode.LLVMSignedCastToFloatVectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMSignedCastToFloatVectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMSignedCastToI64VectorNode.class)
    public static final class LLVMSignedCastToI64VectorNodeGen
    extends LLVMToVectorNode.LLVMSignedCastToI64VectorNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMSignedCastToI64VectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                return this.doI1(fromNodeValue__);
            }
            if ((state & 2) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                return this.doI8(fromNodeValue__);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                return this.doI16(fromNodeValue__);
            }
            if ((state & 8) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                return this.doI32(fromNodeValue__);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                return this.doI64(fromNodeValue__);
            }
            if ((state & 0x20) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                return this.doFloat(fromNodeValue__);
            }
            if ((state & 0x40) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                return this.doDouble(fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMI64Vector executeAndSpecialize(Object fromNodeValue) {
            int state = this.state_;
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_ = state |= 1;
                return this.doI1(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_ = state |= 2;
                return this.doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_ = state |= 4;
                return this.doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_ = state |= 8;
                return this.doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_ = state |= 0x10;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                this.state_ = state |= 0x20;
                return this.doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_ = state |= 0x40;
                return this.doDouble(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToVectorNode.LLVMSignedCastToI64VectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMSignedCastToI64VectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMSignedCastToI32VectorNode.class)
    public static final class LLVMSignedCastToI32VectorNodeGen
    extends LLVMToVectorNode.LLVMSignedCastToI32VectorNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMSignedCastToI32VectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                return this.doI1(fromNodeValue__);
            }
            if ((state & 2) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                return this.doI8(fromNodeValue__);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                return this.doI16(fromNodeValue__);
            }
            if ((state & 8) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                return this.doI32(fromNodeValue__);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                return this.doI64(fromNodeValue__);
            }
            if ((state & 0x20) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                return this.doFloat(fromNodeValue__);
            }
            if ((state & 0x40) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                return this.doDouble(fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMI32Vector executeAndSpecialize(Object fromNodeValue) {
            int state = this.state_;
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_ = state |= 1;
                return this.doI1(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_ = state |= 2;
                return this.doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_ = state |= 4;
                return this.doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_ = state |= 8;
                return this.doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_ = state |= 0x10;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                this.state_ = state |= 0x20;
                return this.doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_ = state |= 0x40;
                return this.doDouble(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToVectorNode.LLVMSignedCastToI32VectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMSignedCastToI32VectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMSignedCastToI16VectorNode.class)
    public static final class LLVMSignedCastToI16VectorNodeGen
    extends LLVMToVectorNode.LLVMSignedCastToI16VectorNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMSignedCastToI16VectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                return this.doI1(fromNodeValue__);
            }
            if ((state & 2) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                return this.doI8(fromNodeValue__);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                return this.doI16(fromNodeValue__);
            }
            if ((state & 8) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                return this.doI32(fromNodeValue__);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                return this.doI64(fromNodeValue__);
            }
            if ((state & 0x20) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                return this.doFloat(fromNodeValue__);
            }
            if ((state & 0x40) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                return this.doDouble(fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMI16Vector executeAndSpecialize(Object fromNodeValue) {
            int state = this.state_;
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_ = state |= 1;
                return this.doI1(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_ = state |= 2;
                return this.doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_ = state |= 4;
                return this.doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_ = state |= 8;
                return this.doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_ = state |= 0x10;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                this.state_ = state |= 0x20;
                return this.doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_ = state |= 0x40;
                return this.doDouble(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToVectorNode.LLVMSignedCastToI16VectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMSignedCastToI16VectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMSignedCastToI8VectorNode.class)
    public static final class LLVMSignedCastToI8VectorNodeGen
    extends LLVMToVectorNode.LLVMSignedCastToI8VectorNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMSignedCastToI8VectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                return this.doI1(fromNodeValue__);
            }
            if ((state & 2) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                return this.doI8(fromNodeValue__);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                return this.doI16(fromNodeValue__);
            }
            if ((state & 8) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                return this.doI32(fromNodeValue__);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                return this.doI64(fromNodeValue__);
            }
            if ((state & 0x20) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                return this.doFloat(fromNodeValue__);
            }
            if ((state & 0x40) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                return this.doDouble(fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMI8Vector executeAndSpecialize(Object fromNodeValue) {
            int state = this.state_;
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_ = state |= 1;
                return this.doI1(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_ = state |= 2;
                return this.doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_ = state |= 4;
                return this.doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_ = state |= 8;
                return this.doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_ = state |= 0x10;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                this.state_ = state |= 0x20;
                return this.doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_ = state |= 0x40;
                return this.doDouble(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToVectorNode.LLVMSignedCastToI8VectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMSignedCastToI8VectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMSignedCastToI1VectorNode.class)
    public static final class LLVMSignedCastToI1VectorNodeGen
    extends LLVMToVectorNode.LLVMSignedCastToI1VectorNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMSignedCastToI1VectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                return this.doI1(fromNodeValue__);
            }
            if ((state & 2) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                return this.doI8(fromNodeValue__);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                return this.doI16(fromNodeValue__);
            }
            if ((state & 8) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                return this.doI32(fromNodeValue__);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                return this.doI64(fromNodeValue__);
            }
            if ((state & 0x20) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                return this.doFloat(fromNodeValue__);
            }
            if ((state & 0x40) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                return this.doDouble(fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMI1Vector executeAndSpecialize(Object fromNodeValue) {
            int state = this.state_;
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_ = state |= 1;
                return this.doI1(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_ = state |= 2;
                return this.doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_ = state |= 4;
                return this.doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_ = state |= 8;
                return this.doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_ = state |= 0x10;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                this.state_ = state |= 0x20;
                return this.doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_ = state |= 0x40;
                return this.doDouble(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToVectorNode.LLVMSignedCastToI1VectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMSignedCastToI1VectorNodeGen(fromNode, vectorLength);
        }
    }
}

