/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;

@NodeChild(value="fromNode", type=LLVMExpressionNode.class)
public abstract class LLVMToI64Node
extends LLVMExpressionNode {
    private static final float MAX_LONG_AS_FLOAT = 9.223372E18f;
    private static final double MAX_LONG_AS_DOUBLE = 9.223372036854776E18;

    public abstract Object executeWithTarget(Object var1);

    @Specialization
    protected long doNative(LLVMNativePointer from) {
        return from.asNative();
    }

    @Specialization
    protected Object doManaged(LLVMManagedPointer from) {
        return from;
    }

    public static abstract class LLVMBitcastToI64Node
    extends LLVMToI64Node {
        @Specialization
        protected long doI64(double from) {
            return Double.doubleToRawLongBits(from);
        }

        @Specialization
        protected long doI64(long from) {
            return from;
        }

        @Specialization
        protected long doI1Vector(LLVMI1Vector from) {
            return LLVMBitcastToI64Node.castI1Vector(from, 64);
        }

        @Specialization
        protected long doI8Vector(LLVMI8Vector from) {
            return LLVMBitcastToI64Node.castI8Vector(from, 8);
        }

        @Specialization
        protected long doI16Vector(LLVMI16Vector from) {
            return LLVMBitcastToI64Node.castI16Vector(from, 4);
        }

        @Specialization
        protected long doI32Vector(LLVMI32Vector from) {
            return LLVMBitcastToI64Node.castI32Vector(from, 2);
        }

        @Specialization
        protected long doFloatVector(LLVMFloatVector from) {
            return LLVMBitcastToI64Node.castFloatVector(from, 2);
        }

        @Specialization
        protected long doI64Vector(LLVMI64Vector from) {
            assert (from.getLength() == 1) : "invalid vector size";
            return from.getValue(0);
        }

        @Specialization
        protected long doDoubleVector(LLVMDoubleVector from) {
            assert (from.getLength() == 1) : "invalid vector size";
            return Double.doubleToLongBits(from.getValue(0));
        }

        @ExplodeLoop
        protected static long castI1Vector(LLVMI1Vector from, int elem) {
            assert (from.getLength() == elem) : "invalid vector size";
            long res = 0L;
            for (int i = 0; i < elem; ++i) {
                res |= (from.getValue(i) ? 1L : 0L) << i;
            }
            return res;
        }

        @ExplodeLoop
        protected static long castI8Vector(LLVMI8Vector from, int elem) {
            assert (from.getLength() == elem) : "invalid vector size";
            long res = 0L;
            for (int i = 0; i < elem; ++i) {
                res |= (long)(from.getValue(i) & 0xFF) << i * 8;
            }
            return res;
        }

        @ExplodeLoop
        protected static long castI16Vector(LLVMI16Vector from, int elem) {
            assert (from.getLength() == elem) : "invalid vector size";
            long res = 0L;
            for (int i = 0; i < elem; ++i) {
                res |= (long)(from.getValue(i) & 0xFFFF) << i * 16;
            }
            return res;
        }

        @ExplodeLoop
        protected static long castI32Vector(LLVMI32Vector from, int elem) {
            assert (from.getLength() == elem) : "invalid vector size";
            long res = 0L;
            for (int i = 0; i < elem; ++i) {
                res |= ((long)from.getValue(i) & 0xFFFFFFFFL) << i * 32;
            }
            return res;
        }

        @ExplodeLoop
        protected static long castFloatVector(LLVMFloatVector from, int elem) {
            assert (from.getLength() == elem) : "invalid vector size";
            long res = 0L;
            for (int i = 0; i < elem; ++i) {
                res |= ((long)Float.floatToIntBits(from.getValue(i)) & 0xFFFFFFFFL) << i * 32;
            }
            return res;
        }
    }

    public static abstract class LLVMUnsignedCastToI64Node
    extends LLVMToI64Node {
        @Specialization
        protected long doI1(boolean from) {
            return from ? 1L : 0L;
        }

        @Specialization
        protected long doI8(byte from) {
            return from & 0xFF;
        }

        @Specialization
        protected long doI16(short from) {
            return from & 0xFFFF;
        }

        @Specialization
        protected long doI32(int from) {
            return (long)from & 0xFFFFFFFFL;
        }

        @Specialization
        protected long doI64(long from) {
            return from;
        }

        @Specialization
        protected long doIVarBit(LLVMIVarBit from) {
            return from.getZeroExtendedLongValue();
        }

        private static boolean fitsIntoSignedLong(float from) {
            return from < 9.223372E18f;
        }

        private static boolean fitsIntoSignedLong(double from) {
            return from < 9.223372036854776E18;
        }

        @Specialization
        protected long doFloat(float from, @Cached ConditionProfile profile) {
            if (profile.profile(LLVMUnsignedCastToI64Node.fitsIntoSignedLong(from))) {
                return (long)from;
            }
            return (long)(from + -9.223372E18f) - Long.MIN_VALUE;
        }

        @Specialization
        protected long doDouble(double from, @Cached ConditionProfile profile) {
            if (profile.profile(LLVMUnsignedCastToI64Node.fitsIntoSignedLong(from))) {
                return (long)from;
            }
            return (long)(from + -9.223372036854776E18) - Long.MIN_VALUE;
        }

        @Specialization
        protected long do80LLVMBitFloat(LLVM80BitFloat from) {
            return from.getLongValue();
        }
    }

    public static abstract class LLVMSignedCastToI64Node
    extends LLVMToI64Node {
        @Specialization
        protected long doI64(boolean from) {
            return from ? -1L : 0L;
        }

        @Specialization
        protected long doI64(byte from) {
            return from;
        }

        @Specialization
        protected long doI64(short from) {
            return from;
        }

        @Specialization
        protected long doI64(int from) {
            return from;
        }

        @Specialization
        protected long doI64(long from) {
            return from;
        }

        @Specialization
        protected long doI64(LLVMIVarBit from) {
            return from.getLongValue();
        }

        @Specialization
        protected long doI64(float from) {
            return (long)from;
        }

        @Specialization
        protected long doI64(double from) {
            return (long)from;
        }

        @Specialization
        protected long doI64(LLVM80BitFloat from) {
            return from.getLongValue();
        }
    }
}

