/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToDoubleNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMToDoubleNode.class)
public final class LLVMToDoubleNodeGen
extends LLVMToDoubleNode {
    private static final LibraryFactory<LLVMAsForeignLibrary> L_L_V_M_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private LLVMSourceLocation sourceLocation;
    private boolean statement;
    @Node.Child
    private LLVMExpressionNode fromNode_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @Node.Child
    private ManagedPointerData managedPointer_cache;
    @Node.Child
    private LLVMToNativeNode pointer_toNative_;
    @Node.Child
    private LLVMToDoubleNode pointer_recursive_;

    private LLVMToDoubleNodeGen(LLVMExpressionNode fromNode) {
        this.fromNode_ = fromNode;
    }

    @Override
    public LLVMSourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    protected boolean isStatement() {
        return this.statement;
    }

    @Override
    protected void setStatement(boolean statement) {
        this.statement = statement;
    }

    @Override
    protected double executeWith(long fromNodeValue) {
        throw CompilerDirectives.shouldNotReachHere((String)"Delegation failed.");
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        LLVMPointer fromNodeValue__;
        int state = this.state_;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if ((state & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
            fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
            ManagedPointerData s1_ = this.managedPointer_cache;
            if (s1_ != null && LLVMToDoubleNode.isForeignNumber(fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.recursive_, s1_.foreigns_, s1_.interop_);
            }
        }
        if ((state & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
            fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
            return this.doPointer(fromNodeValue__, this.pointer_toNative_, this.pointer_recursive_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(fromNodeValue_);
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) {
        LLVMPointer fromNodeValue__;
        int state = this.state_;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if ((state & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
            fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
            ManagedPointerData s1_ = this.managedPointer_cache;
            if (s1_ != null && LLVMToDoubleNode.isForeignNumber(fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.recursive_, s1_.foreigns_, s1_.interop_);
            }
        }
        if ((state & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
            fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
            return this.doPointer(fromNodeValue__, this.pointer_toNative_, this.pointer_recursive_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(fromNodeValue_);
    }

    private double executeAndSpecialize(Object fromNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            InteropLibrary interop__;
            LLVMAsForeignLibrary foreigns__;
            LLVMPointer fromNodeValue_;
            if (LLVMTypes.isManagedPointer(fromNodeValue) && LLVMToDoubleNode.isForeignNumber(fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue), foreigns__ = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)), interop__ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(3)))) {
                ManagedPointerData s1_ = (ManagedPointerData)super.insert((Node)new ManagedPointerData());
                s1_.toLLVM_ = s1_.insertAccessor(this.createForeignToLLVM());
                s1_.recursive_ = s1_.insertAccessor(this.createRecursive());
                s1_.foreigns_ = s1_.insertAccessor(foreigns__);
                s1_.interop_ = s1_.insertAccessor(interop__);
                this.managedPointer_cache = s1_;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                double d = this.doManagedPointer((LLVMManagedPointer)fromNodeValue_, s1_.toLLVM_, s1_.recursive_, foreigns__, interop__);
                return d;
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                this.pointer_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                this.pointer_recursive_ = (LLVMToDoubleNode)super.insert((Node)this.createRecursive());
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                double d = this.doPointer(fromNodeValue_, this.pointer_toNative_, this.pointer_recursive_);
                return d;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMToDoubleNode create(LLVMExpressionNode fromNode) {
        return new LLVMToDoubleNodeGen(fromNode);
    }

    @GeneratedBy(value=LLVMToDoubleNode.LLVMBitcastToDoubleNode.class)
    public static final class LLVMBitcastToDoubleNodeGen
    extends LLVMToDoubleNode.LLVMBitcastToDoubleNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private ManagedPointerData managedPointer_cache;
        @Node.Child
        private LLVMToNativeNode pointer_toNative_;
        @Node.Child
        private LLVMToDoubleNode pointer_recursive_;

        private LLVMBitcastToDoubleNodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected double executeWith(long fromNodeValue) {
            int state = this.state_;
            if ((state & 4) != 0) {
                return this.doDouble(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0xFFB) == 0 && state != 0) {
                return this.executeGeneric_long0(frameValue, state);
            }
            if ((state & 0xFF7) == 0 && state != 0) {
                return this.executeGeneric_double1(frameValue, state);
            }
            if ((state & 0xFEF) == 0 && state != 0) {
                return this.executeGeneric_float2(frameValue, state);
            }
            return this.executeGeneric_generic3(frameValue, state);
        }

        private Object executeGeneric_long0(VirtualFrame frameValue, int state) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_double1(VirtualFrame frameValue, int state) {
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 8) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_float2(VirtualFrame frameValue, int state) {
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x10) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private Object executeGeneric_generic3(VirtualFrame frameValue, int state) {
            Object fromNodeValue__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s1_ = this.managedPointer_cache;
                if (s1_ != null && LLVMToDoubleNode.isForeignNumber((LLVMManagedPointer)fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                    return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.recursive_, s1_.foreigns_, s1_.interop_);
                }
            }
            if ((state & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer((LLVMPointer)fromNodeValue__, this.pointer_toNative_, this.pointer_recursive_);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__2 = (Long)fromNodeValue_;
                return this.doDouble(fromNodeValue__2);
            }
            if ((state & 8) != 0 && fromNodeValue_ instanceof Double) {
                double fromNodeValue__3 = (Double)fromNodeValue_;
                return this.doDouble(fromNodeValue__3);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof Float) {
                float fromNodeValue__4 = ((Float)fromNodeValue_).floatValue();
                return this.doFloat(fromNodeValue__4);
            }
            if ((state & 0x20) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                return this.doI1Vector((LLVMI1Vector)fromNodeValue__);
            }
            if ((state & 0x40) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                return this.doI8Vector((LLVMI8Vector)fromNodeValue__);
            }
            if ((state & 0x80) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                return this.doI16Vector((LLVMI16Vector)fromNodeValue__);
            }
            if ((state & 0x100) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                return this.doI32Vector((LLVMI32Vector)fromNodeValue__);
            }
            if ((state & 0x200) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                return this.doFloatVector((LLVMFloatVector)fromNodeValue__);
            }
            if ((state & 0x400) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                return this.doI64Vector((LLVMI64Vector)fromNodeValue__);
            }
            if ((state & 0x800) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                return this.doDoubleVector((LLVMDoubleVector)fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0xFFB) == 0 && state != 0) {
                return this.executeDouble_long4(frameValue, state);
            }
            if ((state & 0xFF7) == 0 && state != 0) {
                return this.executeDouble_double5(frameValue, state);
            }
            if ((state & 0xFEF) == 0 && state != 0) {
                return this.executeDouble_float6(frameValue, state);
            }
            return this.executeDouble_generic7(frameValue, state);
        }

        private double executeDouble_long4(VirtualFrame frameValue, int state) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_double5(VirtualFrame frameValue, int state) {
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 8) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_float6(VirtualFrame frameValue, int state) {
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x10) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private double executeDouble_generic7(VirtualFrame frameValue, int state) {
            Object fromNodeValue__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s1_ = this.managedPointer_cache;
                if (s1_ != null && LLVMToDoubleNode.isForeignNumber((LLVMManagedPointer)fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                    return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.recursive_, s1_.foreigns_, s1_.interop_);
                }
            }
            if ((state & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer((LLVMPointer)fromNodeValue__, this.pointer_toNative_, this.pointer_recursive_);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__2 = (Long)fromNodeValue_;
                return this.doDouble(fromNodeValue__2);
            }
            if ((state & 8) != 0 && fromNodeValue_ instanceof Double) {
                double fromNodeValue__3 = (Double)fromNodeValue_;
                return this.doDouble(fromNodeValue__3);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof Float) {
                float fromNodeValue__4 = ((Float)fromNodeValue_).floatValue();
                return this.doFloat(fromNodeValue__4);
            }
            if ((state & 0x20) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                return this.doI1Vector((LLVMI1Vector)fromNodeValue__);
            }
            if ((state & 0x40) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                return this.doI8Vector((LLVMI8Vector)fromNodeValue__);
            }
            if ((state & 0x80) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                return this.doI16Vector((LLVMI16Vector)fromNodeValue__);
            }
            if ((state & 0x100) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                return this.doI32Vector((LLVMI32Vector)fromNodeValue__);
            }
            if ((state & 0x200) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                return this.doFloatVector((LLVMFloatVector)fromNodeValue__);
            }
            if ((state & 0x400) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                return this.doI64Vector((LLVMI64Vector)fromNodeValue__);
            }
            if ((state & 0x800) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                return this.doDoubleVector((LLVMDoubleVector)fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private double executeAndSpecialize(Object fromNodeValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                InteropLibrary interop__;
                LLVMAsForeignLibrary foreigns__;
                Object fromNodeValue_;
                if (LLVMTypes.isManagedPointer(fromNodeValue) && LLVMToDoubleNode.isForeignNumber((LLVMManagedPointer)(fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue)), foreigns__ = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)), interop__ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(3)))) {
                    ManagedPointerData s1_ = (ManagedPointerData)super.insert((Node)new ManagedPointerData());
                    s1_.toLLVM_ = s1_.insertAccessor(this.createForeignToLLVM());
                    s1_.recursive_ = s1_.insertAccessor(this.createRecursive());
                    s1_.foreigns_ = s1_.insertAccessor(foreigns__);
                    s1_.interop_ = s1_.insertAccessor(interop__);
                    this.managedPointer_cache = s1_;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doManagedPointer((LLVMManagedPointer)fromNodeValue_, s1_.toLLVM_, s1_.recursive_, foreigns__, interop__);
                    return d;
                }
                if (LLVMTypes.isPointer(fromNodeValue)) {
                    fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                    this.pointer_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                    this.pointer_recursive_ = (LLVMToDoubleNode)super.insert((Node)this.createRecursive());
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doPointer((LLVMPointer)fromNodeValue_, this.pointer_toNative_, this.pointer_recursive_);
                    return d;
                }
                if (fromNodeValue instanceof Long) {
                    long fromNodeValue_2 = (Long)fromNodeValue;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doDouble(fromNodeValue_2);
                    return d;
                }
                if (fromNodeValue instanceof Double) {
                    double fromNodeValue_3 = (Double)fromNodeValue;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doDouble(fromNodeValue_3);
                    return d;
                }
                if (fromNodeValue instanceof Float) {
                    float fromNodeValue_4 = ((Float)fromNodeValue).floatValue();
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doFloat(fromNodeValue_4);
                    return d;
                }
                if (fromNodeValue instanceof LLVMI1Vector) {
                    fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doI1Vector((LLVMI1Vector)fromNodeValue_);
                    return d;
                }
                if (fromNodeValue instanceof LLVMI8Vector) {
                    fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                    this.state_ = state |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doI8Vector((LLVMI8Vector)fromNodeValue_);
                    return d;
                }
                if (fromNodeValue instanceof LLVMI16Vector) {
                    fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                    this.state_ = state |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doI16Vector((LLVMI16Vector)fromNodeValue_);
                    return d;
                }
                if (fromNodeValue instanceof LLVMI32Vector) {
                    fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                    this.state_ = state |= 0x100;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doI32Vector((LLVMI32Vector)fromNodeValue_);
                    return d;
                }
                if (fromNodeValue instanceof LLVMFloatVector) {
                    fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                    this.state_ = state |= 0x200;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doFloatVector((LLVMFloatVector)fromNodeValue_);
                    return d;
                }
                if (fromNodeValue instanceof LLVMI64Vector) {
                    fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                    this.state_ = state |= 0x400;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doI64Vector((LLVMI64Vector)fromNodeValue_);
                    return d;
                }
                if (fromNodeValue instanceof LLVMDoubleVector) {
                    fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                    this.state_ = state |= 0x800;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doDoubleVector((LLVMDoubleVector)fromNodeValue_);
                    return d;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToDoubleNode.LLVMBitcastToDoubleNode create(LLVMExpressionNode fromNode) {
            return new LLVMBitcastToDoubleNodeGen(fromNode);
        }

        @GeneratedBy(value=LLVMToDoubleNode.LLVMBitcastToDoubleNode.class)
        private static final class ManagedPointerData
        extends Node {
            @Node.Child
            ForeignToLLVM toLLVM_;
            @Node.Child
            LLVMToDoubleNode recursive_;
            @Node.Child
            LLVMAsForeignLibrary foreigns_;
            @Node.Child
            InteropLibrary interop_;

            ManagedPointerData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.class)
    public static final class LLVMUnsignedCastToDoubleNodeGen
    extends LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private ManagedPointerData managedPointer_cache;
        @Node.Child
        private LLVMToNativeNode pointer_toNative_;
        @Node.Child
        private LLVMToDoubleNode pointer_recursive_;

        private LLVMUnsignedCastToDoubleNodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected double executeWith(long fromNodeValue) {
            int state = this.state_;
            if ((state & 0x40) != 0) {
                return this.doDouble(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0xFB) == 0 && state != 0) {
                return this.executeGeneric_boolean0(frameValue, state);
            }
            if ((state & 0xF7) == 0 && state != 0) {
                return this.executeGeneric_byte1(frameValue, state);
            }
            if ((state & 0xEF) == 0 && state != 0) {
                return this.executeGeneric_short2(frameValue, state);
            }
            if ((state & 0xDF) == 0 && state != 0) {
                return this.executeGeneric_int3(frameValue, state);
            }
            if ((state & 0xBF) == 0 && state != 0) {
                return this.executeGeneric_long4(frameValue, state);
            }
            if ((state & 0x7F) == 0 && state != 0) {
                return this.executeGeneric_double5(frameValue, state);
            }
            return this.executeGeneric_generic6(frameValue, state);
        }

        private Object executeGeneric_boolean0(VirtualFrame frameValue, int state) {
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_byte1(VirtualFrame frameValue, int state) {
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 8) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_short2(VirtualFrame frameValue, int state) {
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x10) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_int3(VirtualFrame frameValue, int state) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x20) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_long4(VirtualFrame frameValue, int state) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x40) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_double5(VirtualFrame frameValue, int state) {
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x80) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_generic6(VirtualFrame frameValue, int state) {
            LLVMPointer fromNodeValue__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s1_ = this.managedPointer_cache;
                if (s1_ != null && LLVMToDoubleNode.isForeignNumber(fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                    return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.recursive_, s1_.foreigns_, s1_.interop_);
                }
            }
            if ((state & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer(fromNodeValue__, this.pointer_toNative_, this.pointer_recursive_);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof Boolean) {
                boolean fromNodeValue__2 = (Boolean)fromNodeValue_;
                return this.doDouble(fromNodeValue__2);
            }
            if ((state & 8) != 0 && fromNodeValue_ instanceof Byte) {
                byte fromNodeValue__3 = (Byte)fromNodeValue_;
                return this.doDouble(fromNodeValue__3);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof Short) {
                short fromNodeValue__4 = (Short)fromNodeValue_;
                return this.doDouble(fromNodeValue__4);
            }
            if ((state & 0x20) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__5 = (Integer)fromNodeValue_;
                return this.doDouble(fromNodeValue__5);
            }
            if ((state & 0x40) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__6 = (Long)fromNodeValue_;
                return this.doDouble(fromNodeValue__6);
            }
            if ((state & 0x80) != 0 && fromNodeValue_ instanceof Double) {
                double fromNodeValue__7 = (Double)fromNodeValue_;
                return this.doDouble(fromNodeValue__7);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0xFB) == 0 && state != 0) {
                return this.executeDouble_boolean7(frameValue, state);
            }
            if ((state & 0xF7) == 0 && state != 0) {
                return this.executeDouble_byte8(frameValue, state);
            }
            if ((state & 0xEF) == 0 && state != 0) {
                return this.executeDouble_short9(frameValue, state);
            }
            if ((state & 0xDF) == 0 && state != 0) {
                return this.executeDouble_int10(frameValue, state);
            }
            if ((state & 0xBF) == 0 && state != 0) {
                return this.executeDouble_long11(frameValue, state);
            }
            if ((state & 0x7F) == 0 && state != 0) {
                return this.executeDouble_double12(frameValue, state);
            }
            return this.executeDouble_generic13(frameValue, state);
        }

        private double executeDouble_boolean7(VirtualFrame frameValue, int state) {
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_byte8(VirtualFrame frameValue, int state) {
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 8) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_short9(VirtualFrame frameValue, int state) {
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x10) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_int10(VirtualFrame frameValue, int state) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x20) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_long11(VirtualFrame frameValue, int state) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x40) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_double12(VirtualFrame frameValue, int state) {
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x80) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_generic13(VirtualFrame frameValue, int state) {
            LLVMPointer fromNodeValue__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s1_ = this.managedPointer_cache;
                if (s1_ != null && LLVMToDoubleNode.isForeignNumber(fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                    return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.recursive_, s1_.foreigns_, s1_.interop_);
                }
            }
            if ((state & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer(fromNodeValue__, this.pointer_toNative_, this.pointer_recursive_);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof Boolean) {
                boolean fromNodeValue__2 = (Boolean)fromNodeValue_;
                return this.doDouble(fromNodeValue__2);
            }
            if ((state & 8) != 0 && fromNodeValue_ instanceof Byte) {
                byte fromNodeValue__3 = (Byte)fromNodeValue_;
                return this.doDouble(fromNodeValue__3);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof Short) {
                short fromNodeValue__4 = (Short)fromNodeValue_;
                return this.doDouble(fromNodeValue__4);
            }
            if ((state & 0x20) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__5 = (Integer)fromNodeValue_;
                return this.doDouble(fromNodeValue__5);
            }
            if ((state & 0x40) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__6 = (Long)fromNodeValue_;
                return this.doDouble(fromNodeValue__6);
            }
            if ((state & 0x80) != 0 && fromNodeValue_ instanceof Double) {
                double fromNodeValue__7 = (Double)fromNodeValue_;
                return this.doDouble(fromNodeValue__7);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private double executeAndSpecialize(Object fromNodeValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                InteropLibrary interop__;
                LLVMAsForeignLibrary foreigns__;
                LLVMPointer fromNodeValue_;
                if (LLVMTypes.isManagedPointer(fromNodeValue) && LLVMToDoubleNode.isForeignNumber(fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue), foreigns__ = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)), interop__ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(3)))) {
                    ManagedPointerData s1_ = (ManagedPointerData)super.insert((Node)new ManagedPointerData());
                    s1_.toLLVM_ = s1_.insertAccessor(this.createForeignToLLVM());
                    s1_.recursive_ = s1_.insertAccessor(this.createRecursive());
                    s1_.foreigns_ = s1_.insertAccessor(foreigns__);
                    s1_.interop_ = s1_.insertAccessor(interop__);
                    this.managedPointer_cache = s1_;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doManagedPointer((LLVMManagedPointer)fromNodeValue_, s1_.toLLVM_, s1_.recursive_, foreigns__, interop__);
                    return d;
                }
                if (LLVMTypes.isPointer(fromNodeValue)) {
                    fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                    this.pointer_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                    this.pointer_recursive_ = (LLVMToDoubleNode)super.insert((Node)this.createRecursive());
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doPointer(fromNodeValue_, this.pointer_toNative_, this.pointer_recursive_);
                    return d;
                }
                if (fromNodeValue instanceof Boolean) {
                    boolean fromNodeValue_2 = (Boolean)fromNodeValue;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doDouble(fromNodeValue_2);
                    return d;
                }
                if (fromNodeValue instanceof Byte) {
                    byte fromNodeValue_3 = (Byte)fromNodeValue;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doDouble(fromNodeValue_3);
                    return d;
                }
                if (fromNodeValue instanceof Short) {
                    short fromNodeValue_4 = (Short)fromNodeValue;
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doDouble(fromNodeValue_4);
                    return d;
                }
                if (fromNodeValue instanceof Integer) {
                    int fromNodeValue_5 = (Integer)fromNodeValue;
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doDouble(fromNodeValue_5);
                    return d;
                }
                if (fromNodeValue instanceof Long) {
                    long fromNodeValue_6 = (Long)fromNodeValue;
                    this.state_ = state |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doDouble(fromNodeValue_6);
                    return d;
                }
                if (fromNodeValue instanceof Double) {
                    double fromNodeValue_7 = (Double)fromNodeValue;
                    this.state_ = state |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doDouble(fromNodeValue_7);
                    return d;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode create(LLVMExpressionNode fromNode) {
            return new LLVMUnsignedCastToDoubleNodeGen(fromNode);
        }

        @GeneratedBy(value=LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.class)
        private static final class ManagedPointerData
        extends Node {
            @Node.Child
            ForeignToLLVM toLLVM_;
            @Node.Child
            LLVMToDoubleNode recursive_;
            @Node.Child
            LLVMAsForeignLibrary foreigns_;
            @Node.Child
            InteropLibrary interop_;

            ManagedPointerData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMToDoubleNode.LLVMSignedCastToDoubleNode.class)
    public static final class LLVMSignedCastToDoubleNodeGen
    extends LLVMToDoubleNode.LLVMSignedCastToDoubleNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private ManagedPointerData managedPointer_cache;
        @Node.Child
        private LLVMToNativeNode pointer_toNative_;
        @Node.Child
        private LLVMToDoubleNode pointer_recursive_;

        private LLVMSignedCastToDoubleNodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected double executeWith(long fromNodeValue) {
            int state = this.state_;
            if ((state & 0x40) != 0) {
                return this.doDouble(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0x3FB) == 0 && state != 0) {
                return this.executeGeneric_boolean0(frameValue, state);
            }
            if ((state & 0x3F7) == 0 && state != 0) {
                return this.executeGeneric_byte1(frameValue, state);
            }
            if ((state & 0x3EF) == 0 && state != 0) {
                return this.executeGeneric_short2(frameValue, state);
            }
            if ((state & 0x3DF) == 0 && state != 0) {
                return this.executeGeneric_int3(frameValue, state);
            }
            if ((state & 0x3BF) == 0 && state != 0) {
                return this.executeGeneric_long4(frameValue, state);
            }
            if ((state & 0x37F) == 0 && state != 0) {
                return this.executeGeneric_float5(frameValue, state);
            }
            if ((state & 0x2FF) == 0 && state != 0) {
                return this.executeGeneric_double6(frameValue, state);
            }
            return this.executeGeneric_generic7(frameValue, state);
        }

        private Object executeGeneric_boolean0(VirtualFrame frameValue, int state) {
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_byte1(VirtualFrame frameValue, int state) {
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 8) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_short2(VirtualFrame frameValue, int state) {
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x10) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_int3(VirtualFrame frameValue, int state) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x20) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_long4(VirtualFrame frameValue, int state) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x40) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_float5(VirtualFrame frameValue, int state) {
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x80) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_double6(VirtualFrame frameValue, int state) {
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x100) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_generic7(VirtualFrame frameValue, int state) {
            Object fromNodeValue__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s1_ = this.managedPointer_cache;
                if (s1_ != null && LLVMToDoubleNode.isForeignNumber((LLVMManagedPointer)fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                    return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.recursive_, s1_.foreigns_, s1_.interop_);
                }
            }
            if ((state & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer((LLVMPointer)fromNodeValue__, this.pointer_toNative_, this.pointer_recursive_);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof Boolean) {
                boolean fromNodeValue__2 = (Boolean)fromNodeValue_;
                return this.doDouble(fromNodeValue__2);
            }
            if ((state & 8) != 0 && fromNodeValue_ instanceof Byte) {
                byte fromNodeValue__3 = (Byte)fromNodeValue_;
                return this.doDouble(fromNodeValue__3);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof Short) {
                short fromNodeValue__4 = (Short)fromNodeValue_;
                return this.doDouble(fromNodeValue__4);
            }
            if ((state & 0x20) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__5 = (Integer)fromNodeValue_;
                return this.doDouble(fromNodeValue__5);
            }
            if ((state & 0x40) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__6 = (Long)fromNodeValue_;
                return this.doDouble(fromNodeValue__6);
            }
            if ((state & 0x80) != 0 && fromNodeValue_ instanceof Float) {
                float fromNodeValue__7 = ((Float)fromNodeValue_).floatValue();
                return this.doDouble(fromNodeValue__7);
            }
            if ((state & 0x100) != 0 && fromNodeValue_ instanceof Double) {
                double fromNodeValue__8 = (Double)fromNodeValue_;
                return this.doDouble(fromNodeValue__8);
            }
            if ((state & 0x200) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                return this.doDouble((LLVM80BitFloat)fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0x3FB) == 0 && state != 0) {
                return this.executeDouble_boolean8(frameValue, state);
            }
            if ((state & 0x3F7) == 0 && state != 0) {
                return this.executeDouble_byte9(frameValue, state);
            }
            if ((state & 0x3EF) == 0 && state != 0) {
                return this.executeDouble_short10(frameValue, state);
            }
            if ((state & 0x3DF) == 0 && state != 0) {
                return this.executeDouble_int11(frameValue, state);
            }
            if ((state & 0x3BF) == 0 && state != 0) {
                return this.executeDouble_long12(frameValue, state);
            }
            if ((state & 0x37F) == 0 && state != 0) {
                return this.executeDouble_float13(frameValue, state);
            }
            if ((state & 0x2FF) == 0 && state != 0) {
                return this.executeDouble_double14(frameValue, state);
            }
            return this.executeDouble_generic15(frameValue, state);
        }

        private double executeDouble_boolean8(VirtualFrame frameValue, int state) {
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_byte9(VirtualFrame frameValue, int state) {
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 8) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_short10(VirtualFrame frameValue, int state) {
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x10) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_int11(VirtualFrame frameValue, int state) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x20) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_long12(VirtualFrame frameValue, int state) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x40) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_float13(VirtualFrame frameValue, int state) {
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x80) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_double14(VirtualFrame frameValue, int state) {
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x100) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_generic15(VirtualFrame frameValue, int state) {
            Object fromNodeValue__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s1_ = this.managedPointer_cache;
                if (s1_ != null && LLVMToDoubleNode.isForeignNumber((LLVMManagedPointer)fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                    return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.recursive_, s1_.foreigns_, s1_.interop_);
                }
            }
            if ((state & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer((LLVMPointer)fromNodeValue__, this.pointer_toNative_, this.pointer_recursive_);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof Boolean) {
                boolean fromNodeValue__2 = (Boolean)fromNodeValue_;
                return this.doDouble(fromNodeValue__2);
            }
            if ((state & 8) != 0 && fromNodeValue_ instanceof Byte) {
                byte fromNodeValue__3 = (Byte)fromNodeValue_;
                return this.doDouble(fromNodeValue__3);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof Short) {
                short fromNodeValue__4 = (Short)fromNodeValue_;
                return this.doDouble(fromNodeValue__4);
            }
            if ((state & 0x20) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__5 = (Integer)fromNodeValue_;
                return this.doDouble(fromNodeValue__5);
            }
            if ((state & 0x40) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__6 = (Long)fromNodeValue_;
                return this.doDouble(fromNodeValue__6);
            }
            if ((state & 0x80) != 0 && fromNodeValue_ instanceof Float) {
                float fromNodeValue__7 = ((Float)fromNodeValue_).floatValue();
                return this.doDouble(fromNodeValue__7);
            }
            if ((state & 0x100) != 0 && fromNodeValue_ instanceof Double) {
                double fromNodeValue__8 = (Double)fromNodeValue_;
                return this.doDouble(fromNodeValue__8);
            }
            if ((state & 0x200) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                return this.doDouble((LLVM80BitFloat)fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private double executeAndSpecialize(Object fromNodeValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                InteropLibrary interop__;
                LLVMAsForeignLibrary foreigns__;
                Object fromNodeValue_;
                if (LLVMTypes.isManagedPointer(fromNodeValue) && LLVMToDoubleNode.isForeignNumber((LLVMManagedPointer)(fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue)), foreigns__ = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)), interop__ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(3)))) {
                    ManagedPointerData s1_ = (ManagedPointerData)super.insert((Node)new ManagedPointerData());
                    s1_.toLLVM_ = s1_.insertAccessor(this.createForeignToLLVM());
                    s1_.recursive_ = s1_.insertAccessor(this.createRecursive());
                    s1_.foreigns_ = s1_.insertAccessor(foreigns__);
                    s1_.interop_ = s1_.insertAccessor(interop__);
                    this.managedPointer_cache = s1_;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doManagedPointer((LLVMManagedPointer)fromNodeValue_, s1_.toLLVM_, s1_.recursive_, foreigns__, interop__);
                    return d;
                }
                if (LLVMTypes.isPointer(fromNodeValue)) {
                    fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                    this.pointer_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                    this.pointer_recursive_ = (LLVMToDoubleNode)super.insert((Node)this.createRecursive());
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doPointer((LLVMPointer)fromNodeValue_, this.pointer_toNative_, this.pointer_recursive_);
                    return d;
                }
                if (fromNodeValue instanceof Boolean) {
                    boolean fromNodeValue_2 = (Boolean)fromNodeValue;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doDouble(fromNodeValue_2);
                    return d;
                }
                if (fromNodeValue instanceof Byte) {
                    byte fromNodeValue_3 = (Byte)fromNodeValue;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doDouble(fromNodeValue_3);
                    return d;
                }
                if (fromNodeValue instanceof Short) {
                    short fromNodeValue_4 = (Short)fromNodeValue;
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doDouble(fromNodeValue_4);
                    return d;
                }
                if (fromNodeValue instanceof Integer) {
                    int fromNodeValue_5 = (Integer)fromNodeValue;
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doDouble(fromNodeValue_5);
                    return d;
                }
                if (fromNodeValue instanceof Long) {
                    long fromNodeValue_6 = (Long)fromNodeValue;
                    this.state_ = state |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doDouble(fromNodeValue_6);
                    return d;
                }
                if (fromNodeValue instanceof Float) {
                    float fromNodeValue_7 = ((Float)fromNodeValue).floatValue();
                    this.state_ = state |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doDouble(fromNodeValue_7);
                    return d;
                }
                if (fromNodeValue instanceof Double) {
                    double fromNodeValue_8 = (Double)fromNodeValue;
                    this.state_ = state |= 0x100;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doDouble(fromNodeValue_8);
                    return d;
                }
                if (fromNodeValue instanceof LLVM80BitFloat) {
                    fromNodeValue_ = (LLVM80BitFloat)fromNodeValue;
                    this.state_ = state |= 0x200;
                    lock.unlock();
                    hasLock = false;
                    double d = this.doDouble((LLVM80BitFloat)fromNodeValue_);
                    return d;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToDoubleNode.LLVMSignedCastToDoubleNode create(LLVMExpressionNode fromNode) {
            return new LLVMSignedCastToDoubleNodeGen(fromNode);
        }

        @GeneratedBy(value=LLVMToDoubleNode.LLVMSignedCastToDoubleNode.class)
        private static final class ManagedPointerData
        extends Node {
            @Node.Child
            ForeignToLLVM toLLVM_;
            @Node.Child
            LLVMToDoubleNode recursive_;
            @Node.Child
            LLVMAsForeignLibrary foreigns_;
            @Node.Child
            InteropLibrary interop_;

            ManagedPointerData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMToDoubleNode.class)
    private static final class ManagedPointerData
    extends Node {
        @Node.Child
        ForeignToLLVM toLLVM_;
        @Node.Child
        LLVMToDoubleNode recursive_;
        @Node.Child
        LLVMAsForeignLibrary foreigns_;
        @Node.Child
        InteropLibrary interop_;

        ManagedPointerData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

