/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.llvm.runtime.LLVMIVarBitLarge;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMTo80BitFloatingNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;

@NodeChild(value="fromNode", type=LLVMExpressionNode.class)
public abstract class LLVMTo80BitFloatingNode
extends LLVMExpressionNode {
    protected abstract LLVM80BitFloat executeWith(long var1);

    protected LLVMTo80BitFloatingNode createRecursive() {
        throw new IllegalStateException("abstract node LLVMTo80BitFloatingNode used");
    }

    @Specialization
    protected LLVM80BitFloat doPointer(LLVMPointer from, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative, @Cached(value="createRecursive()") LLVMTo80BitFloatingNode recursive) {
        long ptr = toNative.executeWithTarget(from).asNative();
        return recursive.executeWith(ptr);
    }

    @NodeChild(value="fromNode", type=LLVMExpressionNode.class)
    public static abstract class LLVMBitcastToLLVM80BitFloatNode
    extends LLVMTo80BitFloatingNode {
        @Override
        protected LLVMTo80BitFloatingNode createRecursive() {
            return LLVMTo80BitFloatingNodeGen.LLVMBitcastToLLVM80BitFloatNodeGen.create(null);
        }

        @Specialization
        protected LLVM80BitFloat doDouble(double from) {
            return LLVM80BitFloat.fromDouble(from);
        }

        @Specialization
        protected LLVM80BitFloat doLLVM80BitFloatNode(LLVM80BitFloat from) {
            return from;
        }

        @Specialization
        protected LLVM80BitFloat doIVarBit(LLVMIVarBitLarge from) {
            return LLVM80BitFloat.fromBytesBigEndian(from.getBytes());
        }

        @ExplodeLoop
        @Specialization
        protected LLVM80BitFloat doI1Vector(LLVMI1Vector from) {
            assert (from.getLength() == 80) : "invalid vector size";
            byte[] result = new byte[10];
            for (int i = 0; i < 10; ++i) {
                int value = 0;
                for (int j = 0; j < 8; ++j) {
                    value = (byte)((long)value | (from.getValue(i * 8 + j) ? 1L : 0L) << j);
                }
                result[i] = value;
            }
            return LLVM80BitFloat.fromBytes(result);
        }

        @ExplodeLoop
        @Specialization
        protected LLVM80BitFloat doI8Vector(LLVMI8Vector from) {
            assert (from.getLength() == 10) : "invalid vector size";
            byte[] values = new byte[10];
            for (int i = 0; i < 10; ++i) {
                values[i] = from.getValue(i);
            }
            return LLVM80BitFloat.fromBytes(values);
        }

        @ExplodeLoop
        @Specialization
        protected LLVM80BitFloat doI16Vector(LLVMI16Vector from) {
            assert (from.getLength() == 5) : "invalid vector size";
            byte[] values = new byte[10];
            for (int i = 0; i < 5; ++i) {
                values[i * 2] = (byte)(from.getValue(i) & 0xFF);
                values[i * 2 + 1] = (byte)(from.getValue(i) >>> 8 & 0xFF);
            }
            return LLVM80BitFloat.fromBytes(values);
        }
    }

    @NodeChild(value="fromNode", type=LLVMExpressionNode.class)
    public static abstract class LLVMUnsignedCastToLLVM80BitFloatNode
    extends LLVMTo80BitFloatingNode {
        @Override
        protected LLVMTo80BitFloatingNode createRecursive() {
            return LLVMTo80BitFloatingNodeGen.LLVMUnsignedCastToLLVM80BitFloatNodeGen.create(null);
        }

        @Specialization
        protected LLVM80BitFloat doLLVM80BitFloatNode(boolean from) {
            if (from) {
                return LLVM80BitFloat.fromUnsignedShort((short)1);
            }
            return LLVM80BitFloat.fromUnsignedShort((short)0);
        }

        @Specialization
        protected LLVM80BitFloat do80BitFloat(byte from) {
            return LLVM80BitFloat.fromUnsignedByte(from);
        }

        @Specialization
        protected LLVM80BitFloat do80BitFloat(short from) {
            return LLVM80BitFloat.fromUnsignedShort(from);
        }

        @Specialization
        protected LLVM80BitFloat doLLVM80BitFloatNode(int from) {
            return LLVM80BitFloat.fromUnsignedInt(from);
        }

        @Specialization
        protected LLVM80BitFloat doLLVM80BitFloatNode(long from) {
            return LLVM80BitFloat.fromUnsignedLong(from);
        }

        @Specialization
        protected LLVM80BitFloat doLLVM80BitFloatNode(float from) {
            return LLVM80BitFloat.fromFloat(from);
        }

        @Specialization
        protected LLVM80BitFloat doLLVM80BitFloatNode(double from) {
            return LLVM80BitFloat.fromDouble(from);
        }

        @Specialization
        protected LLVM80BitFloat doLLVM80BitFloatNode(LLVM80BitFloat from) {
            return from;
        }

        @Specialization
        protected LLVM80BitFloat doLLVM80BitFloatNode(LLVMIVarBitLarge from) {
            return LLVM80BitFloat.fromBytesBigEndian(from.getBytes());
        }
    }

    public static abstract class LLVMSignedCastToLLVM80BitFloatNode
    extends LLVMTo80BitFloatingNode {
        @Override
        protected LLVMTo80BitFloatingNode createRecursive() {
            return LLVMTo80BitFloatingNodeGen.LLVMSignedCastToLLVM80BitFloatNodeGen.create(null);
        }

        @Specialization
        protected LLVM80BitFloat doLLVM80BitFloatNode(boolean from) {
            if (from) {
                return LLVM80BitFloat.fromShort((short)1);
            }
            return LLVM80BitFloat.fromShort((short)0);
        }

        @Specialization
        protected LLVM80BitFloat do80BitFloat(byte from) {
            return LLVM80BitFloat.fromByte(from);
        }

        @Specialization
        protected LLVM80BitFloat doLLVM80BitFloatNode(short from) {
            return LLVM80BitFloat.fromShort(from);
        }

        @Specialization
        protected LLVM80BitFloat doLLVM80BitFloatNode(int from) {
            return LLVM80BitFloat.fromInt(from);
        }

        @Specialization
        protected LLVM80BitFloat doLLVM80BitFloatNode(long from) {
            return LLVM80BitFloat.fromLong(from);
        }

        @Specialization
        protected LLVM80BitFloat doLLVM80BitFloatNode(float from) {
            return LLVM80BitFloat.fromFloat(from);
        }

        @Specialization
        protected LLVM80BitFloat doLLVM80BitFloatNode(double from) {
            return LLVM80BitFloat.fromDouble(from);
        }

        @Specialization
        protected LLVM80BitFloat doLLVM80BitFloatNode(LLVM80BitFloat from) {
            return from;
        }

        @Specialization
        protected LLVM80BitFloat doLLVM80BitFloatNode(LLVMIVarBitLarge from) {
            return LLVM80BitFloat.fromBytesBigEndian(from.getBytes());
        }
    }
}

