/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.base;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.base.LLVMBasicBlockNode;

@GeneratedBy(value=LLVMBasicBlockNode.class)
final class LLVMBasicBlockNodeWrapper
extends LLVMBasicBlockNode
implements InstrumentableNode.WrapperNode {
    @Node.Child
    private LLVMBasicBlockNode delegateNode;
    @Node.Child
    private ProbeNode probeNode;

    LLVMBasicBlockNodeWrapper(LLVMBasicBlockNode other, LLVMBasicBlockNode delegateNode, ProbeNode probeNode) {
        super(other);
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    public LLVMBasicBlockNode getDelegateNode() {
        return this.delegateNode;
    }

    public ProbeNode getProbeNode() {
        return this.probeNode;
    }

    public NodeCost getCost() {
        return NodeCost.NONE;
    }

    @Override
    public void execute(VirtualFrame frame) {
        while (true) {
            boolean wasOnReturnExecuted = false;
            try {
                this.probeNode.onEnter(frame);
                this.delegateNode.execute(frame);
                wasOnReturnExecuted = true;
                this.probeNode.onReturnValue(frame, null);
            }
            catch (Throwable t) {
                Object result;
                if ((result = this.probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted)) == ProbeNode.UNWIND_ACTION_REENTER) continue;
                if (result != null) break;
                throw t;
            }
            break;
        }
    }

    @Override
    public LLVMSourceLocation getSourceLocation() {
        return this.delegateNode.getSourceLocation();
    }

    @Override
    public void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.delegateNode.setSourceLocation(sourceLocation);
    }

    @Override
    public LLVMBasicBlockNode initialize() {
        return this.delegateNode.initialize();
    }

    @Override
    public LLVMStatementNode[] getStatements() {
        return this.delegateNode.getStatements();
    }

    @Override
    public LLVMControlFlowNode getTerminatingInstruction() {
        return this.delegateNode.getTerminatingInstruction();
    }

    @Override
    public double getBranchProbability(int successorIndex) {
        return this.delegateNode.getBranchProbability(successorIndex);
    }

    @Override
    public void increaseBranchProbability(int successorIndex) {
        this.delegateNode.increaseBranchProbability(successorIndex);
    }

    @Override
    protected boolean isStatement() {
        return this.delegateNode.isStatement();
    }

    @Override
    protected void setStatement(boolean statementTag) {
        this.delegateNode.setStatement(statementTag);
    }
}

