/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.syscall;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.memory.LLVMSyscallOperationNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMSyscallNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMSyscallNode.class)
public final class LLVMSyscallNodeGen
extends LLVMSyscallNode {
    private LLVMSourceLocation sourceLocation;
    private boolean statement;
    @Node.Child
    private LLVMExpressionNode syscallNum_;
    @Node.Child
    private LLVMExpressionNode arg1_;
    @Node.Child
    private LLVMExpressionNode arg2_;
    @Node.Child
    private LLVMExpressionNode arg3_;
    @Node.Child
    private LLVMExpressionNode arg4_;
    @Node.Child
    private LLVMExpressionNode arg5_;
    @Node.Child
    private LLVMExpressionNode arg6_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;
    @Node.Child
    private CachedSyscallData cachedSyscall_cache;

    private LLVMSyscallNodeGen(LLVMExpressionNode syscallNum, LLVMExpressionNode arg1, LLVMExpressionNode arg2, LLVMExpressionNode arg3, LLVMExpressionNode arg4, LLVMExpressionNode arg5, LLVMExpressionNode arg6) {
        this.syscallNum_ = syscallNum;
        this.arg1_ = arg1;
        this.arg2_ = arg2;
        this.arg3_ = arg3;
        this.arg4_ = arg4;
        this.arg5_ = arg5;
        this.arg6_ = arg6;
    }

    @Override
    public LLVMSourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    protected boolean isStatement() {
        return this.statement;
    }

    @Override
    protected void setStatement(boolean statement) {
        this.statement = statement;
    }

    @Override
    @ExplodeLoop
    public Object executeGeneric(VirtualFrame frameValue) {
        long syscallNumValue_;
        int state = this.state_;
        try {
            syscallNumValue_ = this.syscallNum_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object arg1Value = this.arg1_.executeGeneric(frameValue);
            Object arg2Value = this.arg2_.executeGeneric(frameValue);
            Object arg3Value = this.arg3_.executeGeneric(frameValue);
            Object arg4Value = this.arg4_.executeGeneric(frameValue);
            Object arg5Value = this.arg5_.executeGeneric(frameValue);
            Object arg6Value = this.arg6_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }
        Object arg1Value_ = this.arg1_.executeGeneric(frameValue);
        Object arg2Value_ = this.arg2_.executeGeneric(frameValue);
        Object arg3Value_ = this.arg3_.executeGeneric(frameValue);
        Object arg4Value_ = this.arg4_.executeGeneric(frameValue);
        Object arg5Value_ = this.arg5_.executeGeneric(frameValue);
        Object arg6Value_ = this.arg6_.executeGeneric(frameValue);
        if (state != 0) {
            if ((state & 1) != 0) {
                CachedSyscallData s1_ = this.cachedSyscall_cache;
                while (s1_ != null) {
                    if (syscallNumValue_ == s1_.cachedSyscallNum_) {
                        TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                        LLVMContext context__ = (LLVMContext)lLVMLanguageContextReference__.get();
                        return this.cachedSyscall(syscallNumValue_, arg1Value_, arg2Value_, arg3Value_, arg4Value_, arg5Value_, arg6Value_, s1_.cachedSyscallNum_, s1_.node_, context__);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0) {
                return this.doI64(syscallNumValue_, arg1Value_, arg2Value_, arg3Value_, arg4Value_, arg5Value_, arg6Value_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(syscallNumValue_, arg1Value_, arg2Value_, arg3Value_, arg4Value_, arg5Value_, arg6Value_);
    }

    @Override
    @ExplodeLoop
    public long executeI64(VirtualFrame frameValue) {
        long syscallNumValue_;
        int state = this.state_;
        try {
            syscallNumValue_ = this.syscallNum_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object arg1Value = this.arg1_.executeGeneric(frameValue);
            Object arg2Value = this.arg2_.executeGeneric(frameValue);
            Object arg3Value = this.arg3_.executeGeneric(frameValue);
            Object arg4Value = this.arg4_.executeGeneric(frameValue);
            Object arg5Value = this.arg5_.executeGeneric(frameValue);
            Object arg6Value = this.arg6_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }
        Object arg1Value_ = this.arg1_.executeGeneric(frameValue);
        Object arg2Value_ = this.arg2_.executeGeneric(frameValue);
        Object arg3Value_ = this.arg3_.executeGeneric(frameValue);
        Object arg4Value_ = this.arg4_.executeGeneric(frameValue);
        Object arg5Value_ = this.arg5_.executeGeneric(frameValue);
        Object arg6Value_ = this.arg6_.executeGeneric(frameValue);
        if (state != 0) {
            if ((state & 1) != 0) {
                CachedSyscallData s1_ = this.cachedSyscall_cache;
                while (s1_ != null) {
                    if (syscallNumValue_ == s1_.cachedSyscallNum_) {
                        TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__1 = this.lLVMLanguageContextReference_;
                        LLVMContext context__ = (LLVMContext)lLVMLanguageContextReference__1.get();
                        return this.cachedSyscall(syscallNumValue_, arg1Value_, arg2Value_, arg3Value_, arg4Value_, arg5Value_, arg6Value_, s1_.cachedSyscallNum_, s1_.node_, context__);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0) {
                return this.doI64(syscallNumValue_, arg1Value_, arg2Value_, arg3Value_, arg4Value_, arg5Value_, arg6Value_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(syscallNumValue_, arg1Value_, arg2Value_, arg3Value_, arg4Value_, arg5Value_, arg6Value_);
    }

    private long executeAndSpecialize(Object syscallNumValue, Object arg1Value, Object arg2Value, Object arg3Value, Object arg4Value, Object arg5Value, Object arg6Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (syscallNumValue instanceof Long) {
                long syscallNumValue_ = (Long)syscallNumValue;
                LLVMContext context__ = null;
                if (exclude == 0) {
                    int count1_ = 0;
                    CachedSyscallData s1_ = this.cachedSyscall_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null) {
                            if (syscallNumValue_ == s1_.cachedSyscallNum_) {
                                TruffleLanguage.ContextReference lLVMLanguageContextReference__2 = this.lLVMLanguageContextReference_;
                                if (lLVMLanguageContextReference__2 == null) {
                                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__2 = super.lookupContextReference(LLVMLanguage.class);
                                }
                                context__ = (LLVMContext)lLVMLanguageContextReference__2.get();
                                break;
                            }
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 332) {
                        s1_ = (CachedSyscallData)super.insert((Node)new CachedSyscallData(this.cachedSyscall_cache));
                        s1_.cachedSyscallNum_ = syscallNumValue_;
                        s1_.node_ = s1_.insertAccessor(this.createNode(syscallNumValue_));
                        TruffleLanguage.ContextReference lLVMLanguageContextReference__3 = this.lLVMLanguageContextReference_;
                        if (lLVMLanguageContextReference__3 == null) {
                            this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__3 = super.lookupContextReference(LLVMLanguage.class);
                        }
                        context__ = (LLVMContext)lLVMLanguageContextReference__3.get();
                        this.cachedSyscall_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        long l = this.cachedSyscall(syscallNumValue_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s1_.cachedSyscallNum_, s1_.node_, context__);
                        return l;
                    }
                }
                this.exclude_ = exclude |= 1;
                this.cachedSyscall_cache = null;
                state &= 0xFFFFFFFE;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                long l = this.doI64(syscallNumValue_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                return l;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.syscallNum_, this.arg1_, this.arg2_, this.arg3_, this.arg4_, this.arg5_, this.arg6_}, new Object[]{syscallNumValue, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        CachedSyscallData s1_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s1_ = this.cachedSyscall_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMSyscallNode create(LLVMExpressionNode syscallNum, LLVMExpressionNode arg1, LLVMExpressionNode arg2, LLVMExpressionNode arg3, LLVMExpressionNode arg4, LLVMExpressionNode arg5, LLVMExpressionNode arg6) {
        return new LLVMSyscallNodeGen(syscallNum, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    @GeneratedBy(value=LLVMSyscallNode.class)
    private static final class CachedSyscallData
    extends Node {
        @Node.Child
        CachedSyscallData next_;
        @CompilerDirectives.CompilationFinal
        long cachedSyscallNum_;
        @Node.Child
        LLVMSyscallOperationNode node_;

        CachedSyscallData(CachedSyscallData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

