/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.syscall;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMStringHelper;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMStringHelper.class)
public final class LLVMStringHelperNodeGen
extends LLVMStringHelper {
    private static final LibraryFactory<LLVMManagedWriteLibrary> L_L_V_M_MANAGED_WRITE_LIBRARY_ = LibraryFactory.resolve(LLVMManagedWriteLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;
    @Node.Child
    private ManagedData managed_cache;

    private LLVMStringHelperNodeGen() {
    }

    @Override
    @ExplodeLoop
    public void execute(LLVMPointer arg0Value, long arg1Value, String arg2Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0 && LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__ = this.lLVMLanguageReference_;
                LLVMLanguage native_language__ = (LLVMLanguage)lLVMLanguageReference__.get();
                this.doNative(arg0Value_, arg1Value, arg2Value, native_language__);
                return;
            }
            if ((state & 2) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                ManagedData s2_ = this.managed_cache;
                while (s2_ != null) {
                    Object obj__ = arg0Value_.getObject();
                    if (s2_.write_.accepts(obj__)) {
                        this.doManaged(arg0Value_, arg1Value, arg2Value, obj__, s2_.write_);
                        return;
                    }
                    s2_ = s2_.next_;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private void executeAndSpecialize(LLVMPointer arg0Value, long arg1Value, String arg2Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            LLVMLanguage native_language__ = null;
            if (LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                TruffleLanguage.LanguageReference lLVMLanguageReference__1 = this.lLVMLanguageReference_;
                if (lLVMLanguageReference__1 == null) {
                    this.lLVMLanguageReference_ = lLVMLanguageReference__1 = super.lookupLanguageReference(LLVMLanguage.class);
                }
                native_language__ = (LLVMLanguage)lLVMLanguageReference__1.get();
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                this.doNative(arg0Value_, arg1Value, arg2Value, native_language__);
                return;
            }
            Object obj__ = null;
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                int count2_ = 0;
                ManagedData s2_ = this.managed_cache;
                if ((state & 2) != 0) {
                    while (s2_ != null && !s2_.write_.accepts(obj__ = arg0Value_.getObject())) {
                        s2_ = s2_.next_;
                        ++count2_;
                    }
                }
                if (s2_ == null && count2_ < 3) {
                    s2_ = (ManagedData)super.insert((Node)new ManagedData(this.managed_cache));
                    obj__ = arg0Value_.getObject();
                    s2_.write_ = (LLVMManagedWriteLibrary)s2_.insertAccessor(L_L_V_M_MANAGED_WRITE_LIBRARY_.create(obj__));
                    this.managed_cache = s2_;
                    this.state_ = state |= 2;
                }
                if (s2_ != null) {
                    lock.unlock();
                    hasLock = false;
                    this.doManaged(arg0Value_, arg1Value, arg2Value, obj__, s2_.write_);
                    return;
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        ManagedData s2_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s2_ = this.managed_cache) == null || s2_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMStringHelper create() {
        return new LLVMStringHelperNodeGen();
    }

    @GeneratedBy(value=LLVMStringHelper.class)
    private static final class ManagedData
    extends Node {
        @Node.Child
        ManagedData next_;
        @Node.Child
        LLVMManagedWriteLibrary write_;

        ManagedData(ManagedData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

